/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.util;

import com.ibm.etools.fm.jhost.core.model.FMHostJhost;
import com.ibm.etools.fm.ui.dialog.FMDialogWithText;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public abstract class RemoteServicesUI {
    private static final PDLogger logger = PDLogger.get(RemoteServicesUI.class);

    public static boolean validateRemoteSystem(final IPDHost source, final IPDHost dest) {
        final AtomicBoolean canClose = new AtomicBoolean();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    try {
                        if (!source.isSameSystem(dest)) {
                            canClose.set(FMHostJhost.isRMSupportedBetween((IPDHost)source, (IPDHost)dest, (IHowIsGoing)howIsGoing));
                            return;
                        }
                    }
                    catch (CommunicationException | InterruptedException e) {
                        logger.error(e);
                        FMDialogWithText.showResultDump((Result<StringBuffer>)new Result(e), true, 0);
                        canClose.set(false);
                        return;
                    }
                    canClose.set(true);
                }
            });
            if (!canClose.get()) {
                return false;
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException e) {
            return false;
        }
        return canClose.get();
    }
}

