/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.util;

import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.FMEditorInputWithTemplate;
import com.ibm.etools.fm.editor.template.FMTemplateEditorInput;
import com.ibm.etools.fm.editor.template.TemplateEditorDialog;
import com.ibm.etools.fm.editor.template1.FMTemplateEditorInput1;
import com.ibm.etools.fm.editor.template1.TemplateEditorDialog1;
import com.ibm.etools.fm.editor.template2.FMTemplateEditorInput2;
import com.ibm.etools.fm.editor.template2.TemplateEditorDialog2;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class EditorManagement {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(EditorManagement.class);

    public static void openTemplateEditorFromWorkerThread(IFile file, FMTemplateEditorInput fmiInput, IProgressMonitor monitor, boolean inDialog) {
        EditorManagement.openTemplateEditorFromWorkerThread(file, fmiInput, monitor, null, inDialog);
    }

    public static void openTemplateEditorFromWorkerThread(IFile file, FMTemplateEditorInput fmiInput, IProgressMonitor monitor, Object notifier, boolean inDialog) {
        EditorManagement.openTemplateEditorFromWorkerThread(file, fmiInput, monitor, notifier, null, inDialog);
    }

    public static void openTemplateEditorFromWorkerThread(final IFile file, final FMTemplateEditorInput fmiInput, final IProgressMonitor monitor, final Object notifier, final UUID uniqueKey, final boolean inDialog) {
        Objects.requireNonNull(file, "Must provide a non-null file.");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    file.refreshLocal(2, monitor);
                    if (inDialog) {
                        if (uniqueKey != null) {
                            TemplateEditorDialog dialog = new TemplateEditorDialog(fmiInput, notifier, uniqueKey);
                            dialog.open();
                        } else {
                            TemplateEditorDialog dialog = new TemplateEditorDialog(fmiInput, notifier);
                            dialog.open();
                        }
                    } else {
                        IWorkbenchPage page;
                        IDE.setDefaultEditor((IFile)fmiInput.getFile(), (String)"com.ibm.etools.fm.editor.template.TemplateEditor");
                        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (dw != null && (page = dw.getActivePage()) != null) {
                            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)fmiInput, (String)"com.ibm.etools.fm.editor.template.TemplateEditor");
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"An error occurred while opening an editor. See log.", (Throwable)e);
                }
            }
        });
    }

    public static void openTemplateEditorFromWorkerThread(final IFile file, final FMTemplateEditorInput1 fmiInput, final IProgressMonitor monitor, final boolean inDialog) {
        Objects.requireNonNull(file, "Must provide a non-null file");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    file.refreshLocal(2, monitor);
                    if (inDialog) {
                        TemplateEditorDialog1 dialog = new TemplateEditorDialog1(fmiInput);
                        dialog.open();
                    } else {
                        IWorkbenchPage page;
                        IDE.setDefaultEditor((IFile)fmiInput.getFile(), (String)"com.ibm.etools.fm.editor.template1.TemplateEditor1");
                        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (dw != null && (page = dw.getActivePage()) != null) {
                            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)fmiInput, (String)"com.ibm.etools.fm.editor.template1.TemplateEditor1");
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"An error occurred while opening an editor. See log.", (Throwable)e);
                }
            }
        });
    }

    public static void openTemplateEditorFromWorkerThread(final IFile file, final FMTemplateEditorInput2 fmiInput, final IProgressMonitor monitor, final boolean inDialog) {
        Objects.requireNonNull(file, "Must provide a non-null file");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    file.refreshLocal(2, monitor);
                    if (inDialog) {
                        TemplateEditorDialog2 dialog = new TemplateEditorDialog2(fmiInput);
                        dialog.open();
                    } else {
                        IWorkbenchPage page;
                        IDE.setDefaultEditor((IFile)fmiInput.getFile(), (String)"com.ibm.etools.fm.editor.template2.TemplateEditor2");
                        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (dw != null && (page = dw.getActivePage()) != null) {
                            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)fmiInput, (String)"com.ibm.etools.fm.editor.template2.TemplateEditor2");
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"An error occurred while opening an editor. See log.", (Throwable)e);
                }
            }
        });
    }

    public static void openFormattedEditorFromWorkerThread(final IFile file, final FMEditorInputWithTemplate fmiInput, final IProgressMonitor monitor) {
        Objects.requireNonNull(file, "Must provide a non-null file");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page;
                    file.refreshLocal(2, monitor);
                    String editorID = fmiInput.getSessionIdentifer().getSessionType() == AbstractSessionFormatted.SessionType.IMS ? "com.ibm.etools.fm.editor.formatted1.ImsEditor" : "com.ibm.etools.fm.editor.formatted.FormattedEditor";
                    IDE.setDefaultEditor((IFile)fmiInput.getFile(), (String)editorID);
                    IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (dw != null && (page = dw.getActivePage()) != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IEditorInput)fmiInput, (String)editorID);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"An error occurred while opening an editor. See log.", (Throwable)e);
                }
            }
        });
    }
}

