/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.prefs.ccsid;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.prefs.ccsid.EncodingMappingEntry;
import com.ibm.etools.fm.ui.prefs.ccsid.EncodingMappingList;
import com.ibm.etools.fm.ui.prefs.ccsid.InvalidCCSIDMappingException;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.nio.charset.Charset;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MappingDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Combo ccsidCombo = null;
    private Combo javaEncodingCombo = null;
    private Combo descriptionCombo = null;
    private EncodingMappingEntry mapping = null;

    public MappingDialog(EncodingMappingEntry mapping) {
        if (mapping != null) {
            try {
                this.mapping = new EncodingMappingEntry(mapping);
            }
            catch (InvalidCCSIDMappingException e) {
                logger.error((Throwable)e);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.CcsidMappingDialog_0);
        this.setMessage(Messages.CcsidMappingDialog_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.CcsidMappingDialog_2, (Object)GUI.grid.d.left1());
        this.ccsidCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.ccsidCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "ccsid");
        this.ccsidCombo.setEnabled(this.mapping == null);
        GUI.label.left((Composite)composite, (String)Messages.CcsidMappingDialog_3, (Object)GUI.grid.d.left1());
        this.javaEncodingCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.javaEncodingCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "javaEncoding");
        new AutoCompleteField((Control)this.javaEncodingCombo, (IControlContentAdapter)new ComboContentAdapter(), EncodingMappingList.getSupportedJavaEncodings());
        GUI.label.left((Composite)composite, (String)Messages.CcsidMappingDialog_4, (Object)GUI.grid.d.left1());
        this.descriptionCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.descriptionCombo, ((Object)((Object)this)).getClass().getCanonicalName() + Messages.CcsidMappingDialog_5);
        if (this.mapping != null) {
            this.ccsidCombo.setText("" + this.mapping.getCcsid());
            if (this.mapping.getEncoding() != null) {
                this.javaEncodingCombo.setText(this.mapping.getEncoding());
            }
            if (this.mapping.getDescription() != null) {
                this.descriptionCombo.setText(this.mapping.getDescription());
            }
        }
        return composite;
    }

    public boolean close() {
        if (this.getReturnCode() == 1) {
            return super.close();
        }
        this.setErrorMessage(null);
        if (!EncodingMappingEntry.isValidCcsid(this.ccsidCombo.getText().trim())) {
            this.setErrorMessage(Messages.CcsidMappingDialog_6);
            return false;
        }
        String trimmedEncoding = this.javaEncodingCombo.getText().trim();
        if (trimmedEncoding.isEmpty() || !Charset.isSupported(trimmedEncoding)) {
            this.setErrorMessage(Messages.CcsidMappingDialog_8);
            return false;
        }
        try {
            this.mapping = new EncodingMappingEntry(Integer.parseInt(this.ccsidCombo.getText().trim()), this.javaEncodingCombo.getText().trim(), this.descriptionCombo.getText().trim());
        }
        catch (NumberFormatException e) {
            logger.error((Throwable)e);
        }
        catch (InvalidCCSIDMappingException e) {
            logger.error((Throwable)e);
        }
        return super.close();
    }

    public EncodingMappingEntry getMappingInfoElement() {
        return this.mapping;
    }
}

