/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.prefs.ccsid;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.prefs.ccsid.EncodingMappingEntry;
import com.ibm.etools.fm.ui.prefs.ccsid.EncodingMappingList;
import com.ibm.etools.fm.ui.prefs.ccsid.MappingDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EncodingMappingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private TableViewer mappingTableViewer = null;
    private Button removeButton;
    private Button modifyButton;

    protected Control createContents(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.CcsidEncodingMappingPreferencePage_0, (Object)GUI.grid.d.left1());
        this.createMappingTable(composite);
        this.mappingTableViewer.refresh();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        EncodingMappingList.INSTANCE.addDefaultMappings();
        this.doButtonEnablement();
        this.mappingTableViewer.refresh();
        this.mappingTableViewer.getTable().setSelection(0);
    }

    public boolean performOk() {
        EncodingMappingList.INSTANCE.saveMappingToFile();
        return super.performOk();
    }

    protected void performApply() {
        EncodingMappingList.INSTANCE.saveMappingToFile();
        super.performApply();
    }

    public boolean performCancel() {
        EncodingMappingList.INSTANCE.reset();
        return super.performCancel();
    }

    private void createMappingTable(Composite parent) {
        GridData tableGridData = GUI.grid.d.fillAll();
        tableGridData.heightHint = 300;
        Composite tableComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)tableGridData);
        this.mappingTableViewer = new TableViewer(tableComposite, 68354);
        EncodingMappingPreferencePage.createMappingTableColumns(this.mappingTableViewer);
        Table table = this.mappingTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.mappingTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mappingTableViewer.setInput(EncodingMappingList.INSTANCE.getMappings());
        this.mappingTableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof EncodingMappingEntry && e2 instanceof EncodingMappingEntry) {
                    EncodingMappingEntry ce1 = (EncodingMappingEntry)e1;
                    EncodingMappingEntry ce2 = (EncodingMappingEntry)e2;
                    if (ce1.getCcsid() < ce2.getCcsid()) {
                        return -1;
                    }
                    if (ce1.getCcsid() > ce2.getCcsid()) {
                        return 1;
                    }
                }
                return 0;
            }
        });
        this.mappingTableViewer.getControl().setLayoutData((Object)GUI.grid.d.fillAll());
        this.createMappingButtons(tableComposite);
        this.mappingTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EncodingMappingPreferencePage.this.modifyMapping();
            }
        });
        this.mappingTableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    if (!EncodingMappingPreferencePage.this.isModelEmpty()) {
                        EncodingMappingPreferencePage.this.deleteMapping();
                    }
                } else if (e.keyCode == 0x1000009) {
                    EncodingMappingPreferencePage.this.addMapping();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.mappingTableViewer.refresh();
        this.mappingTableViewer.getTable().setSelection(0);
    }

    private void createMappingButtons(Composite parent) {
        Composite buttonsComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        Button addButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/add.gif"), (String)Messages.CcsidEncodingMappingPreferencePage_1, (Object)GUI.grid.d.left1());
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EncodingMappingPreferencePage.this.addMapping();
            }
        });
        this.removeButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/delete.gif"), (String)Messages.CcsidEncodingMappingPreferencePage_2, (Object)GUI.grid.d.left1());
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EncodingMappingPreferencePage.this.deleteMapping();
            }
        });
        this.modifyButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/editfield.gif"), (String)Messages.CcsidEncodingMappingPreferencePage_4, (Object)GUI.grid.d.left1());
        this.modifyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EncodingMappingPreferencePage.this.modifyMapping();
            }
        });
    }

    private void addMapping() {
        MappingDialog dialog = new MappingDialog(null);
        if (dialog.open() != 0) {
            return;
        }
        EncodingMappingEntry newMapping = dialog.getMappingInfoElement();
        EncodingMappingList.INSTANCE.set(newMapping);
        this.mappingTableViewer.refresh();
        this.mappingTableViewer.setSelection((ISelection)new StructuredSelection((Object)newMapping));
        this.doButtonEnablement();
    }

    private void deleteMapping() {
        StructuredSelection selection = (StructuredSelection)this.mappingTableViewer.getSelection();
        EncodingMappingEntry selected = (EncodingMappingEntry)selection.getFirstElement();
        if (selected == null) {
            PDDialogs.openInfoThreadSafe((String)Messages.CcsidEncodingMappingPreferencePage_3);
            return;
        }
        int selectionIndex = this.mappingTableViewer.getTable().getSelectionIndex();
        EncodingMappingList.INSTANCE.remove(selected);
        this.mappingTableViewer.refresh();
        if (selectionIndex < EncodingMappingList.INSTANCE.size()) {
            this.mappingTableViewer.getTable().setSelection(selectionIndex);
        } else if (selectionIndex - 1 >= 0) {
            this.mappingTableViewer.getTable().setSelection(selectionIndex - 1);
        }
        this.doButtonEnablement();
    }

    private void doButtonEnablement() {
        if (this.isModelEmpty()) {
            this.modifyButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.modifyButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        }
    }

    private void modifyMapping() {
        if (this.mappingTableViewer.getTable().getSelectionCount() == 1) {
            IStructuredSelection selection = (IStructuredSelection)this.mappingTableViewer.getSelection();
            EncodingMappingEntry entry = (EncodingMappingEntry)selection.getFirstElement();
            MappingDialog dialog = new MappingDialog(entry);
            if (dialog.open() != 0) {
                return;
            }
            EncodingMappingEntry newMapping = dialog.getMappingInfoElement();
            EncodingMappingList.INSTANCE.set(newMapping);
            this.mappingTableViewer.refresh();
            this.mappingTableViewer.setSelection((ISelection)new StructuredSelection((Object)newMapping));
        } else {
            PDDialogs.openInfoThreadSafe((String)Messages.CcsidEncodingMappingPreferencePage_5);
        }
    }

    private boolean isModelEmpty() {
        if (this.mappingTableViewer.getInput() instanceof List) {
            List mappings = (List)this.mappingTableViewer.getInput();
            return mappings.isEmpty();
        }
        return false;
    }

    private static void createMappingTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("CCSID", 150, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn("Java Encoding", 150, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn("Description", 300, viewer, 16384);
        viewer.setLabelProvider((IBaseLabelProvider)new CCSIDTableLabelProvider());
    }

    private static class CCSIDTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private CCSIDTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            EncodingMappingEntry encodingMappingEntry = (EncodingMappingEntry)element;
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(encodingMappingEntry.getCcsid());
                }
                case 1: {
                    return encodingMappingEntry.getEncoding();
                }
                case 2: {
                    return encodingMappingEntry.getDescription();
                }
            }
            return "";
        }
    }
}

