/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.prefs.ccsid;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.prefs.ccsid.EncodingMappingEntry;
import com.ibm.etools.fm.ui.prefs.ccsid.InvalidCCSIDMappingException;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public enum EncodingMappingList {
    INSTANCE;

    private static final PDLogger logger;
    private static final String CCSID_MAPPING_FILENAME = "mapping.xml";
    private static final String KEY_MAPPING_ROOT = "mappingRootInfo";
    private static final String KEY_MAPPING_INFO = "mappingInfo";
    private static final String KEY_CCSID = "ccsid";
    private static final String KEY_ENCODING = "encoding";
    private static final String KEY_DESCRIPTION = "description";
    private List<EncodingMappingEntry> currentMappingInformation = new ArrayList<EncodingMappingEntry>();
    private static String[] allowedNamesArray;

    static {
        logger = PDLogger.get(EncodingMappingList.class);
    }

    private EncodingMappingList() {
        this.loadMappings();
    }

    private void loadMappings() {
        this.currentMappingInformation.clear();
        File mappingsFile = new File(FMUIPlugin.getDefault().getStateLocation().append(CCSID_MAPPING_FILENAME).toString());
        if (mappingsFile.exists() && mappingsFile.canRead()) {
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (BufferedReader mementoReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(mappingsFile), StandardCharsets.UTF_8));){
                    XMLMemento mementoRoot = XMLMemento.createReadRoot((Reader)mementoReader);
                    this.processMapping(mementoRoot);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fnfe) {
                this.addDefaultMappings();
            }
            catch (IOException | WorkbenchException e) {
                logger.error((Object)"Failed to load CCSID mapping information from the file. Loading the default information.");
                this.addDefaultMappings();
            }
        } else {
            this.addDefaultMappings();
        }
    }

    public static List<EncodingMappingEntry> getDefaultMappings() {
        ArrayList<EncodingMappingEntry> mappings = new ArrayList<EncodingMappingEntry>();
        try {
            mappings.add(new EncodingMappingEntry("37", "Cp037", Messages.EncodingMappingList_37));
            mappings.add(new EncodingMappingEntry("273", "Cp273", Messages.EncodingMappingList_273));
            mappings.add(new EncodingMappingEntry("277", "Cp277", Messages.EncodingMappingList_277));
            mappings.add(new EncodingMappingEntry("278", "Cp278", Messages.EncodingMappingList_278));
            mappings.add(new EncodingMappingEntry("280", "Cp280", Messages.EncodingMappingList_280));
            mappings.add(new EncodingMappingEntry("284", "Cp284", Messages.EncodingMappingList_284));
            mappings.add(new EncodingMappingEntry("285", "Cp285", Messages.EncodingMappingList_285));
            mappings.add(new EncodingMappingEntry("297", "Cp297", Messages.EncodingMappingList_297));
            mappings.add(new EncodingMappingEntry("500", "Cp500", Messages.EncodingMappingList_500));
            mappings.add(new EncodingMappingEntry("813", "ISO8859_7", Messages.EncodingMappingList_813));
            mappings.add(new EncodingMappingEntry("819", "ISO8859_1", Messages.EncodingMappingList_819));
            mappings.add(new EncodingMappingEntry("870", "Cp870", Messages.EncodingMappingList_870));
            mappings.add(new EncodingMappingEntry("871", "Cp871", Messages.EncodingMappingList_871));
            mappings.add(new EncodingMappingEntry("874", "Cp874", Messages.EncodingMappingList_874));
            mappings.add(new EncodingMappingEntry("878", "KOI8_R", Messages.EncodingMappingList_878));
            mappings.add(new EncodingMappingEntry("897", "JIS0201", Messages.EncodingMappingList_897));
            mappings.add(new EncodingMappingEntry("912", "ISO8859_2", Messages.EncodingMappingList_912));
            mappings.add(new EncodingMappingEntry("913", "ISO8859_3", Messages.EncodingMappingList_913));
            mappings.add(new EncodingMappingEntry("914", "ISO8859_4", Messages.EncodingMappingList_914));
            mappings.add(new EncodingMappingEntry("915", "ISO8859_5", Messages.EncodingMappingList_915));
            mappings.add(new EncodingMappingEntry("916", "ISO8859_8", Messages.EncodingMappingList_916));
            mappings.add(new EncodingMappingEntry("918", "Cp918", Messages.EncodingMappingList_918));
            mappings.add(new EncodingMappingEntry("920", "ISO8859_9", Messages.EncodingMappingList_920));
            mappings.add(new EncodingMappingEntry("921", "Cp921", Messages.EncodingMappingList_921));
            mappings.add(new EncodingMappingEntry("923", "Cp923", Messages.EncodingMappingList_923));
            mappings.add(new EncodingMappingEntry("930", "Cp930", Messages.EncodingMappingList_930));
            mappings.add(new EncodingMappingEntry("932", "SJIS", ""));
            mappings.add(new EncodingMappingEntry("933", "Cp933", Messages.EncodingMappingList_933));
            mappings.add(new EncodingMappingEntry("935", "Cp935", Messages.EncodingMappingList_935));
            mappings.add(new EncodingMappingEntry("937", "Cp937", Messages.EncodingMappingList_937));
            mappings.add(new EncodingMappingEntry("939", "Cp939", Messages.EncodingMappingList_939));
            mappings.add(new EncodingMappingEntry("943", "Cp943", Messages.EncodingMappingList_943));
            mappings.add(new EncodingMappingEntry("950", "Big5", Messages.EncodingMappingList_950));
            mappings.add(new EncodingMappingEntry("952", "JIS0208", Messages.EncodingMappingList_952));
            mappings.add(new EncodingMappingEntry("953", "JIS0212", Messages.EncodingMappingList_953));
            mappings.add(new EncodingMappingEntry("970", "Cp970", Messages.EncodingMappingList_970));
            mappings.add(new EncodingMappingEntry("1006", "Cp1006", Messages.EncodingMappingList_1006));
            mappings.add(new EncodingMappingEntry("1025", "Cp1025", Messages.EncodingMappingList_1025));
            mappings.add(new EncodingMappingEntry("1026", "Cp1026", Messages.EncodingMappingList_1026));
            mappings.add(new EncodingMappingEntry("1047", "Cp1047", Messages.EncodingMappingList_1047));
            mappings.add(new EncodingMappingEntry("1097", "Cp1097", Messages.EncodingMappingList_1097));
            mappings.add(new EncodingMappingEntry("1098", "Cp1098", Messages.EncodingMappingList_1098));
            mappings.add(new EncodingMappingEntry("1112", "Cp1112", Messages.EncodingMappingList_1112));
            mappings.add(new EncodingMappingEntry("1122", "Cp1122", Messages.EncodingMappingList_1122));
            mappings.add(new EncodingMappingEntry("1123", "Cp1123", Messages.EncodingMappingList_1123));
            mappings.add(new EncodingMappingEntry("1124", "Cp1124", Messages.EncodingMappingList_1124));
            mappings.add(new EncodingMappingEntry("1140", "Cp1140", Messages.EncodingMappingList_1140));
            mappings.add(new EncodingMappingEntry("1141", "Cp1141", Messages.EncodingMappingList_1141));
            mappings.add(new EncodingMappingEntry("1142", "Cp1142", Messages.EncodingMappingList_1142));
            mappings.add(new EncodingMappingEntry("1143", "Cp1143", Messages.EncodingMappingList_1143));
            mappings.add(new EncodingMappingEntry("1144", "Cp1144", Messages.EncodingMappingList_1144));
            mappings.add(new EncodingMappingEntry("1145", "Cp1145", Messages.EncodingMappingList_1145));
            mappings.add(new EncodingMappingEntry("1146", "Cp1146", Messages.EncodingMappingList_1146));
            mappings.add(new EncodingMappingEntry("1147", "Cp1147", Messages.EncodingMappingList_1147));
            mappings.add(new EncodingMappingEntry("1148", "Cp1148", Messages.EncodingMappingList_1148));
            mappings.add(new EncodingMappingEntry("1149", "Cp1149", Messages.EncodingMappingList_1149));
            mappings.add(new EncodingMappingEntry("1200", "UTF-16BE", Messages.EncodingMappingList_1200));
            mappings.add(new EncodingMappingEntry("1202", "UTF-16", Messages.EncodingMappingList_1202));
            mappings.add(new EncodingMappingEntry("1208", "UTF-8", Messages.EncodingMappingList_1208));
            mappings.add(new EncodingMappingEntry("1232", "UTF-32", Messages.EncodingMappingList_1232));
            mappings.add(new EncodingMappingEntry("1233", "UTF-32BE", Messages.EncodingMappingList_1233));
            mappings.add(new EncodingMappingEntry("1235", "UTF-32LE", Messages.EncodingMappingList_1235));
            mappings.add(new EncodingMappingEntry("1237", "UTF-32", Messages.EncodingMappingList_1237));
            mappings.add(new EncodingMappingEntry("1250", "Cp1250", Messages.EncodingMappingList_1250));
            mappings.add(new EncodingMappingEntry("1251", "Cp1251", Messages.EncodingMappingList_1251));
            mappings.add(new EncodingMappingEntry("1252", "Cp1252", Messages.EncodingMappingList_1252));
            mappings.add(new EncodingMappingEntry("1253", "Cp1253", Messages.EncodingMappingList_1253));
            mappings.add(new EncodingMappingEntry("1254", "Cp1254", Messages.EncodingMappingList_1254));
            mappings.add(new EncodingMappingEntry("1256", "Cp1256", Messages.EncodingMappingList_1256));
            mappings.add(new EncodingMappingEntry("1257", "Cp1257", Messages.EncodingMappingList_1257));
            mappings.add(new EncodingMappingEntry("1381", "Cp1381", Messages.EncodingMappingList_1381));
            mappings.add(new EncodingMappingEntry("1386", "GBK", Messages.EncodingMappingList_1386));
            try {
                mappings.add(new EncodingMappingEntry("1390", "cp1390", Messages.EncodingMappingList_1390));
            }
            catch (InvalidCCSIDMappingException invalidCCSIDMappingException) {
                // empty catch block
            }
            try {
                mappings.add(new EncodingMappingEntry("1399", "cp1399", Messages.EncodingMappingList_1399));
            }
            catch (InvalidCCSIDMappingException invalidCCSIDMappingException) {
                // empty catch block
            }
            try {
                mappings.add(new EncodingMappingEntry("33722", "Cp33722", Messages.EncodingMappingList_33722));
            }
            catch (InvalidCCSIDMappingException invalidCCSIDMappingException) {}
        }
        catch (InvalidCCSIDMappingException e) {
            if (logger != null) {
                logger.error((Throwable)e);
            }
            System.err.println(EncodingMappingList.class.getCanonicalName() + ": " + String.valueOf(e));
        }
        return mappings;
    }

    public void addDefaultMappings() {
        this.currentMappingInformation.clear();
        this.currentMappingInformation.addAll(EncodingMappingList.getDefaultMappings());
    }

    public String getJavaEncoding(String ccsid) {
        if (EncodingMappingEntry.isValidCcsid(ccsid)) {
            int parsedCCSID = Integer.parseInt(ccsid);
            for (EncodingMappingEntry currentMapping : this.currentMappingInformation) {
                if (parsedCCSID != currentMapping.getCcsid()) continue;
                return currentMapping.getEncoding();
            }
        } else {
            logger.error((Object)MessageFormat.format("Invalid CCSID specified: {0}", ccsid));
        }
        return null;
    }

    public int set(EncodingMappingEntry entry) {
        for (EncodingMappingEntry mapping : this.currentMappingInformation) {
            if (!entry.equals(mapping)) continue;
            this.currentMappingInformation.remove(mapping);
            break;
        }
        this.currentMappingInformation.add(entry);
        return this.currentMappingInformation.indexOf(entry);
    }

    public void saveMappingToFile() {
        String path;
        if (this.currentMappingInformation == null) {
            return;
        }
        XMLMemento rootMemento = XMLMemento.createWriteRoot((String)KEY_MAPPING_ROOT);
        for (EncodingMappingEntry aMapping : this.currentMappingInformation) {
            IMemento aChild = rootMemento.createChild(KEY_MAPPING_INFO);
            aChild.putInteger(KEY_CCSID, aMapping.getCcsid());
            aChild.putString(KEY_ENCODING, aMapping.getEncoding());
            aChild.putString(KEY_DESCRIPTION, aMapping.getDescription());
        }
        try {
            path = FMUIPlugin.getDefault().getStateLocation().append(CCSID_MAPPING_FILENAME).toString();
        }
        catch (IllegalStateException e) {
            logger.warn((Object)"Failed to ascertain plugin data location", (Throwable)e);
            return;
        }
        try {
            Throwable e = null;
            Object var4_7 = null;
            try (BufferedWriter mementoWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8));){
                rootMemento.save((Writer)mementoWriter);
                logger.trace((Object)("Saved content to file:\n" + path + "\n"));
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    public void processMapping(XMLMemento root) {
        IMemento[] mappings;
        IMemento[] iMementoArray = mappings = root.getChildren(KEY_MAPPING_INFO);
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            String desc;
            String encoding;
            IMemento aMapping = iMementoArray[n2];
            Integer ccsid = aMapping.getInteger(KEY_CCSID);
            if (ccsid == null) {
                ccsid = -1;
            }
            if ((encoding = aMapping.getString(KEY_ENCODING)) == null) {
                encoding = "";
            }
            if ((desc = aMapping.getString(KEY_DESCRIPTION)) == null) {
                desc = "";
            }
            try {
                this.currentMappingInformation.add(new EncodingMappingEntry(ccsid, encoding, desc));
            }
            catch (InvalidCCSIDMappingException e) {
                logger.error((Throwable)e);
            }
            ++n2;
        }
    }

    public void reset() {
        this.loadMappings();
    }

    public void remove(EncodingMappingEntry entry) {
        this.currentMappingInformation.remove(entry);
    }

    public int size() {
        return this.currentMappingInformation.size();
    }

    public List<EncodingMappingEntry> getMappings() {
        return this.currentMappingInformation;
    }

    public String[] getCcsids() {
        String[] ccsids = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            ccsids[i] = String.valueOf(this.currentMappingInformation.get(i).getCcsid());
            ++i;
        }
        return ccsids;
    }

    public static synchronized String[] getSupportedJavaEncodings() {
        if (allowedNamesArray == null) {
            SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
            Collection<Charset> values = availableCharsets.values();
            ArrayList<String> allowedNames = new ArrayList<String>();
            for (Charset value : values) {
                allowedNames.add(value.name());
                Set<String> aliases = value.aliases();
                for (String alias : aliases) {
                    allowedNames.add(alias);
                }
            }
            Collections.sort(allowedNames);
            allowedNamesArray = allowedNames.toArray(new String[allowedNames.size()]);
        }
        return Arrays.copyOf(allowedNamesArray, allowedNamesArray.length);
    }
}

