/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.prefs.ccsid;

import com.ibm.etools.fm.ui.prefs.ccsid.InvalidCCSIDMappingException;
import java.nio.charset.Charset;

public class EncodingMappingEntry {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private int ccsid;
    private String encoding;
    private String description;

    public EncodingMappingEntry(int ccsid, String encoding, String description) throws InvalidCCSIDMappingException {
        this.validateMapping(ccsid, encoding, description);
    }

    public EncodingMappingEntry(String ccsid, String encoding, String description) throws InvalidCCSIDMappingException {
        try {
            this.validateMapping(Integer.parseInt(ccsid), encoding, description);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidCCSIDMappingException("Specified CCSID is not numeric '" + ccsid + "'");
        }
    }

    private void validateMapping(int ccsid, String encoding, String description) throws InvalidCCSIDMappingException {
        if (!EncodingMappingEntry.isValidCcsid("" + ccsid)) {
            throw new InvalidCCSIDMappingException("Specified CCSID is not valid '" + ccsid + "'");
        }
        this.ccsid = ccsid;
        if (encoding == null || encoding.isEmpty() || !Charset.isSupported(encoding.trim())) {
            throw new InvalidCCSIDMappingException("Invalid encoding value: '" + encoding + "'");
        }
        this.encoding = encoding;
        this.description = description != null ? description : "";
    }

    public EncodingMappingEntry(EncodingMappingEntry mapping) throws InvalidCCSIDMappingException {
        if (mapping == null) {
            throw new InvalidCCSIDMappingException("Can not use a null Encoding Mapping to make an Encoding Mapping");
        }
        this.ccsid = mapping.getCcsid();
        this.encoding = mapping.getEncoding();
        this.description = mapping.getDescription();
    }

    public int getCcsid() {
        return this.ccsid;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (o instanceof EncodingMappingEntry) {
            EncodingMappingEntry entry = (EncodingMappingEntry)o;
            return entry.ccsid == this.ccsid;
        }
        return false;
    }

    public int hashCode() {
        return this.ccsid;
    }

    public static boolean isValidCcsid(String ccsidStr) {
        if (ccsidStr != null && !ccsidStr.isEmpty()) {
            try {
                int ccsid = Integer.parseInt(ccsidStr);
                if (ccsid >= 0 && ccsid <= 65535) {
                    return true;
                }
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }
}

