/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.prefs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SystemOptionsDialog
extends BaseTitleAreaDialog {
    private IPDHost aHost;
    private Text padText;
    private Button notTrunc;
    public static final String PREF_SYSTEM_OPTS = "com.ibm.etools.fm.ui.prefs.sysopts";
    public static final String PREF_SYSTEM_PAD_NODE = "pad";
    public static final String PREF_SYSTEM_NOTRUNC_NODE = "notrunc";
    public static final String DEFAULT_PADVAL = "ON";
    public static final String DEFAULT_NOTRUNCVAL = "YES";

    public SystemOptionsDialog(IPDHost aHost) {
        this.aHost = aHost;
    }

    protected Composite createDialogContent(Composite parent) {
        this.setTitle(Messages.SytemOptionsDialog_0);
        this.setMessage(Messages.SytemOptionsDialog_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group group = GUI.group((Composite)composite, (String)Messages.SystemOptionsDialog_2, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Composite dataRepAndConvOptComposite = GUI.composite((Composite)group, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)dataRepAndConvOptComposite, (String)"PAD", (Object)GUI.grid.d.left1());
        this.padText = GUI.text((Composite)dataRepAndConvOptComposite, (Object)GUI.grid.d.fillH((int)1), (int)4);
        GUI.label.left((Composite)dataRepAndConvOptComposite, (String)"NOTRUNC", (Object)GUI.grid.d.left1());
        this.notTrunc = GUI.button((Composite)dataRepAndConvOptComposite, (String)"", (Object)GUI.grid.d.fillH((int)1), (int)32);
        IEclipsePreferences systemOptsPrefs = InstanceScope.INSTANCE.getNode(PREF_SYSTEM_OPTS);
        Preferences node = systemOptsPrefs.node(this.aHost.getDescription());
        String padVal = node.get(PREF_SYSTEM_PAD_NODE, DEFAULT_PADVAL);
        String notTruncVal = node.get(PREF_SYSTEM_NOTRUNC_NODE, DEFAULT_NOTRUNCVAL);
        this.padText.setText(padVal);
        if (notTruncVal.equals(DEFAULT_NOTRUNCVAL)) {
            this.notTrunc.setSelection(true);
        }
        return composite;
    }

    protected void okPressed() {
        String padVal = this.padText.getText().trim();
        if (!(padVal.equals(DEFAULT_PADVAL) || padVal.equals("OFF") || padVal.equals("c"))) {
            this.setErrorMessage(Messages.SystemOptionsPADVal);
            return;
        }
        String notTruncVal = "NO";
        if (this.notTrunc.getSelection()) {
            notTruncVal = DEFAULT_NOTRUNCVAL;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PREF_SYSTEM_OPTS);
        Preferences sub1 = preferences.node(this.aHost.getDescription());
        sub1.put(PREF_SYSTEM_PAD_NODE, padVal);
        sub1.put(PREF_SYSTEM_NOTRUNC_NODE, notTruncVal);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e2) {
            e2.printStackTrace();
        }
        super.okPressed();
    }
}

