/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.prefs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PrintOptionsDialog
extends BaseTitleAreaDialog {
    private IPDHost aHost;
    private Combo recLengthCombo;
    private Combo pageSkipCombo;
    private Combo printCharCombo;
    private Combo dataHeaderCombo;
    private Combo headerPageCombo;
    private Combo dumpPageCombo;
    private Text pageSizeText;
    private Text recLimit;
    public static final String PREF_PRINT_OPTS = "com.ibm.etools.fm.ui.prefs.prtopts";
    public static final String PREF_PRINT_REC_LENGTH = "reclength";
    public static final String PREF_PRINT_PAGE_SKIP = "pageskip";
    public static final String PREF_PRINT_PAGE_TRANS = "pagetrans";
    public static final String PREF_PRINT_DATAHDR = "datahdr";
    public static final String PREF_HEADER_PAGE = "headerpage";
    public static final String PREF_PRINT_DUMP = "dump";
    public static final String PREF_PRINT_PAGESIZE = "pagesize";
    public static final String PREF_PRINT_RECLIMIT = "reclimit";
    public static final String DEFAULT_REC_LENGTH = "80";
    public static final String DEFAULT_YES_NO = "YES";
    public static final String DEFAULT_ON_OFF = "ON";
    public static final String DEFAULT_DUMP = "UPDOWN";
    public static final String DEFAULT_PAGESIZE = "60";
    public static final String DEFAULT_RECLIMIT = "(1,*)";

    public PrintOptionsDialog(IPDHost aHost) {
        this.aHost = aHost;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.PrintOptionsDialog_0);
        this.setMessage(Messages.PrintOptionsDialog_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group printOptgroup = GUI.group((Composite)composite, (String)Messages.PrintOptionsDialog_0, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Object[] recLengths = new String[]{DEFAULT_REC_LENGTH, "132"};
        GUI.label.left((Composite)printOptgroup, (String)"PRINTLEN", (Object)GUI.grid.d.left1());
        this.recLengthCombo = GUI.combo.readOnly((Composite)printOptgroup, (Object)GUI.grid.d.fillH((int)1), (Object[])recLengths);
        this.recLengthCombo.select(0);
        Object[] pageSkip = new String[]{DEFAULT_YES_NO, "NO"};
        GUI.label.left((Composite)printOptgroup, (String)"PAGESKIP", (Object)GUI.grid.d.left1());
        this.pageSkipCombo = GUI.combo.readOnly((Composite)printOptgroup, (Object)GUI.grid.d.fillH((int)1), (Object[])pageSkip);
        this.pageSkipCombo.select(0);
        Object[] prttrans = new String[]{DEFAULT_ON_OFF, "OFF"};
        GUI.label.left((Composite)printOptgroup, (String)"PRTTRANS", (Object)GUI.grid.d.left1());
        this.printCharCombo = GUI.combo.readOnly((Composite)printOptgroup, (Object)GUI.grid.d.fillH((int)1), (Object[])prttrans);
        this.printCharCombo.select(0);
        Object[] dataPrefix = new String[]{DEFAULT_YES_NO, "NO"};
        GUI.label.left((Composite)printOptgroup, (String)"DATAHDR", (Object)GUI.grid.d.left1());
        this.dataHeaderCombo = GUI.combo.readOnly((Composite)printOptgroup, (Object)GUI.grid.d.fillH((int)1), (Object[])dataPrefix);
        this.dataHeaderCombo.select(0);
        Object[] headerPage = new String[]{DEFAULT_YES_NO, "NO"};
        GUI.label.left((Composite)printOptgroup, (String)"HEADERPG", (Object)GUI.grid.d.left1());
        this.headerPageCombo = GUI.combo.readOnly((Composite)printOptgroup, (Object)GUI.grid.d.fillH((int)1), (Object[])headerPage);
        this.dataHeaderCombo.select(0);
        Group dumpFormatGrp = GUI.group((Composite)composite, (String)"Dump format", (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Object[] dump = new String[]{DEFAULT_DUMP, "ACROSS"};
        GUI.label.left((Composite)dumpFormatGrp, (String)"DUMP", (Object)GUI.grid.d.left1());
        this.dumpPageCombo = GUI.combo.readOnly((Composite)dumpFormatGrp, (Object)GUI.grid.d.fillH((int)1), (Object[])dump);
        this.dumpPageCombo.select(0);
        Composite misComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)misComposite, (String)"PAGESIZE", (Object)GUI.grid.d.left1());
        this.pageSizeText = GUI.text((Composite)misComposite, (Object)GUI.grid.d.fillH((int)1), (int)4);
        GUI.label.left((Composite)misComposite, (String)"RECLIMIT", (Object)GUI.grid.d.left1());
        this.recLimit = GUI.text((Composite)misComposite, (Object)GUI.grid.d.fillH((int)1), (int)4);
        this.recLimit.setText(DEFAULT_RECLIMIT);
        IEclipsePreferences systemOptsPrefs = InstanceScope.INSTANCE.getNode(PREF_PRINT_OPTS);
        Preferences node = systemOptsPrefs.node(this.aHost.getDescription());
        String recLengthVal = node.get(PREF_PRINT_REC_LENGTH, DEFAULT_REC_LENGTH);
        String pageSkipVal = node.get(PREF_PRINT_PAGE_SKIP, DEFAULT_YES_NO);
        String pageTransVal = node.get(PREF_PRINT_PAGE_TRANS, DEFAULT_ON_OFF);
        String dataHdrVal = node.get(PREF_PRINT_DATAHDR, DEFAULT_YES_NO);
        String headerPageVal = node.get(PREF_HEADER_PAGE, DEFAULT_YES_NO);
        String dumpPageVal = node.get(PREF_PRINT_DUMP, DEFAULT_DUMP);
        String pageSizeVal = node.get(PREF_PRINT_PAGESIZE, DEFAULT_PAGESIZE);
        String recLimitVal = node.get(PREF_PRINT_RECLIMIT, DEFAULT_RECLIMIT);
        this.recLengthCombo.setText(recLengthVal);
        this.pageSkipCombo.setText(pageSkipVal);
        this.printCharCombo.setText(pageTransVal);
        this.dataHeaderCombo.setText(dataHdrVal);
        this.headerPageCombo.setText(headerPageVal);
        this.dumpPageCombo.setText(dumpPageVal);
        this.pageSizeText.setText(pageSizeVal);
        this.recLimit.setText(recLimitVal);
        return composite;
    }

    protected void okPressed() {
        String recLengthVal = this.recLengthCombo.getText();
        String pageSkipVal = this.pageSkipCombo.getText();
        String pageTransVal = this.printCharCombo.getText();
        String dataHdrVal = this.dataHeaderCombo.getText();
        String headerPageVal = this.headerPageCombo.getText();
        String dumpPageVal = this.dumpPageCombo.getText();
        String pageSizeVal = this.pageSizeText.getText();
        String recLimitVal = this.recLimit.getText();
        try {
            int linesPerPage = Integer.parseInt(pageSizeVal);
            if (linesPerPage < 1 && linesPerPage > 999) {
                this.setErrorMessage(Messages.PrintOptionsDialog_2);
                return;
            }
        }
        catch (NumberFormatException ex) {
            this.setErrorMessage(Messages.PrintOptionsDialog_3);
            return;
        }
        if (!recLimitVal.substring(0, 1).equals("(") || !recLimitVal.substring(recLimitVal.length() - 1, recLimitVal.length()).equals(")")) {
            this.setErrorMessage(Messages.PrintOptionsDialog_4);
            return;
        }
        Matcher m = Pattern.compile("\\((.*?)\\)").matcher(recLimitVal);
        String str = "";
        while (m.find()) {
            str = m.group(1);
        }
        if (str.isEmpty()) {
            this.setErrorMessage(Messages.PrintOptionsDialog_4);
            return;
        }
        if (!str.contains(",")) {
            this.setErrorMessage(Messages.PrintOptionsDialog_4);
            return;
        }
        String[] split = str.split(",");
        if (split.length > 2) {
            this.setErrorMessage(Messages.PrintOptionsDialog_4);
            return;
        }
        try {
            Integer.parseInt(split[0].trim());
        }
        catch (NumberFormatException ex) {
            this.setErrorMessage(Messages.PrintOptionsDialog_3);
            return;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PREF_PRINT_OPTS);
        Preferences printNode = preferences.node(this.aHost.getDescription());
        printNode.put(PREF_PRINT_REC_LENGTH, recLengthVal);
        printNode.put(PREF_PRINT_PAGE_SKIP, pageSkipVal);
        printNode.put(PREF_PRINT_PAGE_TRANS, pageTransVal);
        printNode.put(PREF_PRINT_DATAHDR, dataHdrVal);
        printNode.put(PREF_HEADER_PAGE, headerPageVal);
        printNode.put(PREF_PRINT_DUMP, dumpPageVal);
        printNode.put(PREF_PRINT_PAGESIZE, pageSizeVal);
        printNode.put(PREF_PRINT_RECLIMIT, recLimitVal);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e2) {
            e2.printStackTrace();
        }
        super.okPressed();
    }
}

