/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.prefs;

import java.util.Objects;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PreferenceStoreUtils {
    static IPreferenceStore getPreferenceStoreOrNull(AbstractUIPlugin plugin) {
        if (plugin != null) {
            return plugin.getPreferenceStore();
        }
        return null;
    }

    private static <T> T getPreferenceValueOrDefault(AbstractUIPlugin plugin, String preferenceId, IPreferenceGetter<T> getter, T defaultValue) {
        Objects.requireNonNull(preferenceId, "Must provide a non-null preference id.");
        Objects.requireNonNull(getter, "Must provide a non-null preference getter.");
        Objects.requireNonNull(defaultValue, "Must provide a non-null preference defaultValue.");
        IPreferenceStore prefs = PreferenceStoreUtils.getPreferenceStoreOrNull(plugin);
        if (prefs != null && prefs.contains(preferenceId)) {
            return getter.getPreference(prefs, preferenceId);
        }
        return defaultValue;
    }

    static boolean getPreferenceValueOrDefault(AbstractUIPlugin plugin, String preferenceID, boolean defaultValue) {
        return PreferenceStoreUtils.getPreferenceValueOrDefault(plugin, preferenceID, new IPreferenceGetter<Boolean>(){

            @Override
            public Boolean getPreference(IPreferenceStore prefs, String id) {
                return prefs.getBoolean(id);
            }
        }, Boolean.valueOf(defaultValue));
    }

    static int getPreferenceValueOrDefault(AbstractUIPlugin plugin, String preferenceID, final int defaultValue, final boolean returnDefaultOnZero) {
        return PreferenceStoreUtils.getPreferenceValueOrDefault(plugin, preferenceID, new IPreferenceGetter<Integer>(){

            @Override
            public Integer getPreference(IPreferenceStore prefs, String id) {
                int value = prefs.getInt(id);
                if (value == 0 && returnDefaultOnZero) {
                    return defaultValue;
                }
                return value;
            }
        }, defaultValue);
    }

    public static BooleanFieldEditor createBooleanFieldEditorWithTooltip(String prefId, String label2, Composite parent, String tooltip) {
        BooleanFieldEditor editor2 = new BooleanFieldEditor(prefId, label2, parent);
        editor2.getDescriptionControl(parent).setToolTipText(tooltip);
        return editor2;
    }

    public static IntegerFieldEditor createIntegerFieldEditorWithTooltip(String prefId, String label2, Composite parent, String onErrorMessage, String tooltip) {
        IntegerFieldEditor editor2 = new IntegerFieldEditor(prefId, label2, parent);
        editor2.getTextControl(parent).setToolTipText(tooltip);
        editor2.getLabelControl(parent).setToolTipText(tooltip);
        editor2.setErrorMessage(onErrorMessage);
        return editor2;
    }

    private static interface IPreferenceGetter<T> {
        public T getPreference(IPreferenceStore var1, String var2);
    }
}

