/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.prefs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.prefs.PreferenceStoreUtils;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FormattedEditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PREF_FE_RECORD_CACHE_SIZE = "fmi.record.cacheSize";
    public static final int DEFAULT_FE_RECORD_CACHE_SIZE_VALUE = 100;
    public static final String PREF_FE_MAX_COLUMN_NO = "fmi.column.maxno";
    public static final int DEFAULT_FE_MAX_COLUMN_NO_VALUE = 50;
    public static final int DEFAULT_FE_MAX_COLUMN_NO_NONZERO_VALUE = 30000;
    public static final String PREF_FE_MAX_CHARACTER_NO = "fmi.character.maxno";
    public static final int DEFAULT_FE_MAX_CHARACTER_NO_NONZERO_VALUE = 1500;
    public static final String PREF_FE_TEXT_FOREGROUND_COLOR = "fe.text.foreground.color";
    public static final int DEFAULT_FE_TEXT_FOREGROUND_COLOR = 2;
    public static final String PREF_FE_HEX_FOREGROUND_COLOR = "fe.hex.foreground.color";
    public static final int DEFAULT_FE_HEX_FOREGROUND_COLOR = 9;
    public static final String PREF_FE_BACKGROUND_COLOR = "fe.background.color";
    public static final int DEFAULT_PREF_FE_BACKGROUND_COLOR = 1;
    public static final String PREF_FE_LEN_ERROR_TEXT_FOREGROUND_COLOR = "fe.lenErr.text.foreground.color";
    public static final int DEFAULT_FE_LEN_ERROR_TEXT_FOREGROUND_COLOR = 3;
    public static final String PREF_FE_LEN_ERROR_TEXT_BACKGROUND_COLOR = "fe.lenErr.text.background.color";
    public static final int DEFAULT_FE_LEN_ERROR_TEXT_BACKGROUND_COLOR = 19;
    public static final String PREF_FE_SEARCH_MATCH_FIELD_BACKGROUN_COLOR = "fe.search.found.background.color";
    public static final int DEFAULT_FE_SEARCH_MATCH_FIELD_BACKGROUN_COLOR = 5;
    public static final String FONT_STYLE = "fe.font";
    public static final String DEFAULT_FONT_NAME = "";
    public static final String PREF_FE_KEY_COLOR = "fmi.key.color";
    public static final int DEFAULT_FE_KEY_COLOR_VALUE = 6;
    public static final String PREF_FE_KEY_COLOR_BACKGROUND = "fmi.key.back.color";
    public static final int DEFAULT_FE_KEY_COLOR_VALUE_BACKGROUND = 1;
    public static final boolean DEFAULT_FE_HEX_MODE_VALUE = false;
    public static final boolean DEFAULT_SHOW_NOT_SELECTED_RECORDS = false;
    public static final boolean DEFAULT_SHOW_SUPPRESSED_RECORDS = false;
    public static final boolean DEFAULT_SHOW_LENGTH_ERROR_RECORDS = true;
    public static final String PREF_SHOW_NOT_SELECTED_RECORDS = "showNotSelectedRecords";
    public static final String PREF_SHOW_SUPPRESSED_RECORDS = "showSuppressedRecords";
    public static final String PREF_SHOW_LENGTH_ERROR_RECORDS = "showLengthErrorRecords";
    public static final boolean DEFAULT_DISPLAY_SHADOW_LINES_FOR_EX = true;
    public static final boolean DEFAULT_DISPLAY_SHADOW_LINES_FOR_NOT = true;
    public static final boolean DEFAULT_DISPLAY_SHADOW_LINES_FOR_SUP = true;
    public static final String PREF_DISPLAY_SHADOW_LINES_FOR_EX = "shadowDisplayEx";
    public static final String PREF_DISPLAY_SHADOW_LINES_FOR_NOT = "shadowDisplayNo";
    public static final String PREF_DISPLAY_SHADOW_LINES_FOR_SUP = "shadowDisplaySup";
    public static final String PREF_FE_PACK = "fmi.fe.PACK";
    public static final boolean DEFAULT_PACK_VALUE = true;
    public static final String PREF_FE_RDF = "fmi.fe.RDF";
    public static final boolean DEFAULT_RDF_VALUE = false;
    public static final String PREF_FE_TEXT_ONLY = "fmi.fe.textOnly";
    public static final boolean DEFAULT_TEXT_ONLY_VALUE = false;
    public static final String PREF_FE_SHOW_COLS = "fmi.fe.showCols";
    public static final boolean DEFAULT_SHOW_COLS = false;
    public static final String PREF_MQ_INFORMATIONAL = "editorMqInformational";
    public static final boolean DEFAULT_MQ_INFORMATIONAL_VALUE = false;
    public static final String INLINE_VALIDATION = "inlineValdation";
    public static final boolean DEFAULT_INLINE_VALIDATION = true;
    private ColorFieldEditor backgroundColor;
    private ColorFieldEditor textForegroundColor;
    private ColorFieldEditor hexForegroundColor;
    private ColorFieldEditor lenErrorForegroundColor;
    private ColorFieldEditor lenErrorBackgroundColor;
    private ColorFieldEditor searchMatchBackgroundColor;
    private ColorFieldEditor keyColor;
    private ColorFieldEditor keyColorBackground;
    private ColorFieldEditor editedRecordColor;
    private static Color cHighlight = null;
    private static Color cHighlightBackground = null;
    private static Color cEditedRecord = null;
    private static Color cTextBackground = null;
    private static Color cTextForeground = null;
    private static Color cHexForeground = null;
    private static Color cSearchMatch = null;
    private static Color cLenErrForeground = null;
    private static Color cLenErrBackground = null;
    private Button fontClear;
    private FontDialog fontDialog;
    private boolean fontClearflag = false;

    protected IPreferenceStore doGetPreferenceStore() {
        return PreferenceStoreUtils.getPreferenceStoreOrNull(FMUIPlugin.getDefault());
    }

    private static int getPreferenceValueOrDefault(String id, int defaultValue, boolean defaultOnZero) {
        return PreferenceStoreUtils.getPreferenceValueOrDefault((AbstractUIPlugin)FMUIPlugin.getDefault(), id, defaultValue, defaultOnZero);
    }

    private static boolean getPreferenceValueOrDefault(String id, boolean defaultValue) {
        return PreferenceStoreUtils.getPreferenceValueOrDefault(FMUIPlugin.getDefault(), id, defaultValue);
    }

    public static int getRecordCacheSize() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_FE_RECORD_CACHE_SIZE, 100, true);
    }

    public static int getMaxColumnNo() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_FE_MAX_COLUMN_NO, 30000, true);
    }

    public static int getMaxCharacterNo() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_FE_MAX_CHARACTER_NO, 1500, true);
    }

    public static boolean useHexMode() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(Integer.toString(2049), false);
    }

    public static boolean showNotSelectedRecords() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_SHOW_NOT_SELECTED_RECORDS, false);
    }

    public static boolean showSuppressedRecords() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_SHOW_SUPPRESSED_RECORDS, false);
    }

    public static boolean showLengthErrorRecords() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_SHOW_LENGTH_ERROR_RECORDS, true);
    }

    public static boolean inlineValidation() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(INLINE_VALIDATION, true);
    }

    public static boolean displayShadowLinesForEx() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_DISPLAY_SHADOW_LINES_FOR_EX, true);
    }

    public static boolean displayShadowLinesForNot() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_DISPLAY_SHADOW_LINES_FOR_NOT, true);
    }

    public static boolean displayShadowLinesForSup() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_DISPLAY_SHADOW_LINES_FOR_SUP, true);
    }

    private static boolean usePack() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_FE_PACK, true);
    }

    private static boolean useRDF() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_FE_RDF, false);
    }

    public static boolean assumeTextOnlyForChar() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_FE_TEXT_ONLY, false);
    }

    public static boolean showRulerGridForCols() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_FE_SHOW_COLS, false);
    }

    public static boolean hideMqInformational() {
        return FormattedEditorPreferencePage.getPreferenceValueOrDefault(PREF_MQ_INFORMATIONAL, false);
    }

    public static String getEditorInitSettings() {
        if (!FormattedEditorPreferencePage.usePack() || FormattedEditorPreferencePage.useRDF() || !FormattedEditorPreferencePage.showLengthErrorRecords()) {
            Object command = "SETE ";
            command = (String)command + "," + (FormattedEditorPreferencePage.usePack() ? "PACK=YES" : "PACK=NO");
            command = (String)command + "," + (FormattedEditorPreferencePage.useRDF() ? "RDF=YES" : "RDF=NO");
            command = (String)command + "," + (FormattedEditorPreferencePage.showLengthErrorRecords() ? "SHOWLEN=Y" : "SHOWLEN=N");
            return command;
        }
        return null;
    }

    public static String getEditorInitSettingsForExport(boolean includeRDF) {
        Object command = FormattedEditorPreferencePage.getEditorInitSettings();
        command = command == null ? "SETE SHOWLEN=Y" : (String)command + ",SHOWLEN=Y";
        command = (String)command + "," + (includeRDF ? "RDF=YES" : "RDF=NO");
        return command;
    }

    public FormattedEditorPreferencePage() {
        super(Messages.FMIFormattedEditorPreferencePage_COMPONENT_NAME, 1);
        this.setPreferenceStore(FMUIPlugin.getDefault().getPreferenceStore());
    }

    public static Color getHighlightColor() {
        if (cHighlight == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)PREF_FE_KEY_COLOR);
            cHighlight = new Color((Device)Display.getDefault(), rgb);
        }
        return cHighlight;
    }

    public static Font getFontStyle() {
        FontData[] fontDataArray = PreferenceConverter.getFontDataArray((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)FONT_STYLE);
        FontData fontData = fontDataArray[0];
        if (fontData.getName().equals(DEFAULT_FONT_NAME)) {
            return JFaceResources.getTextFont();
        }
        JFaceResources.getFontRegistry().put(FONT_STYLE, fontDataArray);
        return JFaceResources.getFont((String)FONT_STYLE);
    }

    public static Color getHighlightColorBackground() {
        if (cHighlightBackground == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)PREF_FE_KEY_COLOR_BACKGROUND);
            cHighlightBackground = new Color((Device)Display.getDefault(), rgb);
        }
        return cHighlightBackground;
    }

    public static Color getTextBackgroundColor() {
        if (cTextBackground == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)PREF_FE_BACKGROUND_COLOR);
            cTextBackground = new Color((Device)Display.getDefault(), rgb);
        }
        return cTextBackground;
    }

    public static Color getTextForegroundColor() {
        if (cTextForeground == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)PREF_FE_TEXT_FOREGROUND_COLOR);
            cTextForeground = new Color((Device)Display.getDefault(), rgb);
        }
        return cTextForeground;
    }

    public static Color getHexForegroundColor() {
        if (cHexForeground == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)PREF_FE_HEX_FOREGROUND_COLOR);
            cHexForeground = new Color((Device)Display.getDefault(), rgb);
        }
        return cHexForeground;
    }

    public static Color getSearchMatchBackgroundColor() {
        if (cSearchMatch == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)PREF_FE_SEARCH_MATCH_FIELD_BACKGROUN_COLOR);
            cSearchMatch = new Color((Device)Display.getDefault(), rgb);
        }
        return cSearchMatch;
    }

    public static Color getLenErrTextForegroundColor() {
        if (cLenErrForeground == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)PREF_FE_LEN_ERROR_TEXT_FOREGROUND_COLOR);
            cLenErrForeground = new Color((Device)Display.getDefault(), rgb);
        }
        return cLenErrForeground;
    }

    public static Color getLenErrTextBackgroundColor() {
        if (cLenErrBackground == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)PREF_FE_LEN_ERROR_TEXT_BACKGROUND_COLOR);
            cLenErrBackground = new Color((Device)Display.getDefault(), rgb);
        }
        return cLenErrBackground;
    }

    protected void createFieldEditors() {
        Composite composite = GUI.composite((Composite)this.getFieldEditorParent(), (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Composite twoComp = GUI.composite((Composite)composite, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createShowAndShadowSetting(twoComp);
        this.createColorSettingsGroup(twoComp);
        this.createAdditionalSettingsGroup(composite);
    }

    private void createColorSettingsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.FormattedEditorPreferencePage_COLOR_GROUP);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        group.setLayoutData((Object)gd);
        this.backgroundColor = new ColorFieldEditor(PREF_FE_BACKGROUND_COLOR, Messages.FMIPreferencePage_FE_BACKGROUND, (Composite)group);
        this.addField((FieldEditor)this.backgroundColor);
        this.backgroundColor.getColorSelector().setColorValue(FormattedEditorPreferencePage.getTextForegroundColor().getRGB());
        this.textForegroundColor = new ColorFieldEditor(PREF_FE_TEXT_FOREGROUND_COLOR, Messages.FMIPreferencePage_FE_TEXT_FOREGROUND, (Composite)group);
        this.addField((FieldEditor)this.textForegroundColor);
        this.textForegroundColor.getColorSelector().setColorValue(FormattedEditorPreferencePage.getTextForegroundColor().getRGB());
        this.hexForegroundColor = new ColorFieldEditor(PREF_FE_HEX_FOREGROUND_COLOR, Messages.FMIPreferencePage_FE_HEX_FOREGROUND, (Composite)group);
        this.addField((FieldEditor)this.hexForegroundColor);
        this.hexForegroundColor.getColorSelector().setColorValue(FormattedEditorPreferencePage.getHexForegroundColor().getRGB());
        this.lenErrorForegroundColor = new ColorFieldEditor(PREF_FE_LEN_ERROR_TEXT_FOREGROUND_COLOR, Messages.FMIPreferencePage_FE_LEN_ERR_FOREGROUND, (Composite)group);
        this.addField((FieldEditor)this.lenErrorForegroundColor);
        this.lenErrorForegroundColor.getColorSelector().setColorValue(FormattedEditorPreferencePage.getLenErrTextForegroundColor().getRGB());
        this.lenErrorBackgroundColor = new ColorFieldEditor(PREF_FE_LEN_ERROR_TEXT_BACKGROUND_COLOR, Messages.FMIPreferencePage_FE_LEN_ERR_BACKGROUND, (Composite)group);
        this.addField((FieldEditor)this.lenErrorBackgroundColor);
        this.lenErrorBackgroundColor.getColorSelector().setColorValue(FormattedEditorPreferencePage.getLenErrTextBackgroundColor().getRGB());
        this.searchMatchBackgroundColor = new ColorFieldEditor(PREF_FE_SEARCH_MATCH_FIELD_BACKGROUN_COLOR, Messages.FMIPreferencePage_FE_SEARCH_FOUND_BACKGROUP, (Composite)group);
        this.addField((FieldEditor)this.searchMatchBackgroundColor);
        this.searchMatchBackgroundColor.getColorSelector().setColorValue(FormattedEditorPreferencePage.getSearchMatchBackgroundColor().getRGB());
        this.keyColor = new ColorFieldEditor(PREF_FE_KEY_COLOR, Messages.FMIPreferencePage_KEY_COLOR_PROMPT, (Composite)group);
        this.addField((FieldEditor)this.keyColor);
        this.keyColor.getColorSelector().setColorValue(FormattedEditorPreferencePage.getHighlightColor().getRGB());
        this.keyColorBackground = new ColorFieldEditor(PREF_FE_KEY_COLOR_BACKGROUND, Messages.FMIPreferencePage_KEY_COLOR_PROMPT_BACKGROUND, (Composite)group);
        this.addField((FieldEditor)this.keyColorBackground);
        this.keyColorBackground.getColorSelector().setColorValue(FormattedEditorPreferencePage.getHighlightColorBackground().getRGB());
    }

    private void createShowAndShadowSetting(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.vert((int)128, (boolean)false, (int)1));
        Group showGroup = GUI.group((Composite)composite, (String)Messages.FormattedEditorPreferencePage_SHOW_GROUP, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.addField((FieldEditor)PreferenceStoreUtils.createBooleanFieldEditorWithTooltip(PREF_SHOW_NOT_SELECTED_RECORDS, Messages.FormattedEditorPreferencePage_ShowNotSelectedRecords, (Composite)showGroup, Messages.FormattedEditorPreferencePage_ShowNotTooltip));
        this.addField((FieldEditor)PreferenceStoreUtils.createBooleanFieldEditorWithTooltip(PREF_SHOW_SUPPRESSED_RECORDS, Messages.FormattedEditorPreferencePage_ShowSuppressedRecords, (Composite)showGroup, Messages.FormattedEditorPreferencePage_ShowSupTooltip));
        this.addField((FieldEditor)PreferenceStoreUtils.createBooleanFieldEditorWithTooltip(PREF_SHOW_LENGTH_ERROR_RECORDS, Messages.FormattedEditorPreferencePage_ShowLengthError, (Composite)showGroup, Messages.FormattedEditorPreferencePage_ShowLengthErrorTooltip));
        GridLayout showGroupLayout = (GridLayout)showGroup.getLayout();
        showGroupLayout.marginHeight = 6;
        showGroupLayout.marginWidth = 10;
        Group shadowGroup = GUI.group((Composite)composite, (String)Messages.FormattedEditorPreferencePage_SHADOW_GROUP, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.addField((FieldEditor)PreferenceStoreUtils.createBooleanFieldEditorWithTooltip(PREF_DISPLAY_SHADOW_LINES_FOR_EX, Messages.FormattedEditorPreferencePage_EX, (Composite)shadowGroup, Messages.FormattedEditorPreferencePage_ShowShadowExcludedTooltip));
        this.addField((FieldEditor)PreferenceStoreUtils.createBooleanFieldEditorWithTooltip(PREF_DISPLAY_SHADOW_LINES_FOR_NOT, Messages.FormattedEditorPreferencePage_NOT, (Composite)shadowGroup, Messages.FormattedEditorPreferencePage_ShowShadowNotTooltip));
        this.addField((FieldEditor)PreferenceStoreUtils.createBooleanFieldEditorWithTooltip(PREF_DISPLAY_SHADOW_LINES_FOR_SUP, Messages.FormattedEditorPreferencePage_SUP, (Composite)shadowGroup, Messages.FormattedEditorPreferencePage_ShowShadowSupTooltip));
        Group fontGroup = GUI.group((Composite)composite, (String)Messages.FormattedEditorPreferencePage_FONT_GROUP, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)2));
        Button fontSetting = new Button((Composite)fontGroup, 0x1000008);
        fontSetting.setText("Font");
        this.setButtonLayoutData(fontSetting);
        this.fontClear = new Button((Composite)fontGroup, 0x1000008);
        this.setButtonLayoutData(this.fontClear);
        this.fontClear.setEnabled(false);
        fontSetting.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                FormattedEditorPreferencePage.this.fontDialog = new FontDialog(FormattedEditorPreferencePage.this.getShell(), 0);
                FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)FormattedEditorPreferencePage.FONT_STYLE);
                FormattedEditorPreferencePage.this.fontDialog.setFontList(new FontData[]{fontData});
                FormattedEditorPreferencePage.this.fontDialog.setText(FormattedEditorPreferencePage.this.fontDialog.getFontList()[0].getName());
                FormattedEditorPreferencePage.this.fontDialog.open();
                if (!FormattedEditorPreferencePage.this.fontDialog.getFontList()[0].getName().equals(FormattedEditorPreferencePage.DEFAULT_FONT_NAME)) {
                    FormattedEditorPreferencePage.this.enableFontClearButton(true);
                    FormattedEditorPreferencePage.this.fontClearflag = false;
                }
            }
        });
        this.fontClear.setText("Clear Font");
        if (!PreferenceConverter.getFontData((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)FONT_STYLE).getName().equals(DEFAULT_FONT_NAME)) {
            this.enableFontClearButton(true);
            this.fontClearflag = false;
        }
        this.fontClear.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                FormattedEditorPreferencePage.this.fontDialog = new FontDialog(FormattedEditorPreferencePage.this.getShell(), 0);
                FormattedEditorPreferencePage.this.fontDialog.setFontList(new FontData[]{new FontData()});
                FormattedEditorPreferencePage.this.enableFontClearButton(false);
            }
        });
        GridLayout shadowGroupLayout = (GridLayout)shadowGroup.getLayout();
        shadowGroupLayout.marginHeight = 6;
        shadowGroupLayout.marginWidth = 10;
    }

    private void enableFontClearButton(boolean b) {
        this.fontClear.setEnabled(b);
    }

    private void createAdditionalSettingsGroup(Composite parent) {
        Group group = GUI.group((Composite)parent, (String)Messages.FormattedEditorPreferencePage_OTHER_GROUP, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Composite cacheComposite = GUI.composite((Composite)group, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        IntegerFieldEditor recordCacheSize = PreferenceStoreUtils.createIntegerFieldEditorWithTooltip(PREF_FE_RECORD_CACHE_SIZE, Messages.FormattedEditorPreferencePage_1, cacheComposite, Messages.FMIPreferencePage_CACHE_SIZE_ERROR, Messages.FormattedEditorPreferencePage_NumRecordsInCacheWindowTooltip);
        recordCacheSize.setValidRange(1, 5000);
        recordCacheSize.setTextLimit(5);
        this.addField((FieldEditor)recordCacheSize);
        FormattedEditorPreferencePage.addTextModifyValidator(recordCacheSize.getTextControl(cacheComposite), new FMConsumer<String>(){

            @Override
            public void accept(String text2) {
                if (text2 != null && !text2.isEmpty() && text2.matches("\\d+")) {
                    if (500 < Integer.valueOf(text2)) {
                        FormattedEditorPreferencePage.this.setMessage(Messages.FormattedEditorPreferencePage_4, 2);
                    } else {
                        FormattedEditorPreferencePage.this.setMessage(null);
                    }
                }
            }
        });
        this.addField((FieldEditor)PreferenceStoreUtils.createIntegerFieldEditorWithTooltip(PREF_FE_MAX_COLUMN_NO, Messages.FMIPreferencePage_MAX_COLUMN_NO, cacheComposite, Messages.FMIPreferencePage_MAX_COLUMN_NO_ERROR, Messages.FormattedEditorPreferencePage_MaxColNumTooltip));
        this.addField((FieldEditor)PreferenceStoreUtils.createBooleanFieldEditorWithTooltip(Integer.toString(2049), Messages.FMIPreferencePage_HEX_MODE_PROMPT, (Composite)group, Messages.FormattedEditorPreferencePage_HexModeTooltip));
        this.addField((FieldEditor)PreferenceStoreUtils.createBooleanFieldEditorWithTooltip(PREF_FE_PACK, Messages.EditorOptions_PACK, (Composite)group, Messages.FormattedEditorPreferencePage_ispfPackTooltip));
        this.addField((FieldEditor)PreferenceStoreUtils.createBooleanFieldEditorWithTooltip(PREF_FE_RDF, Messages.EditorOptions_RDF, (Composite)group, Messages.FormattedEditorPreferencePage_redefinedFieldsTooltip));
        this.addField((FieldEditor)PreferenceStoreUtils.createBooleanFieldEditorWithTooltip(PREF_FE_TEXT_ONLY, Messages.FormattedEditorPreferencePage_0, (Composite)group, Messages.FormattedEditorPreferencePage_charModeNoTemplateTextOnlyTooltip));
        this.addField((FieldEditor)PreferenceStoreUtils.createBooleanFieldEditorWithTooltip(PREF_FE_SHOW_COLS, Messages.FormattedEditorPreferencePage_ShowCols, (Composite)group, Messages.FormattedEditorPreferencePage_ShowCols));
        this.addField((FieldEditor)PreferenceStoreUtils.createBooleanFieldEditorWithTooltip(INLINE_VALIDATION, Messages.FMIPreferencePage_INLINE_VALIDATION, (Composite)group, Messages.FMIPreferencePage_INLINE_VALIDATION_TOOLTIP));
        Composite maxCharsComposite = GUI.composite((Composite)group, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        IntegerFieldEditor maxCharactersInCharMode = PreferenceStoreUtils.createIntegerFieldEditorWithTooltip(PREF_FE_MAX_CHARACTER_NO, Messages.FMIPreferencePage_MAX_CHARACTER_NO, maxCharsComposite, Messages.FMIPreferencePage_MAX_CHARACTER_NO_ERROR, Messages.FormattedEditorPreferencePage_MaxCharactersToDisplayWidthTooltip);
        this.addField((FieldEditor)maxCharactersInCharMode);
        FormattedEditorPreferencePage.addTextModifyValidator(maxCharactersInCharMode.getTextControl(maxCharsComposite), new FMConsumer<String>(){

            @Override
            public void accept(String text2) {
                if (text2 != null && !text2.isEmpty() && text2.matches("\\d+")) {
                    if (2000 < Integer.valueOf(text2)) {
                        FormattedEditorPreferencePage.this.setMessage(Messages.FormattedEditorPreferencePage_WarningForLargeCharacterWidth, 2);
                    } else {
                        FormattedEditorPreferencePage.this.setMessage(null);
                    }
                }
            }
        });
    }

    private static <T> void addTextModifyValidator(Text text2, final FMConsumer<String> validator) {
        text2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                validator.accept(((Text)e.widget).getText().trim());
            }
        });
    }

    public void init(IWorkbench arg0) {
    }

    public boolean performOk() {
        cHighlight = null;
        cEditedRecord = null;
        cTextForeground = null;
        cHexForeground = null;
        cSearchMatch = null;
        cLenErrForeground = null;
        cLenErrBackground = null;
        cTextBackground = null;
        cHighlightBackground = null;
        this.refreshFontSettings();
        return super.performOk();
    }

    private void refreshFontSettings() {
        if (this.fontClearflag) {
            PreferenceConverter.setValue((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)FONT_STYLE, (FontData)new FontData());
            FormattedEditorPreferencePage.refreshPageContent();
        }
        if (this.fontDialog != null) {
            PreferenceConverter.setValue((IPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore(), (String)FONT_STYLE, (FontData[])this.fontDialog.getFontList());
            FormattedEditorPreferencePage.refreshPageContent();
        }
    }

    private static void refreshPageContent() {
        IEditorPart editorPart;
        IWorkbenchPage page;
        IWorkbenchWindow activeWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWindow = workbench.getActiveWorkbenchWindow()) != null && (page = activeWindow.getActivePage()) != null && (editorPart = page.getActiveEditor()) instanceof FormattedEditor) {
            FormattedEditor editor2 = (FormattedEditor)editorPart;
            editor2.refreshContent();
        }
    }

    protected void performDefaults() {
        this.fontDialog = new FontDialog(this.getShell(), 0);
        this.fontDialog.setFontList(new FontData[]{new FontData()});
        this.enableFontClearButton(false);
        this.fontClearflag = true;
        super.performDefaults();
    }

    private static interface FMConsumer<T> {
        public void accept(T var1);
    }
}

