/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.prefs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.models.compiler.CompilerFactory;
import com.ibm.etools.fm.models.compiler.Plitype;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class CompilerOptionsPliCompilerOptions
extends Composite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final boolean GRAPHIC_DEFAULT_VALUE = false;
    public static final boolean UNALIGH_DEFAULT_VALUE = false;
    public static final boolean BIT_BINARY_63_DEFAULT_VALUE = false;
    public static final boolean DIGIT_DECIMA_31_DEFAULT_VALUE = false;
    public static final String MAX_RC_DEFAULT_VALUE = "4";
    public static final String ADDITIONAL_COMPILER_OPTIONS_DEFAULT_VALUE = "";
    private Button graphicButton = null;
    private Button unalighButton = null;
    private Button bitBinary63Button = null;
    private Button digitDecimal31Button = null;
    private Text maxReturnText = null;
    private Text additionalOptsText = null;
    private TabItem tabItem = null;

    public CompilerOptionsPliCompilerOptions(Composite parent, TabItem tabItem) {
        super(parent, 0);
        this.tabItem = tabItem;
        this.setLayout((Layout)GUI.grid.l.margins((int)1, (boolean)false));
        this.setLayoutData(GUI.grid.d.fillH((int)1));
        Group group = GUI.group((Composite)this, (String)Messages.CompilerOptionsPliCompilerOptions_NAME, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.graphicButton = new Button((Composite)group, 32);
        this.graphicButton.setText(Messages.CompilerOptionsPliCompilerOptions_GRAPHIC);
        this.unalighButton = new Button((Composite)group, 32);
        this.unalighButton.setText(Messages.CompilerOptionsPliCompilerOptions_UNALIGN);
        this.bitBinary63Button = new Button((Composite)group, 32);
        this.bitBinary63Button.setText(Messages.CompilerOptionsPliCompilerOptions_63BIT);
        this.digitDecimal31Button = new Button((Composite)group, 32);
        this.digitDecimal31Button.setText(Messages.CompilerOptionsPliCompilerOptions_31DIGIT);
        GUI.label.left((Composite)group, (String)Messages.CompilerOptionsPliCompilerOptions_MAX_RC, (Object)GUI.grid.d.left1());
        this.maxReturnText = GUI.text.field((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer nfMRT = NumberForcer.addTo(this.maxReturnText);
        nfMRT.setUpperBound(99, true);
        this.maxReturnText.setText(MAX_RC_DEFAULT_VALUE);
        GUI.label.left((Composite)group, (String)Messages.CompilerOptionsCobolCompilerOptionsComposite_0, (Object)GUI.grid.d.left1());
        this.additionalOptsText = GUI.text.field((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        this.additionalOptsText.setToolTipText(Messages.CompilerOptionsCobolCompilerOptionsComposite_1);
    }

    public void enableControls(boolean enable) {
        this.graphicButton.setEnabled(enable);
        this.unalighButton.setEnabled(enable);
        this.bitBinary63Button.setEnabled(enable);
        this.digitDecimal31Button.setEnabled(enable);
        this.maxReturnText.setEnabled(enable);
        this.additionalOptsText.setEnabled(enable);
    }

    public void setOptionValues(Plitype pliOpts) {
        if (pliOpts == null) {
            this.graphicButton.setSelection(false);
            this.unalighButton.setSelection(false);
            this.bitBinary63Button.setSelection(false);
            this.digitDecimal31Button.setSelection(false);
            this.maxReturnText.setText(MAX_RC_DEFAULT_VALUE);
            this.additionalOptsText.setText(ADDITIONAL_COMPILER_OPTIONS_DEFAULT_VALUE);
        } else {
            this.graphicButton.setSelection(pliOpts.isGraph());
            this.unalighButton.setSelection(pliOpts.isUnalign());
            this.bitBinary63Button.setSelection(pliOpts.isBin63());
            this.digitDecimal31Button.setSelection(pliOpts.isFixdec());
            this.maxReturnText.setText(ADDITIONAL_COMPILER_OPTIONS_DEFAULT_VALUE + pliOpts.getMaxrc());
            this.additionalOptsText.setText(pliOpts.getPliaddop() == null ? ADDITIONAL_COMPILER_OPTIONS_DEFAULT_VALUE : pliOpts.getPliaddop());
        }
    }

    public String verifyEntries() {
        if (this.maxReturnText.getText().trim().isEmpty()) {
            this.tabItem.getParent().setSelection(this.tabItem);
            this.maxReturnText.setFocus();
            return Messages.CompilerOptionsPliCompilerOptions_NO_MAX_RC;
        }
        return null;
    }

    public Plitype getValues() {
        Plitype pliType = CompilerFactory.eINSTANCE.createPlitype();
        pliType.setGraph(this.graphicButton.getSelection());
        pliType.setUnalign(this.unalighButton.getSelection());
        pliType.setBin63(this.bitBinary63Button.getSelection());
        pliType.setFixdec(this.digitDecimal31Button.getSelection());
        pliType.setMaxrc(Integer.parseInt(this.maxReturnText.getText()));
        pliType.setPliaddop(this.additionalOptsText.getText().trim());
        return pliType;
    }
}

