/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.prefs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.models.compiler.Asmtype;
import com.ibm.etools.fm.models.compiler.CompilerFactory;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class CompilerOptionsHLASMCompilerOptions
extends Composite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final boolean DBCS_DEFAULT_VALUE = false;
    public static final boolean NOALIGN_DEFAULT_VALUE = false;
    public static final String MAX_RC_DEFAULT_VALUE = "4";
    public static final String ADDITIONAL_COMPILER_OPTIONS_DEFAULT_VALUE = "";
    private Button dbcsButton = null;
    private Button noalighButton = null;
    private Text maxReturnText = null;
    private Text additionalOptsText = null;
    private TabItem tabItem = null;

    public CompilerOptionsHLASMCompilerOptions(Composite parent, TabItem tabItem) {
        super(parent, 0);
        this.tabItem = tabItem;
        this.setLayout((Layout)GUI.grid.l.margins((int)1, (boolean)false));
        this.setLayoutData(GUI.grid.d.fillH((int)1));
        Group group = GUI.group((Composite)this, (String)Messages.CompilerOptionsHLASMCompilerOptions_NAME, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.dbcsButton = new Button((Composite)group, 32);
        this.dbcsButton.setText(Messages.CompilerOptionsHLASMCompilerOptions_DBCS);
        this.dbcsButton.setSelection(false);
        this.noalighButton = new Button((Composite)group, 32);
        this.noalighButton.setText(Messages.CompilerOptionsHLASMCompilerOptions_NOALIGN);
        this.noalighButton.setSelection(false);
        GUI.label.left((Composite)group, (String)Messages.CompilerOptionsHLASMCompilerOptions_MAX_RC, (Object)GUI.grid.d.left1());
        this.maxReturnText = GUI.text.field((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer nfMRT = NumberForcer.addTo(this.maxReturnText);
        nfMRT.setUpperBound(99, true);
        this.maxReturnText.setText(MAX_RC_DEFAULT_VALUE);
        GUI.label.left((Composite)group, (String)Messages.CompilerOptionsCobolCompilerOptionsComposite_0, (Object)GUI.grid.d.left1());
        this.additionalOptsText = GUI.text.field((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        this.additionalOptsText.setToolTipText(Messages.CompilerOptionsCobolCompilerOptionsComposite_1);
    }

    public void enableControls(boolean enable) {
        this.dbcsButton.setEnabled(enable);
        this.noalighButton.setEnabled(enable);
        this.maxReturnText.setEnabled(enable);
        this.additionalOptsText.setEnabled(enable);
    }

    public void setOptionValues(Asmtype options) {
        if (options == null) {
            this.dbcsButton.setSelection(false);
            this.noalighButton.setSelection(false);
            this.maxReturnText.setText(MAX_RC_DEFAULT_VALUE);
            this.additionalOptsText.setText(ADDITIONAL_COMPILER_OPTIONS_DEFAULT_VALUE);
        } else {
            this.dbcsButton.setSelection(options.isDbcs());
            this.noalighButton.setSelection(options.isNoalign());
            this.maxReturnText.setText(ADDITIONAL_COMPILER_OPTIONS_DEFAULT_VALUE + options.getMaxrc());
            this.additionalOptsText.setText(options.getAsmaddop() == null ? ADDITIONAL_COMPILER_OPTIONS_DEFAULT_VALUE : options.getAsmaddop());
        }
    }

    public String verifyEntries() {
        if (this.maxReturnText.getText().trim().isEmpty()) {
            this.tabItem.getParent().setSelection(this.tabItem);
            this.maxReturnText.setFocus();
            return Messages.CompilerOptionsHLASMCompilerOptions_NO_MAX_RC;
        }
        return null;
    }

    public Asmtype getValues() {
        Asmtype asmType = CompilerFactory.eINSTANCE.createAsmtype();
        asmType.setDbcs(this.dbcsButton.getSelection());
        asmType.setNoalign(this.noalighButton.getSelection());
        asmType.setMaxrc(Integer.parseInt(this.maxReturnText.getText().trim()));
        asmType.setAsmaddop(this.additionalOptsText.getText().trim());
        return asmType;
    }
}

