/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.prefs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.core.util.CompilerOptionsUtil;
import com.ibm.etools.fm.models.compiler.Asmtype;
import com.ibm.etools.fm.models.compiler.Coboltype;
import com.ibm.etools.fm.models.compiler.CompileType;
import com.ibm.etools.fm.models.compiler.CompilerFactory;
import com.ibm.etools.fm.models.compiler.LangType1;
import com.ibm.etools.fm.models.compiler.Plitype;
import com.ibm.etools.fm.models.compiler.ReplaceType;
import com.ibm.etools.fm.ui.prefs.CompilerOptionPreferenceUtils;
import com.ibm.etools.fm.ui.prefs.CompilerOptionsCobolCompilerOptionsComposite;
import com.ibm.etools.fm.ui.prefs.CompilerOptionsCobolReplaceComposite;
import com.ibm.etools.fm.ui.prefs.CompilerOptionsHLASMCompilerOptions;
import com.ibm.etools.fm.ui.prefs.CompilerOptionsPliCompilerOptions;
import com.ibm.etools.fm.ui.prefs.CompilerOptionsSyslibComposite;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public class CompilerOptionsDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final boolean DEFAULT_OVERRIDE_OPTION = false;
    private static final boolean DEFAULT_PRESERVE_OPTION = true;
    private static final boolean DEFAULT_COMMA_OPTION = false;
    private Combo defaultCompilerCombo;
    private Button overrideButton;
    private Button preserveButton;
    private Button commaSeperaterButton;
    private TabFolder optionsTab;
    private TabItem cobolOptionsTab;
    private CompilerOptionsSyslibComposite cobolSyslibComposite;
    private CompilerOptionsCobolReplaceComposite cobolReplaceComposite;
    private CompilerOptionsCobolCompilerOptionsComposite cobolOptionsComposite;
    private TabItem pliOptionsTab;
    private CompilerOptionsSyslibComposite pliSyslibComposite;
    private CompilerOptionsPliCompilerOptions pliOptionsComposite;
    private TabItem hlasmOptionsTab;
    private CompilerOptionsSyslibComposite hlasmSyslibComposite;
    private CompilerOptionsHLASMCompilerOptions hlasmOptionsComposite;
    private Button okButton;
    private Button cancelButton;
    private Button defaultButton;
    private IPDHost aHost;

    public CompilerOptionsDialog(IPDHost aHost) {
        this.aHost = aHost;
    }

    protected Composite createDialogContent(Composite parent) {
        this.setTitle(Messages.CompilerOptionsDialog_0);
        this.setMessage(Messages.CompilerOptionsDialog_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createDefaultCompilerComposite(composite);
        this.createCompilerOptionsTab(composite);
        this.enableSystemSpecificControls(this.aHost);
        return composite;
    }

    private void createDefaultCompilerComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.CompilerOptionsPreferencePage_DEFAULT_COMPILER, (Object)GUI.grid.d.left1());
        Object[] values = new String[LangType1.values().length];
        int i = 0;
        while (i < values.length) {
            values[i] = LangType1.values()[i].getLiteral();
            ++i;
        }
        this.defaultCompilerCombo = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])values);
        this.defaultCompilerCombo.setText(LangType1.AUTO.getLiteral());
        GUI.label.left((Composite)composite, (String)Messages.CompilerOptionsPreferencePage_OVERRIDE, (Object)GUI.grid.d.left1());
        this.overrideButton = new Button(composite, 32);
        this.overrideButton.setSelection(false);
        GUI.label.left((Composite)composite, (String)Messages.CompilerOptionsPreferencePage_PRESERVE, (Object)GUI.grid.d.left1());
        this.preserveButton = new Button(composite, 32);
        this.preserveButton.setSelection(true);
        GUI.label.left((Composite)composite, (String)Messages.CompilerOptionsPreferencePage_COMMA, (Object)GUI.grid.d.left1());
        this.commaSeperaterButton = new Button(composite, 32);
        this.commaSeperaterButton.setSelection(false);
        this.commaSeperaterButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean status;
                if (CompilerOptionsDialog.this.commaSeperaterButton.getSelection() && !(status = PDDialogs.openConfirm((String)Messages.ComilerOptionPreferencePage_HOST_VARSION_WARNING_TITLE, (String)Messages.ComilerOptionPreferencePage_HOST_VARSION_WARNING))) {
                    CompilerOptionsDialog.this.commaSeperaterButton.setSelection(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createCompilerOptionsTab(Composite parent) {
        this.optionsTab = new TabFolder(parent, 128);
        GridData data = GUI.grid.d.fillAll();
        this.optionsTab.setLayoutData((Object)data);
        this.cobolOptionsTab = new TabItem(this.optionsTab, 0);
        this.cobolOptionsTab.setText(Messages.CompilerOptionsPreferencePage_COBOL_TAB_NAME);
        this.cobolOptionsTab.setControl(this.getCobolTabContents(this.optionsTab));
        this.pliOptionsTab = new TabItem(this.optionsTab, 0);
        this.pliOptionsTab.setText(Messages.CompilerOptionsPreferencePage_PLI_TAB_NAME);
        this.pliOptionsTab.setControl(this.getPliTabContents(this.optionsTab));
        this.hlasmOptionsTab = new TabItem(this.optionsTab, 0);
        this.hlasmOptionsTab.setText(Messages.CompilerOptionsPreferencePage_HLASM_TAB_NAME);
        this.hlasmOptionsTab.setControl(this.getHlasmTabContents(this.optionsTab));
    }

    private Control getCobolTabContents(TabFolder tab) {
        Composite composite = GUI.composite((Composite)tab, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.cobolSyslibComposite = new CompilerOptionsSyslibComposite(composite, this.cobolOptionsTab);
        this.cobolReplaceComposite = new CompilerOptionsCobolReplaceComposite(composite, this.cobolOptionsTab);
        this.cobolOptionsComposite = new CompilerOptionsCobolCompilerOptionsComposite(composite, this.cobolOptionsTab);
        return composite;
    }

    private Control getPliTabContents(TabFolder tab) {
        Composite composite = GUI.composite((Composite)tab, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.pliSyslibComposite = new CompilerOptionsSyslibComposite(composite, this.pliOptionsTab);
        this.pliOptionsComposite = new CompilerOptionsPliCompilerOptions(composite, this.pliOptionsTab);
        return composite;
    }

    private Control getHlasmTabContents(TabFolder tab) {
        Composite composite = GUI.composite((Composite)tab, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.hlasmSyslibComposite = new CompilerOptionsSyslibComposite(composite, this.hlasmOptionsTab);
        this.hlasmOptionsComposite = new CompilerOptionsHLASMCompilerOptions(composite, this.hlasmOptionsTab);
        return composite;
    }

    private void enableSystemSpecificControls(IPDHost aHost) {
        this.defaultCompilerCombo.setEnabled(true);
        this.overrideButton.setEnabled(true);
        this.preserveButton.setEnabled(true);
        this.commaSeperaterButton.setEnabled(true);
        this.optionsTab.setEnabled(true);
        this.cobolSyslibComposite.enableControls(true);
        this.cobolReplaceComposite.enableControls(true);
        this.cobolOptionsComposite.enableControls(true);
        this.pliSyslibComposite.enableControls(true);
        this.pliOptionsComposite.enableControls(true);
        this.hlasmSyslibComposite.enableControls(true);
        this.hlasmOptionsComposite.enableControls(true);
        String xmlCompilerDoc = CompilerOptionPreferenceUtils.getCompilerOptions(aHost.getHostID());
        if (xmlCompilerDoc == null || xmlCompilerDoc.isEmpty()) {
            xmlCompilerDoc = CompilerOptionsDialog.getDefault();
        }
        CompileType aHostOptions = null;
        try {
            aHostOptions = CompilerOptionsUtil.load((String)xmlCompilerDoc, (String)aHost.getConnectionName());
        }
        catch (Exception e) {
            logger.error((Object)("Exception thrown while parsing XML output for FM compiler options: " + xmlCompilerDoc), (Throwable)e);
        }
        if (aHostOptions == null) {
            PDDialogs.openWarningThreadSafe((String)Messages.CompilerOptionsPreferencePage_OPTS_LOAD_ERR_TITLE, (String)Messages.CompilerOptionsPreferencePage_OPTS_LOAD_ERR_MSG);
            aHostOptions = CompilerFactory.eINSTANCE.createCompileType();
            aHostOptions.setLang(LangType1.AUTO);
            aHostOptions.setOverride(false);
            aHostOptions.setPreserve(true);
            aHostOptions.setComma(false);
        }
        this.setOptionValues(aHostOptions);
    }

    private void setOptionValues(final CompileType options) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                CompilerOptionsDialog.this.defaultCompilerCombo.select(options.getLang().getValue());
                CompilerOptionsDialog.this.overrideButton.setSelection(options.isSetOverride() ? options.isOverride() : false);
                CompilerOptionsDialog.this.preserveButton.setSelection(options.isSetPreserve() ? options.isPreserve() : true);
                CompilerOptionsDialog.this.commaSeperaterButton.setSelection(options.isComma() ? options.isComma() : false);
                Coboltype cobolOpts = options.getCobol();
                CompilerOptionsDialog.this.cobolSyslibComposite.setOptionValues((EList<String>)(cobolOpts == null ? null : cobolOpts.getCbllib()));
                CompilerOptionsDialog.this.cobolReplaceComposite.setOptionValues((EList<ReplaceType>)(cobolOpts == null ? null : cobolOpts.getReplace()));
                CompilerOptionsDialog.this.cobolOptionsComposite.setOptionValues(cobolOpts);
                Plitype pliOpts = options.getPli();
                CompilerOptionsDialog.this.pliSyslibComposite.setOptionValues((EList<String>)(pliOpts == null ? null : pliOpts.getPlilib()));
                CompilerOptionsDialog.this.pliOptionsComposite.setOptionValues(pliOpts);
                Asmtype asmOpts = options.getAsm();
                CompilerOptionsDialog.this.hlasmSyslibComposite.setOptionValues((EList<String>)(asmOpts == null ? null : asmOpts.getAsmlib()));
                CompilerOptionsDialog.this.hlasmOptionsComposite.setOptionValues(asmOpts);
            }
        });
    }

    protected void okPressed() {
        ConnPoolManagerFM connPoolManager;
        if (this.validateCurrentSystemOptions()) {
            CompileType opts = this.getOptionsForCurrentSystem();
            String xmlDoc = CompilerOptionsUtil.save((CompileType)opts);
            if (CompilerOptionsDialog.isDefaults(opts)) {
                FMHost.getSystem((IPDHost)this.aHost).setCompilerOptions("");
            } else {
                FMHost.getSystem((IPDHost)this.aHost).setCompilerOptions(xmlDoc);
            }
            connPoolManager = ConnPoolManagerFM.instance();
            if (connPoolManager.hasConnectionInUse(this.aHost) && !PDDialogs.openQuestion((String)Messages.CommHost_RISK_DATA_LOSS_TITLE, (String)Messages.CommHost_WARN_UNEXPECTED_BEHAVIOUR_TEXT)) {
                return;
            }
        } else {
            return;
        }
        connPoolManager.closeAllConnections(this.aHost);
        super.okPressed();
    }

    private static boolean isDefaults(CompileType newOpts) {
        if (LangType1.AUTO != newOpts.getLang()) {
            return false;
        }
        if (newOpts.isOverride()) {
            return false;
        }
        if (!newOpts.isPreserve()) {
            return false;
        }
        if (newOpts.isComma()) {
            return false;
        }
        Coboltype cobType = newOpts.getCobol();
        if (cobType.getCbllib().size() != 0) {
            return false;
        }
        if (cobType.getReplace().size() != 0) {
            return false;
        }
        if (cobType.isArith()) {
            return false;
        }
        if (cobType.isDpc()) {
            return false;
        }
        if (cobType.isDbcs()) {
            return false;
        }
        if (cobType.isMixedcase()) {
            return false;
        }
        if (cobType.getMaxrc() != 4) {
            return false;
        }
        if (!cobType.getCbladdop().isEmpty()) {
            return false;
        }
        Plitype pliType = newOpts.getPli();
        if (pliType.getPlilib().size() != 0) {
            return false;
        }
        if (pliType.isGraph()) {
            return false;
        }
        if (pliType.isUnalign()) {
            return false;
        }
        if (pliType.isBin63()) {
            return false;
        }
        if (pliType.isFixdec()) {
            return false;
        }
        if (pliType.getMaxrc() != 4) {
            return false;
        }
        if (!pliType.getPliaddop().isEmpty()) {
            return false;
        }
        Asmtype asmType = newOpts.getAsm();
        if (asmType.getAsmlib().size() != 0) {
            return false;
        }
        if (asmType.isDbcs()) {
            return false;
        }
        if (asmType.isNoalign()) {
            return false;
        }
        if (asmType.getMaxrc() != 4) {
            return false;
        }
        return asmType.getAsmaddop().isEmpty();
    }

    private static String getDefault() {
        CompileType newOpts = CompilerFactory.eINSTANCE.createCompileType();
        newOpts.setLang(LangType1.AUTO);
        newOpts.setOverride(false);
        newOpts.setPreserve(true);
        newOpts.setComma(false);
        String defaultOpts = CompilerOptionsUtil.save((CompileType)newOpts);
        return defaultOpts;
    }

    private boolean validateCurrentSystemOptions() {
        String errMsg = this.cobolSyslibComposite.verifyEntries(this.aHost);
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        errMsg = this.cobolReplaceComposite.verifyEntries();
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        errMsg = this.cobolOptionsComposite.verifyEntries();
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        errMsg = this.pliSyslibComposite.verifyEntries(this.aHost);
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        errMsg = this.pliOptionsComposite.verifyEntries();
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        errMsg = this.hlasmSyslibComposite.verifyEntries(this.aHost);
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        errMsg = this.hlasmOptionsComposite.verifyEntries();
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        this.setMessage(null);
        return true;
    }

    private CompileType getOptionsForCurrentSystem() {
        CompileType compileOpts = CompilerFactory.eINSTANCE.createCompileType();
        ArrayList<String> cobSyslib = this.cobolSyslibComposite.getValues();
        ArrayList<ReplaceType> cobReplaceList = this.cobolReplaceComposite.getValues();
        Coboltype cobOpts = this.cobolOptionsComposite.getValues();
        int i = 0;
        while (i < cobSyslib.size()) {
            cobOpts.getCbllib().add((Object)((String)cobSyslib.get(i)));
            ++i;
        }
        i = 0;
        while (i < cobReplaceList.size()) {
            cobOpts.getReplace().add((Object)((ReplaceType)cobReplaceList.get(i)));
            ++i;
        }
        ArrayList<String> pliSyslib = this.pliSyslibComposite.getValues();
        Plitype pliOpts = this.pliOptionsComposite.getValues();
        int i2 = 0;
        while (i2 < pliSyslib.size()) {
            pliOpts.getPlilib().add((Object)((String)pliSyslib.get(i2)));
            ++i2;
        }
        ArrayList<String> asmSyslib = this.hlasmSyslibComposite.getValues();
        Asmtype asmOpts = this.hlasmOptionsComposite.getValues();
        int i3 = 0;
        while (i3 < asmSyslib.size()) {
            asmOpts.getAsmlib().add((Object)((String)asmSyslib.get(i3)));
            ++i3;
        }
        compileOpts.setLang(LangType1.get((String)this.defaultCompilerCombo.getText()));
        compileOpts.setOverride(this.overrideButton.getSelection());
        compileOpts.setPreserve(this.preserveButton.getSelection());
        compileOpts.setComma(this.commaSeperaterButton.getSelection());
        compileOpts.setCobol(cobOpts);
        compileOpts.setPli(pliOpts);
        compileOpts.setAsm(asmOpts);
        return compileOpts;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData();
        data.widthHint = 100;
        this.okButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"ok"), (Object)data);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompilerOptionsDialog.this.okPressed();
            }
        });
        this.cancelButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"cancel"), (Object)data);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompilerOptionsDialog.this.cancelPressed();
            }
        });
        this.defaultButton = GUI.button.push((Composite)parent, (String)Messages.CompilerOptionsDialog_2, (Object)data);
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompilerOptionsDialog.this.retrieveOptionsFromHost();
            }
        });
        this.getShell().setDefaultButton(this.okButton);
    }

    private void retrieveOptionsFromHost() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(MessageFormat.format(Messages.CompilerOptionsPreferencePage_RETRIEVE_OPTS_OP_NAME, CompilerOptionsDialog.this.aHost.getConnectionName()), 2);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        Result result = ((FMHost)FMHost.getSystem((IPDHost)CompilerOptionsDialog.this.aHost)).executeOnHost(CompilerOptionsDialog.this.aHost, "GETCOPT", howIsGoing);
                        if (result.getRC() != 0 || result.hasError()) {
                            PDDialogs.openErrorThreadSafe((String)Messages.CompilerOptionsPreferencePage_RETRIEVE_ERR_MSG, (String)result.getMessagesCombined().toString());
                            return;
                        }
                        monitor.worked(1);
                        CompileType hostOptions = CompilerOptionsUtil.load((String)((StringBuffer)result.getOutput()).toString(), (String)CompilerOptionsDialog.this.aHost.getConnectionName());
                        if (hostOptions == null) {
                            PDDialogs.openWarningThreadSafe((String)Messages.Error, (String)Messages.CompilerOptionsPreferencePage_OPTS_LOAD_ERR_MSG);
                            hostOptions = CompilerFactory.eINSTANCE.createCompileType();
                            hostOptions.setLang(LangType1.AUTO);
                            hostOptions.setOverride(false);
                            hostOptions.setPreserve(true);
                            hostOptions.setComma(false);
                        }
                        CompilerOptionsDialog.this.setOptionValues(hostOptions);
                        monitor.done();
                    }
                    catch (Exception e) {
                        PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.CompilerOptionsPreferencePage_NO_CONN_ERR, CompilerOptionsDialog.this.aHost.getConnectionName()));
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.CompilerOptionsPreferencePage_LOAD_EX, e.getMessage()));
            return;
        }
    }
}

