/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.memento;

import com.ibm.etools.fm.core.model.UssFileQuery;
import com.ibm.etools.fm.core.model.UssFileType;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.memento.IMementoSaver;
import java.util.ArrayList;
import org.eclipse.ui.IMemento;

public class UssFileQuerySaver
implements IMementoSaver<UssFileQuery> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(UssFileQuerySaver.class);
    public static final String TYPE_QUERY = "ussFileQuery";
    private static final String KEY_QUERY = "query";
    public static final String TYPE_FILTER = "filterType";
    private static final String KEY_FILTER_TYPE_NAME = "name";
    private final IPDHost host;

    public UssFileQuerySaver(IPDHost host) {
        this.host = host;
    }

    public void saveTo(IMemento memento, UssFileQuery object) {
        memento.putString(KEY_QUERY, object.getQuery());
        for (UssFileType ufType : object.getTypesFiltered()) {
            IMemento mementoType = memento.createChild(TYPE_FILTER);
            mementoType.putString(KEY_FILTER_TYPE_NAME, ufType.toString());
        }
    }

    public UssFileQuery loadFrom(IMemento memento) {
        IMemento[] filterMementos;
        UssFileQuery query = null;
        String queryString = memento.getString(KEY_QUERY);
        if (!UssFileQuery.isValidQuery((IPDHost)this.host, (String)queryString)) {
            logger.debug((Object)("Not loading uss file query because query string is invalid: " + queryString));
            return null;
        }
        query = UssFileQuery.create((IPDHost)this.host, (String)queryString);
        ArrayList<UssFileType> typesFiltered = new ArrayList<UssFileType>();
        IMemento[] iMementoArray = filterMementos = memento.getChildren(TYPE_FILTER);
        int n = filterMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento filterMemento = iMementoArray[n2];
            String filteredType = filterMemento.getString(KEY_FILTER_TYPE_NAME);
            try {
                typesFiltered.add(UssFileType.valueOf((String)filteredType));
            }
            catch (Exception e) {
                logger.debug((Object)("Not loading uss file query; unable to parse uss file type of: " + filteredType), (Throwable)e);
                return null;
            }
            ++n2;
        }
        query.setTypesFiltered(typesFiltered);
        return query;
    }

    public String getTypeName() {
        return TYPE_QUERY;
    }
}

