/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.memento;

import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.MessageQueueQuery;
import com.ibm.etools.fm.ui.views.systems.model.MqTreeContent;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.PDTCCui;
import com.ibm.pdtools.common.component.ui.memento.IMementoSaver;
import com.ibm.pdtools.common.component.ui.memento.PDQuerySaver;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IMemento;

public class MessageQueueQuerySaver
extends PDQuerySaver
implements IMementoSaver<MessageQueueQuery> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(MessageQueueQuerySaver.class);
    public static final String TYPE_QUERY = "messageQueueQuery";
    private static final String KEY_MQM = "mqm";
    private static final String KEY_QUERY = "query";

    public MessageQueueQuerySaver(IPDHost host) {
        super(host);
    }

    public void saveTo(MqTreeContent mqContent) {
        IDialogSettings mqSection = this.getQuerySection();
        for (MessageQueueQuery mqQuery : mqContent.getQueriesForHost(this.host)) {
            this.addAQuerySection(mqSection, mqQuery);
        }
    }

    public void saveTo(MessageQueueQuery mqQuery) {
        IDialogSettings mqSection = this.getQuerySection();
        this.addAQuerySection(mqSection, mqQuery);
    }

    @Deprecated
    public void saveTo(IMemento memento, MessageQueueQuery object) {
        MessageQueueManager mqm = object.getMQManager();
        memento.putString(KEY_MQM, mqm.getName());
        memento.putString(KEY_QUERY, object.getQuery());
    }

    public void addAQuerySection(IDialogSettings mqSection, MessageQueueQuery mqq) {
        MessageQueueManager mqm = mqq.getMQManager();
        IDialogSettings mqmSection = PDTCCui.addSection((IDialogSettings)mqSection, (String)(mqm.getName() + mqq.getQuery()));
        mqmSection.put(KEY_MQM, mqm.getName());
        mqmSection.put(KEY_QUERY, mqq.getQuery());
    }

    public ArrayList<MessageQueueQuery> loadFrom() {
        IDialogSettings[] mqmSections;
        ArrayList<MessageQueueQuery> query = new ArrayList<MessageQueueQuery>();
        IDialogSettings mqSection = this.getExistingQuerySection();
        if (mqSection != null && (mqmSections = PDTCCui.getSections((IDialogSettings)mqSection)) != null) {
            IDialogSettings[] iDialogSettingsArray = mqmSections;
            int n = mqmSections.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogSettings aQuery = iDialogSettingsArray[n2];
                String mqmName = aQuery.get(KEY_MQM);
                if (mqmName != null) {
                    MessageQueueManager mqm = MessageQueueManager.create((IPDHost)this.host, (String)mqmName);
                    String queryString = aQuery.get(KEY_QUERY);
                    if (!MessageQueueQuery.isValidQuery((IPDHost)this.host, (String)queryString)) {
                        logger.debug((Object)("Not loading MQ query because query string is invalid: " + queryString));
                    } else {
                        query.add(MessageQueueQuery.create((MessageQueueManager)mqm, (String)queryString));
                    }
                }
                ++n2;
            }
        }
        return query;
    }

    @Deprecated
    public MessageQueueQuery loadFrom(IMemento memento) {
        String mqmName = memento.getString(KEY_MQM);
        MessageQueueManager mqm = MessageQueueManager.create((IPDHost)this.host, (String)mqmName);
        MessageQueueQuery query = null;
        String queryString = memento.getString(KEY_QUERY);
        if (!MessageQueueQuery.isValidQuery((IPDHost)this.host, (String)queryString)) {
            logger.debug((Object)("Not loading MQ query because query string is invalid: " + queryString));
            return null;
        }
        query = MessageQueueQuery.create((MessageQueueManager)mqm, (String)queryString);
        return query;
    }

    public String getTypeName() {
        return TYPE_QUERY;
    }
}

