/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.memento;

import com.ibm.etools.fm.core.model.ims.ImsDatabaseQuery;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.socket.func.I1SLParser;
import com.ibm.etools.fm.ui.memento.Db2ObjectQuerySaver;
import com.ibm.etools.fm.ui.memento.ImsDatabaseQuerySaver;
import com.ibm.etools.fm.ui.memento.ImsPsbQuerySaver;
import com.ibm.etools.fm.ui.views.systems.model.ImsTreeContent;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.PDTCCui;
import com.ibm.pdtools.common.component.ui.memento.IMementoSaver;
import com.ibm.pdtools.common.component.ui.memento.PDQuerySaver;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IMemento;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImsSubsystemConfigSaver
extends PDQuerySaver
implements IMementoSaver<ImsSubsystemConfig> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(Db2ObjectQuerySaver.class);
    public static final String TYPE_QUERY = "imsSubsystemConfig";
    private static final String KEY_CONFIG = "config";
    private static final String KEY_CUSTOM = "custom";

    public ImsSubsystemConfigSaver(IPDHost host) {
        super(host);
    }

    public void saveTo(ImsTreeContent imsContent) {
        IDialogSettings imsSection = this.getQuerySection();
        for (ImsSubsystem imsQuery : imsContent.getSubsystemsWithQueriesOrCustomConfigsForHost(this.host)) {
            this.addAQuerySection(imsSection, imsQuery, imsContent);
        }
    }

    public void saveTo(ImsPsbQuery imsPsbQuery) {
        IDialogSettings imsSection = this.getQuerySection();
        this.addAQuerySection(imsSection, imsPsbQuery);
    }

    public void saveTo(ImsDatabaseQuery imsDatabaseQuery) {
        IDialogSettings imsSection = this.getQuerySection();
        this.addAQuerySection(imsSection, imsDatabaseQuery);
    }

    public void addAQuerySection(IDialogSettings imsSection, ImsPsbQuery imsPsbQuery) {
        ImsSubsystem imsSubsystem = imsPsbQuery.getSubsystem();
        IDialogSettings imscSection = ImsSubsystemConfigSaver.getASubsystemSection(imsSection, imsSubsystem);
        new ImsPsbQuerySaver(imsSubsystem).saveTo(imsPsbQuery, imscSection);
    }

    public void addAQuerySection(IDialogSettings imsSection, ImsDatabaseQuery imsDatabaseQuery) {
        ImsSubsystem imsSubsystem = imsDatabaseQuery.getSubsystem();
        IDialogSettings imscSection = ImsSubsystemConfigSaver.getASubsystemSection(imsSection, imsSubsystem);
        new ImsDatabaseQuerySaver(imsSubsystem).saveTo(imsDatabaseQuery, imscSection);
    }

    public void addAQuerySection(IDialogSettings imsSection, ImsSubsystem imsSubsystem, ImsTreeContent imsContent) {
        IDialogSettings imscSection = ImsSubsystemConfigSaver.getASubsystemSection(imsSection, imsSubsystem);
        ImsPsbQuerySaver imsPsbQuerySaver = new ImsPsbQuerySaver(imsSubsystem);
        imsPsbQuerySaver.saveTo(imsContent, imscSection);
        ImsDatabaseQuerySaver imsDatabaseQuerySaver = new ImsDatabaseQuerySaver(imsSubsystem);
        imsDatabaseQuerySaver.saveTo(imsContent, imscSection);
    }

    private static IDialogSettings getASubsystemSection(IDialogSettings imsSection, ImsSubsystem imsSubsystem) {
        String ssid = imsSubsystem.getSubsystemID();
        IDialogSettings imscSection = PDTCCui.getSection((IDialogSettings)imsSection, (String)ssid);
        ImsSubsystemConfig imsSubsystemConfig = imsSubsystem.getCanonicalConfig();
        imscSection.put(KEY_CONFIG, I1SLParser.toXmlTag((ImsSubsystemConfig)imsSubsystemConfig).serialize());
        imscSection.put(KEY_CUSTOM, imsSubsystemConfig.isCustom());
        return imscSection;
    }

    @Deprecated
    public void saveTo(IMemento memento, ImsSubsystemConfig object) {
        memento.putString(KEY_CONFIG, I1SLParser.toXmlTag((ImsSubsystemConfig)object).serialize());
        memento.putBoolean(KEY_CUSTOM, object.isCustom());
    }

    public ArrayList<ImsSubsystemConfig> loadFrom() {
        IDialogSettings[] imscSections;
        ArrayList<ImsSubsystemConfig> query = new ArrayList<ImsSubsystemConfig>();
        IDialogSettings imsSection = this.getExistingQuerySection();
        if (imsSection != null && (imscSections = PDTCCui.getSections((IDialogSettings)imsSection)) != null) {
            IDialogSettings[] iDialogSettingsArray = imscSections;
            int n = imscSections.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogSettings aConfig = iDialogSettingsArray[n2];
                String configXml = aConfig.get(KEY_CONFIG);
                if (configXml != null) {
                    query.add(this.parseConfigurationXml(configXml, aConfig.getBoolean(KEY_CUSTOM)));
                }
                ++n2;
            }
        }
        return query;
    }

    @Deprecated
    public ImsSubsystemConfig loadFrom(IMemento memento) {
        String configXml = memento.getString(KEY_CONFIG);
        if (configXml != null) {
            Boolean custom = memento.getBoolean(KEY_CUSTOM);
            return this.parseConfigurationXml(configXml, custom == null ? true : custom);
        }
        return null;
    }

    private ImsSubsystemConfig parseConfigurationXml(String configXml, boolean custom) {
        I1SLParser parser = new I1SLParser(this.host);
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(new StringReader(configXml)), (DefaultHandler)parser);
        }
        catch (SAXException e) {
            logger.error((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error((Throwable)e);
        }
        ImsSubsystemConfig config = (ImsSubsystemConfig)((List)parser.getResult().getOutput()).get(0);
        config.setCustom(custom);
        return config;
    }

    public String getTypeName() {
        return TYPE_QUERY;
    }
}

