/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.memento;

import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.history.action.CopybookPrintActionItem;
import com.ibm.etools.fm.ui.history.action.ExportBaseResourceActionItem;
import com.ibm.etools.fm.ui.history.action.ExportDb2ResourceActionItem;
import com.ibm.etools.fm.ui.history.action.ImportFileActionItem;
import com.ibm.etools.fm.ui.history.action.OpenAsFormattedEditor1ActionItem;
import com.ibm.etools.fm.ui.history.action.OpenAsFormattedEditor2ActionItem;
import com.ibm.etools.fm.ui.history.action.OpenAsFormattedEditorActionItem;
import com.ibm.etools.fm.ui.history.action.OpenAsTemplate1ActionItem;
import com.ibm.etools.fm.ui.history.action.OpenAsTemplate2ActionItem;
import com.ibm.etools.fm.ui.history.action.OpenAsTemplateActionItem;
import com.ibm.etools.fm.ui.views.systems.handlers.AlterDataSetActionItem;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetActionItem;
import com.ibm.etools.fm.ui.wizards.AllocateHFSActionItem;
import com.ibm.etools.fm.ui.wizards.CompareActionItem;
import com.ibm.etools.fm.ui.wizards.CopyActionItem;
import com.ibm.etools.fm.ui.wizards.CreateMemberActionItem;
import com.ibm.etools.fm.ui.wizards.DeleteActionItem;
import com.ibm.etools.fm.ui.wizards.GenerateActionItem;
import com.ibm.etools.fm.ui.wizards.PrintActionItem;
import com.ibm.etools.fm.ui.wizards.RenameActionItem;
import com.ibm.etools.fm.ui.wizards.ViewLoadModuleActionItem;
import com.ibm.etools.fm.ui.wizards.db2.Db2CopyActionItem;
import com.ibm.etools.fm.ui.wizards.db2.Db2ExportActionItem;
import com.ibm.etools.fm.ui.wizards.db2.Db2GenerateActionItem;
import com.ibm.etools.fm.ui.wizards.db2.Db2ImportActionItem;
import com.ibm.etools.fm.ui.wizards.db2.Db2PrintActionItem;
import com.ibm.etools.fm.ui.wizards.ims.ImsExtractActionItem;
import com.ibm.etools.fm.ui.wizards.ims.ImsLoadActionItem;
import com.ibm.etools.fm.ui.wizards.ims.ImsPrintActionItem;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.ui.memento.IMementoSaver;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class IActionItemSaver
implements IMementoSaver<IActionItem> {
    private static final String HOST_PORT = "hostPort";
    private static final String HOST_NAME = "hostName";
    private static final String DESTINATION_SYSTEM = "system";
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String TYPE_ACTION_ITEM = "actionItem";
    public static final String TYPE_MAPPING = "mapping";
    public static final String TYPE_DDS = "dds";
    private static final String KEY_ACTION_TYPE = "type";
    private static final String KEY_CUSTOM_LABEL = "label";
    private static final String KEY_FAVORITE = "favorite";
    private static final String KEY_TIME = "time";
    private static final PDLogger logger = PDLogger.get(IActionItemSaver.class);
    private final IPDHost system;

    public static void saveParameterMapping(IMemento memento, Map<String, String> paramValues) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        IMemento mappingMemento = memento.createChild(TYPE_MAPPING);
        Set<Map.Entry<String, String>> mappings = paramValues.entrySet();
        for (Map.Entry<String, String> mapping : mappings) {
            mappingMemento.putString(mapping.getKey(), mapping.getValue());
        }
    }

    public static Map<String, String> loadParameterMapping(IMemento memento) {
        String[] attributeKeys;
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        HashMap<String, String> paramValues = new HashMap<String, String>();
        IMemento mappingMemento = memento.getChild(TYPE_MAPPING);
        String[] stringArray = attributeKeys = mappingMemento.getAttributeKeys();
        int n = attributeKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String value = mappingMemento.getString(param);
            paramValues.put(param, value);
            ++n2;
        }
        return paramValues;
    }

    public static void saveDDs(IMemento memento, Map<String, String> dds) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        IMemento mappingMemento = memento.createChild(TYPE_DDS);
        for (Map.Entry<String, String> mapping : dds.entrySet()) {
            mappingMemento.putString(mapping.getKey(), mapping.getValue());
        }
    }

    public static Map<String, String> loadDDs(IMemento memento) {
        String[] attributeKeys;
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        HashMap<String, String> dds = new HashMap<String, String>();
        IMemento mappingMemento = memento.getChild(TYPE_DDS);
        String[] stringArray = attributeKeys = mappingMemento.getAttributeKeys();
        int n = attributeKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String value = mappingMemento.getString(param);
            dds.put(param, value);
            ++n2;
        }
        return dds;
    }

    public static void saveDestinationSystem(IMemento memento, IPDHost destSystem) {
        IMemento m = memento.createChild(DESTINATION_SYSTEM);
        if (destSystem != null) {
            m.putString(HOST_NAME, destSystem.getHostName());
            m.putInteger(HOST_PORT, destSystem.getPort());
        }
    }

    public static IPDHost loadDestinationSystem(IMemento memento) {
        IMemento child = memento.getChild(DESTINATION_SYSTEM);
        if (child != null) {
            String rHost = child.getString(HOST_NAME);
            Integer port = child.getInteger(HOST_PORT);
            if (rHost != null && port != null) {
                for (IPDHost h : RegistryLocator.instance().getHostRegistry().all()) {
                    if (!h.getHostName().equals(rHost) || h.getPort() != port.intValue()) continue;
                    return h;
                }
            }
        }
        return null;
    }

    public IActionItemSaver(IPDHost system) {
        this.system = system;
    }

    public void saveTo(IMemento memento, IActionItem object) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        memento.putString(KEY_ACTION_TYPE, object.getActionType().name());
        memento.putString(KEY_CUSTOM_LABEL, object.getCustomLabel());
        memento.putBoolean(KEY_FAVORITE, object.isFavorite());
        memento.putString(KEY_TIME, Long.toString(object.getLastExecutionTime()));
        object.saveTo(memento);
    }

    public IActionItem loadFrom(IMemento memento) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        IActionItem loaded = null;
        String type = memento.getString(KEY_ACTION_TYPE);
        Objects.requireNonNull(type, "Must provide a non-null type");
        ActionType value = ActionType.valueOf(type);
        try {
            switch (value) {
                case DSP: {
                    loaded = PrintActionItem.loadFrom(memento, this.system);
                    break;
                }
                case DSC: {
                    loaded = CopyActionItem.loadFrom(memento, this.system);
                    break;
                }
                case DSG: {
                    loaded = GenerateActionItem.loadFrom(memento, this.system);
                    break;
                }
                case CREATE_MEMBER: {
                    loaded = CreateMemberActionItem.loadFrom(memento, this.system);
                    break;
                }
                case DSM: {
                    loaded = CompareActionItem.loadFrom(memento, this.system);
                    break;
                }
                case ALLOCATE_DS: {
                    loaded = AllocateDataSetActionItem.loadFrom(memento, this.system);
                    break;
                }
                case ALLOCATE_HFS: {
                    loaded = AllocateHFSActionItem.loadFrom(memento, this.system);
                    break;
                }
                case ALTER_DS: {
                    loaded = AlterDataSetActionItem.loadFrom(memento, this.system);
                    break;
                }
                case VIEW_EDIT_RESOURCE: {
                    loaded = OpenAsFormattedEditorActionItem.loadFrom(memento, this.system);
                    break;
                }
                case VIEW_EDIT_IMS_OBJECT: {
                    loaded = OpenAsFormattedEditor1ActionItem.loadFrom(memento, this.system);
                    break;
                }
                case VIEW_EDIT_DB2_OBJECT: {
                    loaded = OpenAsFormattedEditor2ActionItem.loadFrom(memento, this.system);
                    break;
                }
                case EDIT_TEMPLATE: {
                    loaded = OpenAsTemplateActionItem.loadFrom(memento, this.system);
                    break;
                }
                case EDIT_TEMPLATE1: {
                    loaded = OpenAsTemplate1ActionItem.loadFrom(memento, this.system);
                    break;
                }
                case EDIT_TEMPLATE1VIEW: {
                    loaded = OpenAsTemplate1ActionItem.loadFrom(memento, this.system);
                    break;
                }
                case EDIT_TEMPLATE2: {
                    loaded = OpenAsTemplate2ActionItem.loadFrom(memento, this.system);
                    break;
                }
                case VLM: {
                    loaded = ViewLoadModuleActionItem.loadFrom(memento, this.system);
                    break;
                }
                case DELETE: {
                    loaded = DeleteActionItem.loadFrom(memento, this.system);
                    break;
                }
                case RENAME: {
                    loaded = RenameActionItem.loadFrom(memento, this.system);
                    break;
                }
                case DBI: {
                    loaded = Db2ImportActionItem.loadFrom(memento, this.system);
                    break;
                }
                case DBX: {
                    loaded = Db2ExportActionItem.loadFrom(memento, this.system);
                    break;
                }
                case DBC: {
                    loaded = Db2CopyActionItem.loadFrom(memento, this.system);
                    break;
                }
                case D2G: {
                    loaded = Db2GenerateActionItem.loadFrom(memento, this.system);
                    break;
                }
                case DBP: {
                    loaded = Db2PrintActionItem.loadFrom(memento, this.system);
                    break;
                }
                case IXB: {
                    loaded = ImsExtractActionItem.loadFrom(memento, this.system);
                    break;
                }
                case IPR: {
                    loaded = ImsPrintActionItem.loadFrom(memento, this.system);
                    break;
                }
                case ILB: {
                    loaded = ImsLoadActionItem.loadFrom(memento, this.system);
                    break;
                }
                case EXPORT_DESKTOP_BASE: {
                    loaded = ExportBaseResourceActionItem.loadFrom(memento, this.system);
                    break;
                }
                case EXPORT_DESKTOP_DB2: {
                    loaded = ExportDb2ResourceActionItem.loadFrom(memento, this.system);
                    break;
                }
                case IMPORT_DESKTOP_BASE: {
                    loaded = ImportFileActionItem.loadFrom(memento, this.system);
                    break;
                }
                case COPYBOOK_PRINT: {
                    loaded = CopybookPrintActionItem.loadFrom(memento, this.system);
                    break;
                }
                default: {
                    loaded = null;
                }
            }
            if (loaded == null) {
                logger.error((Object)("Unable to load action item of type " + type));
                return null;
            }
        }
        catch (RuntimeException e) {
            String mementoStr = "";
            if (memento instanceof XMLMemento) {
                XMLMemento xmlMemento = (XMLMemento)memento;
                StringWriter sw = new StringWriter();
                try {
                    xmlMemento.save((Writer)sw);
                    mementoStr = sw.getBuffer().toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            logger.error((Object)("Unable to load action item of type " + type + "\nMemento = " + mementoStr), (Throwable)e);
            return null;
        }
        String customLabel = memento.getString(KEY_CUSTOM_LABEL);
        loaded.setCustomLabel(customLabel);
        boolean isFavorite = memento.getBoolean(KEY_FAVORITE);
        loaded.setFavorite(isFavorite);
        String loadedLong = memento.getString(KEY_TIME);
        if (loadedLong != null) {
            loaded.setLastExecutionTime(Long.parseLong(loadedLong));
        }
        return loaded;
    }

    public String getTypeName() {
        return TYPE_ACTION_ITEM;
    }
}

