/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.memento;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.db2.Db2EditorOptions;
import com.ibm.etools.fm.core.model.db2.Db2SystemOptions;
import com.ibm.etools.fm.core.model.ims.ImsDd;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.jhost.core.model.EmptyZRL;
import com.ibm.pdtools.common.component.jhost.core.model.IHostSystem;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.memento.IMementoSaver;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IMemento;

public class HostSaver
implements IMementoSaver<IPDHost> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(HostSaver.class);
    public static final String TYPE = "system";
    public static final String KEY_HOST_ID = "hostID";
    public static final String KEY_COMPILER_OPTIONS = "compilerOptions";
    public static final String TYPE_TEMPLATE_ASSOCIATIONS = "templateAssociations";
    public static final String KEY_RESOURCE_NAME = "resourceName";
    public static final String TYPE_ASSOCIATION = "association";
    public static final String KEY_TEMPLATE_NAME = "resourceName";
    public static final String TYPE_RESOURCE = "resource";
    private static final String KEY_SSID = "ssid";
    public static final String TYPE_DB2_SYSOPTS_LIST = "db2SysOpsList";
    public static final String TYPE_DB2_SYSOPTS = "db2SysOps";
    public static final String KEY_DB2_SYSOPTS_DECFLOAT = "DecFloat";
    public static final String KEY_DB2_SYSOPTS_ENCAPS = "Encaps";
    public static final String KEY_DB2_SYSOPTS_FKEY = "FKey";
    public static final String KEY_DB2_SYSOPTS_TIME = "Time";
    public static final String KEY_DB2_SYSOPTS_UCS = "UCS";
    public static final String KEY_DB2_SYSOPTS_UR = "UR";
    public static final String TYPE_DB2_EDITOPTS_LIST = "db2EditOpsList";
    public static final String TYPE_DB2_EDITOPTS = "db2EditOps";
    public static final String KEY_DB2_EDITOPTS_AUTOCOM = "AutoCom";
    public static final String KEY_DB2_EDITOPTS_AUTOZTS = "AutoZTS";
    public static final String KEY_DB2_EDITOPTS_CNVSPNUL = "CNVSPNUL";
    public static final String KEY_DB2_EDITOPTS_COMFETCH = "ComFetch";
    public static final String KEY_DB2_EDITOPTS_COMNOSVE = "ComNoSave";
    public static final String KEY_DB2_EDITOPTS_COMSAVE = "ComSave";
    public static final String KEY_DB2_EDITOPTS_CONCURR = "ConCurr";
    public static final String KEY_DB2_EDITOPTS_CSRTYPE = "CSRType";
    public static final String KEY_DB2_EDITOPTS_DNULLIND = "DNullInd";
    public static final String KEY_DB2_EDITOPTS_DVCDELIM = "DVCDelim";
    public static final String KEY_DB2_EDITOPTS_ENTEROP = "EnterOp";
    public static final String KEY_DB2_EDITOPTS_FSKIP = "FSkip";
    public static final String KEY_DB2_EDITOPTS_INCL = "INCL";
    public static final String KEY_DB2_EDITOPTS_ISKIP = "ISkip";
    public static final String KEY_DB2_EDITOPTS_KLOCK = "KLock";
    public static final String KEY_DB2_EDITOPTS_LOCK = "Lock";
    public static final String KEY_DB2_EDITOPTS_NULLIND = "NullInd";
    public static final String KEY_DB2_EDITOPTS_OPTROWC = "OptRowC";
    public static final String KEY_DB2_EDITOPTS_OPTROWS = "OptRows";
    public static final String KEY_DB2_EDITOPTS_RDONLY = "RDOnly";
    public static final String KEY_DB2_EDITOPTS_SAMTYPE = "SAMType";
    public static final String KEY_DB2_EDITOPTS_SFREQ = "SFreq";
    public static final String KEY_DB2_EDITOPTS_SHOWENDVC = "ShowEndVC";
    public static final String KEY_DB2_EDITOPTS_SKIPLOCK = "SkipLock";
    public static final String KEY_DB2_EDITOPTS_SLIMIT = "SLimit";
    public static final String KEY_DB2_EDITOPTS_SSEED = "SSeed";
    public static final String KEY_DB2_EDITOPTS_UPKEY = "UpKey";
    public static final String KEY_DB2_EDITOPTS_VCDELIM = "VCDelim";
    public static final String KEY_DB2_EDITOPTS_INPUTDELM = "Inputdelm";
    public static final String TYPE_IMS_DB_DSN_DDS_LIST = "imsDbDsnDdsList";
    public static final String TYPE_IMS_DB_DSN_DDS = "imsDbDsnDds";
    public static final String KEY_IMS_DB_DSN_DDS_SSID = "ssid";
    public static final String KEY_IMS_DB_DSN_DDS_DB_NAME = "dbName";
    public static final String TYPE_IMS_DB_DSN_DD = "imsDbDsnDd";
    public static final String KEY_IMS_DB_DSN_DD_DBD = "dbd";
    public static final String KEY_IMS_DB_DSN_DD_NAME = "name";
    public static final String KEY_IMS_DB_DSN_DD_DSN = "dsn";
    private boolean savingOnlyEssentials = false;

    public void saveTo(IMemento memento, IPDHost object) {
        memento.putString(KEY_HOST_ID, object.getHostID());
        if (!this.savingOnlyEssentials) {
            IMemento associationMemento = memento.createChild(TYPE_TEMPLATE_ASSOCIATIONS);
            for (IZRL resource : FMHost.getSystem((IPDHost)object).getAssociatedResources()) {
                IMemento resourceMemento = associationMemento.createChild(TYPE_RESOURCE);
                resourceMemento.putString("resourceName", resource.getFormattedName());
                for (IZRL iZRL : FMHost.getSystem((IPDHost)object).getAllTemplateAssociations(resource)) {
                    IMemento templateMemento = resourceMemento.createChild(TYPE_ASSOCIATION);
                    templateMemento.putString("resourceName", iZRL.getFormattedName());
                    IActionItemSaver.saveDestinationSystem(templateMemento, iZRL.getSystem());
                }
            }
            IMemento db2EditorOptionsListMemento = memento.createChild(TYPE_DB2_EDITOPTS_LIST);
            for (String ssid : ((FMHost)FMHost.getSystem((IPDHost)object)).getDB2EditorOptionsSSIDs()) {
                IMemento iMemento = db2EditorOptionsListMemento.createChild(TYPE_DB2_EDITOPTS);
                iMemento.putString("ssid", ssid);
                this.writeDB2EditorOptionsToMemento(((FMHost)FMHost.getSystem((IPDHost)object)).getDb2EditorOptions(ssid), iMemento);
            }
            memento.putMemento(db2EditorOptionsListMemento);
            IMemento db2systemOptionsListMemento = memento.createChild(TYPE_DB2_SYSOPTS_LIST);
            for (String ssid : ((FMHost)FMHost.getSystem((IPDHost)object)).getDB2SystemOptionsSSIDs()) {
                IMemento systemOptionMemento = db2systemOptionsListMemento.createChild(TYPE_DB2_SYSOPTS);
                systemOptionMemento.putString("ssid", ssid);
                this.writeDB2SystemOptionsToMemento(((FMHost)FMHost.getSystem((IPDHost)object)).getDb2SystemOptions(ssid), systemOptionMemento);
            }
            memento.putMemento(db2systemOptionsListMemento);
            IMemento dbsListMemento = memento.createChild(TYPE_IMS_DB_DSN_DDS_LIST);
            for (Map.Entry entry : ((FMHost)FMHost.getSystem((IPDHost)object)).getImsSsidToDatabaseToDataSetDds().entrySet()) {
                for (Map.Entry dbNameToDds : ((Map)entry.getValue()).entrySet()) {
                    IMemento dbMemento = dbsListMemento.createChild(TYPE_IMS_DB_DSN_DDS);
                    dbMemento.putString("ssid", (String)entry.getKey());
                    dbMemento.putString(KEY_IMS_DB_DSN_DDS_DB_NAME, (String)dbNameToDds.getKey());
                    for (ImsDd imsDd : (List)dbNameToDds.getValue()) {
                        IMemento ddMemento = dbMemento.createChild(TYPE_IMS_DB_DSN_DD);
                        ddMemento.putString(KEY_IMS_DB_DSN_DD_DBD, imsDd.getDbdName());
                        ddMemento.putString(KEY_IMS_DB_DSN_DD_DSN, imsDd.getDsn());
                        ddMemento.putString(KEY_IMS_DB_DSN_DD_NAME, imsDd.getName());
                    }
                }
            }
        }
    }

    public IPDHost loadFrom(IMemento memento) {
        IMemento templateMemento2;
        int n;
        int n2;
        IMemento[] iMementoArray;
        String hostID = memento.getString(KEY_HOST_ID);
        PDHost system = PDHost.create((String)hostID, (String)"dummy", (int)0);
        HashMap templateAssociations = new HashMap();
        IMemento templateAssocsMemento = memento.getChild(TYPE_TEMPLATE_ASSOCIATIONS);
        if (templateAssocsMemento != null) {
            IMemento[] iMementoArray2 = templateAssocsMemento.getChildren(TYPE_RESOURCE);
            int n3 = iMementoArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemento resourceMemento = iMementoArray2[n4];
                ArrayList<Object> resourceAssociations = new ArrayList<Object>();
                iMementoArray = resourceMemento.getChildren(TYPE_ASSOCIATION);
                n2 = iMementoArray.length;
                n = 0;
                while (n < n2) {
                    block26: {
                        templateMemento2 = iMementoArray[n];
                        String templateName = templateMemento2.getString("resourceName");
                        IPDHost destSystem = IActionItemSaver.loadDestinationSystem(templateMemento2);
                        if (templateName != null) {
                            if (templateName.trim().isEmpty()) {
                                resourceAssociations.add(new EmptyZRL());
                            } else {
                                try {
                                    if (destSystem != null) {
                                        resourceAssociations.add(ZRLs.parseZRL((IPDHost)destSystem, (String)templateName));
                                        break block26;
                                    }
                                    resourceAssociations.add(ZRLs.parseZRL((IPDHost)system, (String)templateName));
                                }
                                catch (Exception e) {
                                    logger.trace((Object)MessageFormat.format("Saved template {0} has invalid characters.", templateName));
                                }
                            }
                        } else {
                            logger.trace((Object)MessageFormat.format("Saved resource {0} was saved with no associated templates.", resourceMemento.getString("resourceName")));
                        }
                    }
                    ++n;
                }
                templateAssociations.put(resourceMemento.getString("resourceName"), resourceAssociations);
                ++n4;
            }
        }
        IMemento db2EditorOptsListMemento = memento.getChild(TYPE_DB2_EDITOPTS_LIST);
        HashMap<String, Db2EditorOptions> editorList = null;
        if (db2EditorOptsListMemento != null) {
            editorList = new HashMap<String, Db2EditorOptions>();
            templateMemento2 = db2EditorOptsListMemento.getChildren(TYPE_DB2_EDITOPTS);
            int resourceAssociations = ((IMemento[])templateMemento2).length;
            int n5 = 0;
            while (n5 < resourceAssociations) {
                IMemento editorOptsMemento = templateMemento2[n5];
                editorList.put(editorOptsMemento.getString("ssid"), this.readDB2EditorOptionsFromMemento(editorOptsMemento));
                ++n5;
            }
        }
        IMemento db2SystemOptsListMemento = memento.getChild(TYPE_DB2_SYSOPTS_LIST);
        HashMap<String, Db2SystemOptions> systemList = null;
        if (db2SystemOptsListMemento != null) {
            systemList = new HashMap<String, Db2SystemOptions>();
            IMemento[] iMementoArray3 = db2SystemOptsListMemento.getChildren(TYPE_DB2_SYSOPTS);
            n = iMementoArray3.length;
            int templateMemento2 = 0;
            while (templateMemento2 < n) {
                IMemento sysOptsMemento = iMementoArray3[templateMemento2];
                systemList.put(sysOptsMemento.getString("ssid"), this.readDB2SystemOptionsFromMemento(sysOptsMemento));
                ++templateMemento2;
            }
        }
        if (FMHost.getSystem((IPDHost)system) == null) {
            system.setAHostExtend((IHostSystem)new FMHost());
        }
        if (!this.savingOnlyEssentials) {
            IMemento dbsListMemento;
            for (Map.Entry entry : templateAssociations.entrySet()) {
                if (!ZRLs.isParseable((IPDHost)system, (String)((String)entry.getKey()))) {
                    logger.trace((Object)("Unable to load resource-template associations because path is not valid ZRL path: " + (String)entry.getKey()));
                    continue;
                }
                for (IZRL templateName : (List)entry.getValue()) {
                    FMHost.getSystem((IPDHost)system).addTemplateAssociation(ZRLs.parseZRL((IPDHost)system, (String)((String)entry.getKey())), templateName);
                }
            }
            if (editorList != null) {
                for (Map.Entry entry : editorList.entrySet()) {
                    ((FMHost)FMHost.getSystem((IPDHost)system)).putDb2EditorOptions((String)entry.getKey(), (Db2EditorOptions)entry.getValue());
                }
            }
            if (systemList != null) {
                for (Map.Entry entry : systemList.entrySet()) {
                    ((FMHost)FMHost.getSystem((IPDHost)system)).putDb2SystemOptions((String)entry.getKey(), (Db2SystemOptions)entry.getValue());
                }
            }
            if ((dbsListMemento = memento.getChild(TYPE_IMS_DB_DSN_DDS_LIST)) != null) {
                iMementoArray = dbsListMemento.getChildren(TYPE_IMS_DB_DSN_DDS);
                n2 = iMementoArray.length;
                int n6 = 0;
                while (n6 < n2) {
                    IMemento dbMemento = iMementoArray[n6];
                    String ssid = dbMemento.getString("ssid");
                    String dbName = dbMemento.getString(KEY_IMS_DB_DSN_DDS_DB_NAME);
                    ArrayList<ImsDd> dds = new ArrayList<ImsDd>();
                    IMemento[] iMementoArray4 = dbMemento.getChildren(TYPE_IMS_DB_DSN_DD);
                    int n7 = iMementoArray4.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        IMemento ddMemento = iMementoArray4[n8];
                        String dbd = ddMemento.getString(KEY_IMS_DB_DSN_DD_DBD);
                        String name = ddMemento.getString(KEY_IMS_DB_DSN_DD_NAME);
                        String dsn = ddMemento.getString(KEY_IMS_DB_DSN_DD_DSN);
                        ImsDd dd = new ImsDd(dbd, name);
                        dd.setDsn(dsn);
                        dds.add(dd);
                        ++n8;
                    }
                    ((FMHost)FMHost.getSystem((IPDHost)system)).setImsDatabaseDataSetDds(new ImsSubsystem((IPDHost)system, ssid), dbName, dds);
                    ++n6;
                }
            }
        }
        return system;
    }

    public String getTypeName() {
        return TYPE;
    }

    public void setSavingOnlyEssentials(boolean saveOnlyHostAndPort) {
        this.savingOnlyEssentials = saveOnlyHostAndPort;
    }

    public boolean isSavingOnlyEssentials() {
        return this.savingOnlyEssentials;
    }

    public void writeDB2SystemOptionsToMemento(Db2SystemOptions sysOpts, IMemento memento) {
        memento.putBoolean(KEY_DB2_SYSOPTS_UCS, sysOpts.getUCS());
        memento.putBoolean(KEY_DB2_SYSOPTS_UR, sysOpts.getUR());
        memento.putBoolean(KEY_DB2_SYSOPTS_FKEY, sysOpts.getFKEY());
        memento.putString(KEY_DB2_SYSOPTS_DECFLOAT, sysOpts.getDECFLOAT().toString());
        memento.putString(KEY_DB2_SYSOPTS_ENCAPS, sysOpts.getENCAPS().toString());
        memento.putString(KEY_DB2_SYSOPTS_TIME, sysOpts.getTIME().toString());
    }

    public Db2SystemOptions readDB2SystemOptionsFromMemento(IMemento memento) {
        Db2SystemOptions sysOpts = new Db2SystemOptions();
        sysOpts.setDECFLOAT(Db2SystemOptions.DECFLOAT_TYPE.getStrValueToType((String)memento.getString(KEY_DB2_SYSOPTS_DECFLOAT)));
        sysOpts.setENCAPS(Db2SystemOptions.ENCAPS_TYPE.getStrValueToType((String)memento.getString(KEY_DB2_SYSOPTS_ENCAPS)));
        sysOpts.setFKEY(memento.getBoolean(KEY_DB2_SYSOPTS_FKEY).booleanValue());
        sysOpts.setTIME(Db2SystemOptions.EXTERNAL_FORMAT_TIME.getStrValueToType((String)KEY_DB2_SYSOPTS_TIME));
        sysOpts.setUCS(memento.getBoolean(KEY_DB2_SYSOPTS_UCS).booleanValue());
        sysOpts.setUR(memento.getBoolean(KEY_DB2_SYSOPTS_UR).booleanValue());
        return sysOpts;
    }

    public void writeDB2EditorOptionsToMemento(Db2EditorOptions editOpts, IMemento memento) {
        memento.putBoolean(KEY_DB2_EDITOPTS_AUTOZTS, editOpts.getAUTOZTS());
        memento.putBoolean(KEY_DB2_EDITOPTS_CNVSPNUL, editOpts.getCNVSPNUL());
        memento.putBoolean(KEY_DB2_EDITOPTS_COMFETCH, editOpts.getCOMFETCH());
        memento.putBoolean(KEY_DB2_EDITOPTS_COMNOSVE, editOpts.getCOMNOSVE());
        memento.putBoolean(KEY_DB2_EDITOPTS_COMSAVE, editOpts.getCOMSAVE());
        memento.putBoolean(KEY_DB2_EDITOPTS_OPTROWC, editOpts.getOPTROWC());
        memento.putBoolean(KEY_DB2_EDITOPTS_RDONLY, editOpts.getRDONLY());
        memento.putBoolean(KEY_DB2_EDITOPTS_SHOWENDVC, editOpts.getSHWENDVC());
        memento.putBoolean(KEY_DB2_EDITOPTS_INPUTDELM, editOpts.getDISABLEINPUTDELIM());
        memento.putBoolean(KEY_DB2_EDITOPTS_SKIPLOCK, editOpts.getSKIPLOCK());
        memento.putBoolean(KEY_DB2_EDITOPTS_UPKEY, editOpts.getUPKEY());
        memento.putString(KEY_DB2_EDITOPTS_AUTOCOM, editOpts.getAUTOCOM());
        memento.putString(KEY_DB2_EDITOPTS_DNULLIND, editOpts.getDNULLIND());
        memento.putString(KEY_DB2_EDITOPTS_DVCDELIM, editOpts.getDVCDELIM());
        memento.putString(KEY_DB2_EDITOPTS_FSKIP, editOpts.getFSKIP());
        memento.putString(KEY_DB2_EDITOPTS_INCL, editOpts.getINCL());
        memento.putString(KEY_DB2_EDITOPTS_ISKIP, editOpts.getISKIP());
        memento.putString(KEY_DB2_EDITOPTS_NULLIND, editOpts.getNULLIND());
        memento.putString(KEY_DB2_EDITOPTS_OPTROWS, editOpts.getOPTROWS());
        memento.putString(KEY_DB2_EDITOPTS_SFREQ, editOpts.getSFREQ());
        memento.putString(KEY_DB2_EDITOPTS_SLIMIT, editOpts.getSLIMIT());
        memento.putString(KEY_DB2_EDITOPTS_SSEED, editOpts.getSSEED());
        memento.putString(KEY_DB2_EDITOPTS_VCDELIM, editOpts.getVCDELIM());
        memento.putString(KEY_DB2_EDITOPTS_CONCURR, editOpts.getCONCURR().toString());
        memento.putString(KEY_DB2_EDITOPTS_CSRTYPE, editOpts.getCSRTYPE().toString());
        memento.putString(KEY_DB2_EDITOPTS_ENTEROP, editOpts.getENTEROP().toString());
        memento.putString(KEY_DB2_EDITOPTS_KLOCK, editOpts.getKLOCK().toString());
        memento.putString(KEY_DB2_EDITOPTS_LOCK, editOpts.getLOCK().toString());
        memento.putString(KEY_DB2_EDITOPTS_SAMTYPE, editOpts.getSAMTYPE().toString());
    }

    public Db2EditorOptions readDB2EditorOptionsFromMemento(IMemento memento) {
        Db2EditorOptions editOpts = new Db2EditorOptions();
        editOpts.setAUTOZTS(memento.getBoolean(KEY_DB2_EDITOPTS_AUTOZTS).booleanValue());
        editOpts.setCNVSPNUL(memento.getBoolean(KEY_DB2_EDITOPTS_CNVSPNUL).booleanValue());
        editOpts.setCOMFETCH(memento.getBoolean(KEY_DB2_EDITOPTS_COMFETCH).booleanValue());
        editOpts.setCOMNOSVE(memento.getBoolean(KEY_DB2_EDITOPTS_COMNOSVE).booleanValue());
        editOpts.setCOMSAVE(memento.getBoolean(KEY_DB2_EDITOPTS_COMSAVE).booleanValue());
        editOpts.setOPTROWC(memento.getBoolean(KEY_DB2_EDITOPTS_OPTROWC).booleanValue());
        editOpts.setRDONLY(memento.getBoolean(KEY_DB2_EDITOPTS_RDONLY).booleanValue());
        editOpts.setSHWENDVC(memento.getBoolean(KEY_DB2_EDITOPTS_SHOWENDVC).booleanValue());
        editOpts.setDISABLEINPUTDELIM(memento.getBoolean(KEY_DB2_EDITOPTS_INPUTDELM).booleanValue());
        editOpts.setSKIPLOCK(memento.getBoolean(KEY_DB2_EDITOPTS_SKIPLOCK).booleanValue());
        editOpts.setUPKEY(memento.getBoolean(KEY_DB2_EDITOPTS_UPKEY).booleanValue());
        editOpts.setAUTOCOM(memento.getString(KEY_DB2_EDITOPTS_AUTOCOM));
        editOpts.setDNULLIND(memento.getString(KEY_DB2_EDITOPTS_DNULLIND));
        editOpts.setDVCDELIM(memento.getString(KEY_DB2_EDITOPTS_DVCDELIM));
        editOpts.setFSKIP(memento.getString(KEY_DB2_EDITOPTS_FSKIP));
        editOpts.setINCL(memento.getString(KEY_DB2_EDITOPTS_INCL));
        editOpts.setISKIP(memento.getString(KEY_DB2_EDITOPTS_ISKIP));
        editOpts.setNULLIND(memento.getString(KEY_DB2_EDITOPTS_NULLIND));
        editOpts.setOPTROWS(memento.getString(KEY_DB2_EDITOPTS_OPTROWS));
        editOpts.setSFREQ(memento.getString(KEY_DB2_EDITOPTS_SFREQ));
        editOpts.setSLIMIT(memento.getString(KEY_DB2_EDITOPTS_SLIMIT));
        editOpts.setSSEED(memento.getString(KEY_DB2_EDITOPTS_SSEED));
        editOpts.setVCDELIM(memento.getString(KEY_DB2_EDITOPTS_VCDELIM));
        editOpts.setCONCURR(Db2EditorOptions.CONCURR_TYPE.getStrValueToType((String)memento.getString(KEY_DB2_EDITOPTS_CONCURR)));
        editOpts.setCSRTYPE(Db2EditorOptions.CSRTYPE_TYPE.getStrValueToType((String)memento.getString(KEY_DB2_EDITOPTS_CSRTYPE)));
        editOpts.setENTEROP(Db2EditorOptions.ENTEROP_TYPE.getStrValueToType((String)memento.getString(KEY_DB2_EDITOPTS_ENTEROP)));
        editOpts.setKLOCK(Db2EditorOptions.KLOCK_TYPE.getStrValueToType((String)memento.getString(KEY_DB2_EDITOPTS_KLOCK)));
        editOpts.setLOCK(Db2EditorOptions.LOCK_TYPE.getStrValueToType((String)memento.getString(KEY_DB2_EDITOPTS_LOCK)));
        editOpts.setSAMTYPE(Db2EditorOptions.SAMTYPE_TYPE.getStrValueToType((String)memento.getString(KEY_DB2_EDITOPTS_SAMTYPE)));
        return editOpts;
    }
}

