/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.memento;

import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.views.systems.model.Db2TreeContent;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.PDTCCui;
import com.ibm.pdtools.common.component.ui.memento.IMementoSaver;
import com.ibm.pdtools.common.component.ui.memento.PDQuerySaver;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IMemento;

public class Db2ObjectQuerySaver
extends PDQuerySaver
implements IMementoSaver<Db2ObjectQuery<?>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(Db2ObjectQuerySaver.class);
    public static final String TYPE_QUERY = "db2ObjectQuery";
    private static final String KEY_SSID = "ssid";
    private static final String KEY_OWNER = "owner";
    private static final String KEY_DATABASE = "database";
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private static final String TYPE_VALUE_DATABASE = "database";
    private static final String TYPE_VALUE_TABLE = "table";

    public Db2ObjectQuerySaver(IPDHost host) {
        super(host);
    }

    public void saveTo(Db2TreeContent db2Content) {
        IDialogSettings db2Section = this.getQuerySection();
        for (Db2ObjectQuery<?> db2Query : db2Content.getQueriesForHost(this.host)) {
            this.addAQuerySection(db2Section, db2Query);
        }
    }

    public void saveTo(Db2ObjectQuery<?> object) {
        IDialogSettings db2Section = this.getQuerySection();
        this.addAQuerySection(db2Section, object);
    }

    public void addAQuerySection(IDialogSettings db2Section, Db2ObjectQuery<?> object) {
        Db2Subsystem subsys = object.getSubsystem();
        String ssid = subsys.getName();
        String owner = object.getOwnerPattern();
        String database = object.getDatabasePattern();
        String name = object.getNamePattern();
        String queryType = "";
        if (Db2Database.class.equals((Object)object.getType())) {
            queryType = "database";
        } else if (Db2Table.class.equals((Object)object.getType())) {
            queryType = TYPE_VALUE_TABLE;
        } else {
            logger.debug((Object)("Don't know how to save query of type " + object.getClass().getCanonicalName()));
        }
        IDialogSettings db2qSection = PDTCCui.addSection((IDialogSettings)db2Section, (String)(ssid + owner + database + name + queryType));
        db2qSection.put(KEY_SSID, ssid);
        db2qSection.put(KEY_OWNER, owner);
        db2qSection.put("database", database);
        db2qSection.put(KEY_NAME, name);
        db2qSection.put(KEY_TYPE, queryType);
    }

    @Deprecated
    public void saveTo(IMemento memento, Db2ObjectQuery<?> object) {
        Db2Subsystem subsys = object.getSubsystem();
        memento.putString(KEY_SSID, subsys.getName());
        memento.putString(KEY_OWNER, object.getOwnerPattern());
        memento.putString("database", object.getDatabasePattern());
        memento.putString(KEY_NAME, object.getNamePattern());
        if (Db2Database.class.equals((Object)object.getType())) {
            memento.putString(KEY_TYPE, "database");
        } else if (Db2Table.class.equals((Object)object.getType())) {
            memento.putString(KEY_TYPE, TYPE_VALUE_TABLE);
        } else {
            logger.debug((Object)("Don't know how to save query of type " + object.getClass().getCanonicalName()));
        }
    }

    public ArrayList<Db2ObjectQuery<?>> loadFrom() {
        IDialogSettings[] db2qSections;
        ArrayList query = new ArrayList();
        IDialogSettings db2Section = this.getExistingQuerySection();
        if (db2Section != null && (db2qSections = PDTCCui.getSections((IDialogSettings)db2Section)) != null) {
            IDialogSettings[] iDialogSettingsArray = db2qSections;
            int n = db2qSections.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogSettings aQuery = iDialogSettingsArray[n2];
                String ssid = aQuery.get(KEY_SSID);
                if (ssid != null) {
                    Db2Subsystem subsys = new Db2Subsystem(this.host, ssid);
                    Db2ObjectQuery aDb2Query = null;
                    String ownerPattern = aQuery.get(KEY_OWNER);
                    String databasePattern = aQuery.get("database");
                    String namePattern = aQuery.get(KEY_NAME);
                    String queryType = aQuery.get(KEY_TYPE);
                    if ("database".equals(queryType)) {
                        aDb2Query = new Db2ObjectQuery(subsys, Db2Database.class);
                    } else if (TYPE_VALUE_TABLE.equals(queryType)) {
                        aDb2Query = new Db2ObjectQuery(subsys, Db2Table.class);
                    } else {
                        logger.debug((Object)("Don't know how to load query of type " + queryType));
                        return null;
                    }
                    if (!Db2ObjectQuery.isValidDatabasePattern((String)databasePattern)) {
                        logger.debug((Object)("Not loading DB2 object query because database pattern is invalid: " + databasePattern));
                        return null;
                    }
                    if (!Db2ObjectQuery.isValidNamePattern((String)namePattern)) {
                        logger.debug((Object)("Not loading DB2 object query because name pattern is invalid: " + namePattern));
                        return null;
                    }
                    aDb2Query.setOwnerPattern(ownerPattern);
                    aDb2Query.setDatabasePattern(databasePattern);
                    aDb2Query.setNamePattern(namePattern);
                    query.add(aDb2Query);
                }
                ++n2;
            }
        }
        return query;
    }

    @Deprecated
    public Db2ObjectQuery<?> loadFrom(IMemento memento) {
        String ssid = memento.getString(KEY_SSID);
        Db2Subsystem subsys = new Db2Subsystem(this.host, ssid);
        Db2ObjectQuery query = null;
        String ownerPattern = memento.getString(KEY_OWNER);
        String databasePattern = memento.getString("database");
        String namePattern = memento.getString(KEY_NAME);
        String type = memento.getString(KEY_TYPE);
        if ("database".equals(type)) {
            query = new Db2ObjectQuery(subsys, Db2Database.class);
        } else if (TYPE_VALUE_TABLE.equals(type)) {
            query = new Db2ObjectQuery(subsys, Db2Table.class);
        } else {
            logger.debug((Object)("Don't know how to load query of type " + type));
            return null;
        }
        if (!Db2ObjectQuery.isValidDatabasePattern((String)databasePattern)) {
            logger.debug((Object)("Not loading DB2 object query because database pattern is invalid: " + databasePattern));
            return null;
        }
        if (!Db2ObjectQuery.isValidNamePattern((String)namePattern)) {
            logger.debug((Object)("Not loading DB2 object query because name pattern is invalid: " + namePattern));
            return null;
        }
        query.setOwnerPattern(ownerPattern);
        query.setDatabasePattern(databasePattern);
        query.setNamePattern(namePattern);
        return query;
    }

    public String getTypeName() {
        return TYPE_QUERY;
    }
}

