/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.memento;

import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.memento.IMementoSaver;
import java.util.ArrayList;
import org.eclipse.ui.IMemento;

public class DataSetQuerySaver
implements IMementoSaver<DataSetQuery> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(DataSetQuerySaver.class);
    public static final String TYPE_QUERY = "dataSetQuery";
    private static final String KEY_QUERY = "query";
    public static final String TYPE_FILTER = "filterType";
    private static final String KEY_FILTER_TYPE_NAME = "name";
    private final IPDHost host;

    public DataSetQuerySaver(IPDHost host) {
        this.host = host;
    }

    public boolean canSave(DataSetQuery object) {
        String queryString = object.getRawQuery();
        return !"CURRENT_USERNAME_QUERY".equals(queryString);
    }

    public void saveTo(IMemento memento, DataSetQuery object) {
        if (!this.canSave(object)) {
            throw new IllegalArgumentException(object.getRawQuery());
        }
        memento.putString(KEY_QUERY, object.getQuery());
        for (DataSetType dsType : object.getTypesFiltered()) {
            IMemento mementoType = memento.createChild(TYPE_FILTER);
            mementoType.putString(KEY_FILTER_TYPE_NAME, dsType.toString());
        }
    }

    public DataSetQuery loadFrom(IMemento memento) {
        IMemento[] filterMementos;
        DataSetQuery query = null;
        String queryString = memento.getString(KEY_QUERY);
        query = DataSetQuery.create((IPDHost)this.host, (String)queryString);
        ArrayList<DataSetType> typesFiltered = new ArrayList<DataSetType>();
        IMemento[] iMementoArray = filterMementos = memento.getChildren(TYPE_FILTER);
        int n = filterMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento filterMemento = iMementoArray[n2];
            String filteredType = filterMemento.getString(KEY_FILTER_TYPE_NAME);
            try {
                typesFiltered.add(DataSetType.valueOf((String)filteredType));
            }
            catch (Exception e) {
                logger.debug((Object)("Not loading data set query; unable to parse data set type of: " + filteredType), (Throwable)e);
                return null;
            }
            ++n2;
        }
        query.setTypesFiltered(typesFiltered);
        return query;
    }

    public String getTypeName() {
        return TYPE_QUERY;
    }
}

