/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.memento;

import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsFileQuery;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorageQuery;
import com.ibm.etools.fm.core.model.cics.CicsTransientDataQuery;
import com.ibm.etools.fm.ui.views.systems.model.CicsTreeContent;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.PDTCCui;
import com.ibm.pdtools.common.component.ui.memento.IMementoSaver;
import com.ibm.pdtools.common.component.ui.memento.PDQuerySaver;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IMemento;

public class CicsResourceQuerySaver
extends PDQuerySaver
implements IMementoSaver<CicsResourceQuery<?>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(CicsResourceQuerySaver.class);
    public static final String TYPE_QUERY = "cicsResourceQuery";
    private static final String KEY_APPL = "appl";
    private static final String KEY_QUERY = "query";
    private static final String KEY_QUERY_TYPE = "type";
    private static final String QUERY_FILE = "FI";
    private static final String QUERY_TD = "TD";
    private static final String QUERY_TS = "TS";

    public CicsResourceQuerySaver(IPDHost host) {
        super(host);
    }

    public void saveTo(CicsTreeContent cicsContent) {
        IDialogSettings cicsSection = this.getQuerySection();
        for (CicsResourceQuery<?> cicsQuery : cicsContent.getQueriesForHost(this.host)) {
            this.addAQuerySection(cicsSection, cicsQuery);
        }
    }

    public void saveTo(CicsResourceQuery<?> object) {
        IDialogSettings cicsSection = this.getQuerySection();
        this.addAQuerySection(cicsSection, object);
    }

    public void addAQuerySection(IDialogSettings cicsSection, CicsResourceQuery<?> object) {
        CicsAppl appl = object.getCICSAppl();
        String name = appl.getName();
        String queryType = "";
        if (object instanceof CicsFileQuery) {
            queryType = QUERY_FILE;
        } else if (object instanceof CicsTransientDataQuery) {
            queryType = QUERY_TD;
        } else if (object instanceof CicsTemporaryStorageQuery) {
            queryType = QUERY_TS;
        }
        String query = object.getQuery();
        IDialogSettings cicsqSection = PDTCCui.addSection((IDialogSettings)cicsSection, (String)(name + queryType + query));
        cicsqSection.put(KEY_APPL, name);
        cicsqSection.put(KEY_QUERY_TYPE, queryType);
        cicsqSection.put(KEY_QUERY, query);
    }

    @Deprecated
    public void saveTo(IMemento memento, CicsResourceQuery<?> object) {
        CicsAppl appl = object.getCICSAppl();
        memento.putString(KEY_APPL, appl.getName());
        if (object instanceof CicsFileQuery) {
            memento.putString(KEY_QUERY_TYPE, QUERY_FILE);
        } else if (object instanceof CicsTransientDataQuery) {
            memento.putString(KEY_QUERY_TYPE, QUERY_TD);
        } else if (object instanceof CicsTemporaryStorageQuery) {
            memento.putString(KEY_QUERY_TYPE, QUERY_TS);
        }
        memento.putString(KEY_QUERY, object.getQuery());
    }

    public ArrayList<CicsResourceQuery<?>> loadFrom() {
        IDialogSettings[] cicsqSections;
        ArrayList query = new ArrayList();
        IDialogSettings cicsSection = this.getExistingQuerySection();
        if (cicsSection != null && (cicsqSections = PDTCCui.getSections((IDialogSettings)cicsSection)) != null) {
            IDialogSettings[] iDialogSettingsArray = cicsqSections;
            int n = cicsqSections.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogSettings aQuery = iDialogSettingsArray[n2];
                String applName = aQuery.get(KEY_APPL);
                if (applName != null) {
                    CicsAppl appl = CicsAppl.create((IPDHost)this.host, (String)applName);
                    CicsFileQuery aCicsQuery = null;
                    String queryString = aQuery.get(KEY_QUERY);
                    String queryType = aQuery.get(KEY_QUERY_TYPE);
                    if (QUERY_FILE.equals(queryType)) {
                        aCicsQuery = CicsFileQuery.create((CicsAppl)appl, (String)queryString);
                    } else if (QUERY_TD.equals(queryType)) {
                        aCicsQuery = CicsTransientDataQuery.create((CicsAppl)appl, (String)queryString);
                    } else if (QUERY_TS.equals(queryType)) {
                        aCicsQuery = CicsTemporaryStorageQuery.create((CicsAppl)appl, (String)queryString);
                    } else {
                        logger.debug((Object)("Not loading cics resource query because of unidentified query type: " + queryType));
                    }
                    query.add((CicsResourceQuery<?>)aCicsQuery);
                }
                ++n2;
            }
        }
        return query;
    }

    @Deprecated
    public CicsResourceQuery<?> loadFrom(IMemento memento) {
        String applName = memento.getString(KEY_APPL);
        CicsAppl appl = CicsAppl.create((IPDHost)this.host, (String)applName);
        CicsFileQuery query = null;
        String queryString = memento.getString(KEY_QUERY);
        String queryType = memento.getString(KEY_QUERY_TYPE);
        if (QUERY_FILE.equals(queryType)) {
            if (!CicsFileQuery.isValidQuery((CicsAppl)appl, (String)queryString)) {
                logger.debug((Object)("Not loading cics file query because query string is invalid: " + queryString));
                return null;
            }
            query = CicsFileQuery.create((CicsAppl)appl, (String)queryString);
        } else if (QUERY_TD.equals(queryType)) {
            if (!CicsTransientDataQuery.isValidQuery((IPDHost)appl.getSystem(), (String)queryString)) {
                logger.debug((Object)("Not loading cics td query because query string is invalid: " + queryString));
                return null;
            }
            query = CicsTransientDataQuery.create((CicsAppl)appl, (String)queryString);
        } else if (QUERY_TS.equals(queryType)) {
            if (!CicsTemporaryStorageQuery.isValidQuery((String)queryString)) {
                logger.debug((Object)("Not loading cics ts query because query string is invalid: " + queryString));
                return null;
            }
            query = CicsTemporaryStorageQuery.create((CicsAppl)appl, (String)queryString);
        } else {
            logger.debug((Object)("Not loading cics resource query because of unidentified query type: " + queryType));
        }
        return query;
    }

    public String getTypeName() {
        return TYPE_QUERY;
    }
}

