/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.memento;

import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.ui.views.systems.model.ImsTreeContent;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.PDTCCui;
import com.ibm.pdtools.common.component.ui.memento.IMementoSaver;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IMemento;

public abstract class AbstractImsQuerySaver<T extends ImsQuery>
implements IMementoSaver<T> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(AbstractImsQuerySaver.class);
    private static final String KEY_QUERY = "query";
    private static final String KEY_REGION = "region";
    private static final String KEY_ACCESS = "access";
    protected ImsSubsystem subsystem;

    protected abstract T createQuery(ImsSubsystem var1, String var2, ImsRegionType var3, ImsAccessMode var4);

    public abstract String getTypeName();

    public abstract void saveTo(ImsTreeContent var1, IDialogSettings var2);

    public AbstractImsQuerySaver(ImsSubsystem subsystem) {
        this.subsystem = Objects.requireNonNull(subsystem, "Must provide non-null subsystem.");
    }

    public IDialogSettings getImscSection() {
        IDialogSettings imsSection = PDTCCui.getSection((IDialogSettings)PDTCCui.getSavingQueriesRoot4Host((IPDHost)this.subsystem.getSystem()), (String)"imsSubsystemConfig");
        if (imsSection != null) {
            return PDTCCui.getSection((IDialogSettings)imsSection, (String)this.subsystem.getSubsystemID());
        }
        return null;
    }

    public IDialogSettings getExistingImscSection() {
        IDialogSettings imsSection = PDTCCui.getExistingSection((IDialogSettings)PDTCCui.getSavingQueriesRoot4Host((IPDHost)this.subsystem.getSystem()), (String)"imsSubsystemConfig");
        if (imsSection != null) {
            return PDTCCui.getExistingSection((IDialogSettings)imsSection, (String)this.subsystem.getSubsystemID());
        }
        return null;
    }

    public ArrayList<T> loadFrom() {
        IDialogSettings[] querySections;
        IDialogSettings imsqtSection;
        ArrayList<T> query = new ArrayList<T>();
        IDialogSettings imscSection = this.getExistingImscSection();
        if (imscSection != null && (imsqtSection = PDTCCui.getExistingSection((IDialogSettings)imscSection, (String)this.getTypeName())) != null && (querySections = PDTCCui.getSections((IDialogSettings)imsqtSection)) != null) {
            IDialogSettings[] iDialogSettingsArray = querySections;
            int n = querySections.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogSettings aQuery = iDialogSettingsArray[n2];
                query.add(this.createQuery(this.subsystem, aQuery.get(KEY_QUERY), AbstractImsQuerySaver.getRegionType(aQuery.get(KEY_REGION)), AbstractImsQuerySaver.getAccessMode(aQuery.get(KEY_ACCESS))));
                ++n2;
            }
        }
        return query;
    }

    private static ImsRegionType getRegionType(String regionString) {
        try {
            regionString = regionString == null ? regionString : regionString.trim().toUpperCase();
            return ImsRegionType.valueOf((String)regionString);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            logger.trace(new Object[]{e.getCause(), e.getMessage()});
            return ImsRegionType.BMP;
        }
    }

    private static ImsAccessMode getAccessMode(String accessString) {
        try {
            return ImsAccessMode.valueOf((String)(accessString == null ? accessString : accessString.trim().toUpperCase()));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            logger.trace(new Object[]{e.getCause(), e.getMessage()});
            return ImsAccessMode.STATIC;
        }
    }

    @Deprecated
    public T loadFrom(IMemento memento) {
        Objects.requireNonNull(memento, "Must specify non-null memento.");
        return this.createQuery(this.subsystem, memento.getString(KEY_QUERY), AbstractImsQuerySaver.getRegionType(memento), AbstractImsQuerySaver.getAccessMode(memento));
    }

    private static ImsRegionType getRegionType(IMemento memento) {
        Objects.requireNonNull(memento, "Must specify non-null memento.");
        try {
            String regionString = memento.getString(KEY_REGION);
            regionString = regionString == null ? regionString : regionString.trim().toUpperCase();
            return ImsRegionType.valueOf((String)regionString);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            logger.trace(new Object[]{e.getCause(), e.getMessage()});
            return ImsRegionType.BMP;
        }
    }

    private static ImsAccessMode getAccessMode(IMemento memento) {
        Objects.requireNonNull(memento, "Must specify non-null memento.");
        try {
            String accessString = memento.getString(KEY_ACCESS);
            return ImsAccessMode.valueOf((String)(accessString == null ? accessString : accessString.trim().toUpperCase()));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            logger.trace(new Object[]{e.getCause(), e.getMessage()});
            return ImsAccessMode.STATIC;
        }
    }

    protected void addAQuerySection(IDialogSettings imsqtSection, T query) {
        String pattern = query.getPattern();
        String regionType = query.getRegionType().name();
        String accessMode = query.getAccessMode().name();
        IDialogSettings imsqSection = PDTCCui.addSection((IDialogSettings)imsqtSection, (String)(pattern + regionType + accessMode));
        imsqSection.put(KEY_QUERY, pattern);
        imsqSection.put(KEY_REGION, regionType);
        imsqSection.put(KEY_ACCESS, accessMode);
    }

    @Deprecated
    public void saveTo(IMemento memento, T query) {
        Objects.requireNonNull(memento, "Must specify non-null memento.");
        Objects.requireNonNull(query, "Must specify non-null query.");
        memento.putString(KEY_QUERY, query.getPattern());
        memento.putString(KEY_REGION, query.getRegionType().name());
        memento.putString(KEY_ACCESS, query.getAccessMode().name());
    }
}

