/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.history.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenTemplate;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class OpenAsTemplateActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(OpenAsTemplateActionItem.class);
    private static final String KEY_TARGET = "target";
    private static OpenAsTemplateActionItemPropertySource propSource;
    private IZRL aTemplate = null;

    public OpenAsTemplateActionItem(IZRL member) {
        super(ActionType.EDIT_TEMPLATE, member.getSystem());
        this.aTemplate = member;
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.OpenAsTemplateActionItem_LABEL, this.aTemplate.getFormattedName());
    }

    @Override
    public void saveTo(IMemento memento) {
        memento.putString(KEY_TARGET, this.aTemplate.getFormattedName());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        IZRL aTemplate = ZRLs.parseZRL((IPDHost)system, (String)memento.getString(KEY_TARGET));
        return new OpenAsTemplateActionItem(aTemplate);
    }

    @Override
    public void execute() {
        if (this.isExecuting()) {
            logger.trace((Object)"Ignoring execute while execution is in progress");
            return;
        }
        this.beginExecution();
        try {
            OpenTemplate.openTemplateEditor(this.aTemplate, this);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.setErrorToolTipText(e.getMessage());
        }
        this.finishExecution(false);
    }

    @Override
    public void modify() {
        this.execute();
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public OpenAsTemplateActionItem clone() {
        OpenAsTemplateActionItem clone = new OpenAsTemplateActionItem(this.aTemplate.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OpenAsTemplateActionItem) {
            OpenAsTemplateActionItem other = (OpenAsTemplateActionItem)obj;
            return this.aTemplate.equals(other.aTemplate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.aTemplate.hashCode();
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new OpenAsTemplateActionItemPropertySource(this.aTemplate);
        }
        propSource.setModel(this.aTemplate);
        return propSource;
    }

    private static class OpenAsTemplateActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private IZRL aTemplate;
        private String templProp = "aTemplate";

        public OpenAsTemplateActionItemPropertySource(IZRL aTemplate) {
            this.aTemplate = aTemplate;
        }

        public void setModel(IZRL aTemplate) {
            this.aTemplate = aTemplate;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.templProp, Messages.OpenAsTemplateActionItem_TEMPLATE));
            return (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public Object getPropertyValue(Object arg) {
            String id;
            if (arg instanceof String && (id = (String)arg).equals(this.templProp)) {
                return this.aTemplate.getFormattedName();
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

