/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.history.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenTemplate;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class OpenAsTemplate2ActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(OpenAsTemplate2ActionItem.class);
    private static final String KEY_TARGET = "target";
    private static final String KEY_TABLE = "table";
    private static final String KEY_GEN_REP = "genRep";
    private static OpenAsTemplate2ActionItemPropertySource propSource;
    private Db2TemplateOptions db2TemplateOptions = null;

    public OpenAsTemplate2ActionItem(Db2TemplateOptions db2TemplateOptions) {
        super(ActionType.EDIT_TEMPLATE2, db2TemplateOptions.getSystem());
        this.db2TemplateOptions = db2TemplateOptions;
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.OpenAsTemplateActionItem_LABEL2, this.db2TemplateOptions.getTemplate().getFormattedName());
    }

    @Override
    public void saveTo(IMemento memento) {
        Objects.requireNonNull(memento, "Must specify a non-null memento");
        memento.putString(KEY_TARGET, this.db2TemplateOptions.getTemplate().getFormattedName());
        memento.putString(KEY_TABLE, this.db2TemplateOptions.getTable().getFormattedName());
        memento.putBoolean(KEY_GEN_REP, this.db2TemplateOptions.isGenRep());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento");
        Db2TemplateOptions db2TemplateOptions = new Db2TemplateOptions();
        db2TemplateOptions.setTemplate(ZRLs.parseZRL((IPDHost)system, (String)memento.getString(KEY_TARGET)));
        db2TemplateOptions.setTable(Db2Table.parseTable((IPDHost)system, (String)memento.getString(KEY_TABLE)));
        db2TemplateOptions.setGenRep(memento.getBoolean(KEY_GEN_REP).booleanValue());
        return new OpenAsTemplate2ActionItem(db2TemplateOptions);
    }

    @Override
    public void execute() {
        if (this.isExecuting()) {
            logger.trace((Object)"Ignoring execute while execution is in progress");
            return;
        }
        this.beginExecution();
        try {
            OpenTemplate.openTemplateEditor2(this.db2TemplateOptions, this, true);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.setErrorToolTipText(e.getMessage());
        }
        this.finishExecution(false);
    }

    @Override
    public void modify() {
        this.beginExecution();
        OpenTemplate.openTemplateEditor2(this.db2TemplateOptions, this, false);
        this.finishExecution(false);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public OpenAsTemplate2ActionItem clone() {
        OpenAsTemplate2ActionItem clone = new OpenAsTemplate2ActionItem(this.db2TemplateOptions.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OpenAsTemplate2ActionItem) {
            OpenAsTemplate2ActionItem other = (OpenAsTemplate2ActionItem)obj;
            return this.db2TemplateOptions.equals((Object)other.db2TemplateOptions);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.db2TemplateOptions.hashCode();
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new OpenAsTemplate2ActionItemPropertySource(this.db2TemplateOptions);
        }
        propSource.setModel(this.db2TemplateOptions);
        return propSource;
    }

    private static class OpenAsTemplate2ActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private Db2TemplateOptions db2TemplateOptions;
        public String key_resource = "resource";
        public String key_template = "template";
        public String key_genReplace = "genReplace";

        public OpenAsTemplate2ActionItemPropertySource(Db2TemplateOptions db2TemplateOptions) {
            this.db2TemplateOptions = db2TemplateOptions;
        }

        public void setModel(Db2TemplateOptions db2TemplateOptions) {
            this.db2TemplateOptions = db2TemplateOptions;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.key_resource, Messages.OpenAsTemplate_DB2_ACTION_RESOURCE_NAME));
            temp.add(new PropertyDescriptor((Object)this.key_template, Messages.OpenAsTemplate_DB2_ACTION_TEMPLATE_NAME));
            temp.add(new PropertyDescriptor((Object)this.key_genReplace, Messages.Db2TemplateEditorDialog2_15));
            return (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public Object getPropertyValue(Object arg) {
            if (arg instanceof String) {
                String id = (String)arg;
                if (id.equals(this.key_resource)) {
                    return this.db2TemplateOptions.getTable().getFormattedName();
                }
                if (id.equals(this.key_template)) {
                    return this.db2TemplateOptions.getTemplate().getFormattedName();
                }
                if (id.equals(this.key_genReplace)) {
                    return this.db2TemplateOptions.isGenRep();
                }
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

