/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.history.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.core.model.ims.ImsTemplateOptions;
import com.ibm.etools.fm.core.model.ims.ImsTemplateType;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenTemplate;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class OpenAsTemplate1ActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(OpenAsTemplate1ActionItem.class);
    private static final String KEY_TARGET = "target";
    private static final String KEY_SSID = "ssid";
    private static final String KEY_DATABASE = "database";
    private static final String KEY_REGION_TYPE = "regionType";
    private static final String KEY_CREATE_NEW = "createNew";
    private static final String KEY_TYPE = "templateType";
    private static OpenAsTemplate1ActionItemPropertySource propSource;
    private ImsTemplateOptions imsTemplateOptions = null;

    public OpenAsTemplate1ActionItem(ImsTemplateOptions imsTemplateOptions) {
        super(ImsTemplateType.TEMPLATE == imsTemplateOptions.getType() ? ActionType.EDIT_TEMPLATE1 : ActionType.EDIT_TEMPLATE1VIEW, imsTemplateOptions.getSystem());
        this.imsTemplateOptions = imsTemplateOptions;
    }

    @Override
    public String getDefaultLabel() {
        if (this.imsTemplateOptions.getType() == ImsTemplateType.TEMPLATE) {
            return MessageFormat.format(Messages.OpenAsTemplate1ActionItem_0, this.imsTemplateOptions.getTemplate().getFormattedName());
        }
        return MessageFormat.format(Messages.OpenAsTemplate1ActionItem_8, this.imsTemplateOptions.getTemplate().getFormattedName());
    }

    @Override
    public void saveTo(IMemento memento) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        memento.putString(KEY_TARGET, this.imsTemplateOptions.getTemplate().getFormattedName());
        memento.putString(KEY_SSID, this.imsTemplateOptions.getDatabase().getSubsystem().getSubsystemID());
        memento.putString(KEY_DATABASE, this.imsTemplateOptions.getDatabase().getName());
        memento.putString(KEY_REGION_TYPE, this.imsTemplateOptions.getRegionType().name());
        memento.putBoolean(KEY_CREATE_NEW, this.imsTemplateOptions.isCreateNew());
        memento.putString(KEY_TYPE, this.imsTemplateOptions.getType().toString());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        String typeStr;
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        String templateDSN = memento.getString(KEY_TARGET);
        String ssid = memento.getString(KEY_SSID);
        String databaseName = memento.getString(KEY_DATABASE);
        String regionTypeStr = memento.getString(KEY_REGION_TYPE);
        ImsSubsystem aSubsystem = new ImsSubsystem(system, ssid);
        ImsRegionType regionType = ImsRegionType.valueOf((String)regionTypeStr);
        Boolean createNew = memento.getBoolean(KEY_CREATE_NEW);
        if (createNew == null) {
            createNew = false;
        }
        if ((typeStr = memento.getString(KEY_TYPE)) == null) {
            typeStr = ImsTemplateType.TEMPLATE.toString();
        }
        ImsTemplateType type = ImsTemplateType.valueOf((String)typeStr);
        ImsTemplateOptions imsTemplateOptions = new ImsTemplateOptions((ImsSubsystemProvider)aSubsystem, (DataSetOrMember)ZRLs.parseZRL((IPDHost)system, (String)templateDSN));
        imsTemplateOptions.setHost(system);
        imsTemplateOptions.setImsSubsystem(aSubsystem);
        imsTemplateOptions.setDatabase(new ImsDatabase(aSubsystem, databaseName));
        imsTemplateOptions.setTemplate(ZRLs.parseZRL((IPDHost)system, (String)templateDSN));
        imsTemplateOptions.setRegionType(regionType);
        imsTemplateOptions.setCreateNew(createNew.booleanValue());
        imsTemplateOptions.setType(type);
        return new OpenAsTemplate1ActionItem(imsTemplateOptions);
    }

    @Override
    public void execute() {
        if (this.isExecuting()) {
            logger.trace((Object)"Ignoring execute while execution is in progress");
            return;
        }
        this.beginExecution();
        try {
            OpenTemplate.openTemplateEditor1(this.imsTemplateOptions, this, true);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.setErrorToolTipText(e.getMessage());
        }
        this.finishExecution(false);
    }

    @Override
    public void modify() {
        this.beginExecution();
        OpenTemplate.openTemplateEditor1(this.imsTemplateOptions, this, false);
        this.finishExecution(false);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public OpenAsTemplate1ActionItem clone() {
        OpenAsTemplate1ActionItem clone = new OpenAsTemplate1ActionItem(new ImsTemplateOptions(this.imsTemplateOptions));
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OpenAsTemplate1ActionItem) {
            OpenAsTemplate1ActionItem other = (OpenAsTemplate1ActionItem)obj;
            return this.imsTemplateOptions.equals((Object)other.imsTemplateOptions);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.imsTemplateOptions.hashCode();
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new OpenAsTemplate1ActionItemPropertySource(this.imsTemplateOptions);
        }
        propSource.setModel(this.imsTemplateOptions);
        return propSource;
    }

    private static class OpenAsTemplate1ActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private ImsTemplateOptions imsTemplateOptions;
        public String key_resource = "resource";
        public String key_template = "template";
        public String key_region_type = "regionType";
        public String key_ssid = "ssid";
        public String key_create_new = "createNew";
        public String key_type = "imsTmpViewType";

        public OpenAsTemplate1ActionItemPropertySource(ImsTemplateOptions imsTemplateOptions) {
            this.imsTemplateOptions = imsTemplateOptions;
        }

        public void setModel(ImsTemplateOptions imsTemplateOptions) {
            this.imsTemplateOptions = imsTemplateOptions;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.key_resource, Messages.OpenAsTemplate1ActionItem_1));
            temp.add(new PropertyDescriptor((Object)this.key_template, Messages.OpenAsTemplate1ActionItem_2));
            temp.add(new PropertyDescriptor((Object)this.key_region_type, Messages.OpenAsTemplate1ActionItem_3));
            temp.add(new PropertyDescriptor((Object)this.key_ssid, Messages.OpenAsTemplate1ActionItem_4));
            temp.add(new PropertyDescriptor((Object)this.key_create_new, Messages.OpenAsTemplate1ActionItem_5));
            temp.add(new PropertyDescriptor((Object)this.key_type, Messages.OpenAsTemplate1ActionItem_9));
            return (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public Object getPropertyValue(Object arg) {
            if (arg instanceof String) {
                String id = (String)arg;
                if (id.equals(this.key_resource)) {
                    return this.imsTemplateOptions.getDatabase().getName();
                }
                if (id.equals(this.key_template)) {
                    return this.imsTemplateOptions.getTemplate().getFormattedName();
                }
                if (id.equals(this.key_region_type)) {
                    return this.imsTemplateOptions.getRegionType().name();
                }
                if (id.equals(this.key_ssid)) {
                    return this.imsTemplateOptions.getSubsystem().getSubsystemID();
                }
                if (id.equals(this.key_create_new)) {
                    return this.imsTemplateOptions.isCreateNew();
                }
                if (id.equals(this.key_type)) {
                    return this.imsTemplateOptions.getType().name();
                }
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

