/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.history.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.editor.formatted.BaseEditorOptionsPropertySource;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.editor.formatted.OpenFormattedEditorJob;
import com.ibm.etools.fm.editor.formatted.dialogs.EditorOptionDialog;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenFormatted;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class OpenAsFormattedEditorActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String KEY_RESOURCE = "resource";
    private static final String KEY_TEMPLATE = "template";
    private static final String KEY_EDIT_SESSION = "editSession";
    private static final String KEY_ENCODING = "encoding";
    private static final String KEY_DBCS_ENCODING = "DBCSEncoding";
    private static final String KEY_BIDI_FORMAT = "BiDiFormat";
    private static final String KEY_VOLSER = "volser";
    private static final String KEY_TEMPLATE_PROCESSING_TYPE = "templateProcType";
    private static final String KEY_START_POS_TYPE = "startPosType";
    private static final String KEY_START_POS_VALUE = "startPosValue";
    private static final String KEY_BIN_REC_LEN = "binRecLen";
    private static final String KEY_RECORD_SAMPLE = "recordSample";
    private static final String KEY_INPLACE_EDIT = "inplaceEdit";
    private static final String KEY_ONLY_SELECTED = "onlySelected";
    private static final String KEY_INCLUDE_PHYSICAL_RECORD = "includePhysRec";
    private static final String KEY_SKIP_PHYSICAL_RECORD = "skipPhysRec";
    private static final String KEY_RECORD_LIMIT = "recordLimit";
    private static final String KEY_IO_EXIT = "ioExit";
    private static final String KEY_MQ_DESCRIPTOR = "mqDescriptor";
    private static final String KEY_IS_KSDS = "isKsds";
    private static final String KEY_KEY_LEN = "keyLen";
    private static final String KEY_KEY_OFFSET = "keyOffset";
    private static final String KEY_ALL_RECORDS_LOADED = "allRecordsLoaded";
    private static final String KEY_MAX_RECL = "maxRecl";
    private static final String KEY_MIN_RECL = "minRecl";
    private static final String KEY_NUM_RECORDS = "numRecords";
    private static final String KEY_NO_APPEND = "noAppend";
    private static final String KEY_FIXED_LEN = "fixedLen";
    private static final String KEY_NO_MOVE = "noMove";
    private static final String KEY_NO_REC_LEN_CHANGE = "noRecLenChange";
    private static final String KEY_NO_UPDATE = "noUpdate";
    private static final String KEY_NO_INSERT_DELETE = "noInsertDelete";
    private static final String KEY_IS_QSAM = "isQsam";
    private static final String KEY_IS_RRDS = "isRRDS";
    private static final String KEY_IS_PSEUDO_DEL_ENABLED = "pseudoDelEnabled";
    private static final String KEY_IS_REFRESH_AVAILABLE = "refreshAvailable";
    private static final String KEY_CURRENT_START_POS = "currStartPos";
    private static BaseEditorOptionsPropertySource propSource;
    private BaseEditorOptions model = new BaseEditorOptions();
    private FMEditSessionProperties props = new FMEditSessionProperties();

    public static void refreshIconDecorations() {
        PDSystemsView.tryRefresh();
    }

    private OpenAsFormattedEditorActionItem(IPDHost hostProvider) {
        super(ActionType.VIEW_EDIT_RESOURCE, hostProvider);
    }

    public OpenAsFormattedEditorActionItem(BaseEditorOptions options) {
        super(ActionType.VIEW_EDIT_RESOURCE, options.getaResource().getSystem());
        this.model = options.clone();
    }

    public void setEditSessionProperties(FMEditSessionProperties editSessionProperties) {
        this.props = editSessionProperties.clone();
    }

    public FMEditSessionProperties getEditSessionProperties() {
        return this.props;
    }

    @Override
    public String getDefaultLabel() {
        if (this.model.isEditSession()) {
            if (this.model.getaTemplate() != null && this.model.getaTemplate().getFormattedName().length() > 0) {
                return MessageFormat.format(Messages.OpenAsFormattedEditorActionItem_EDIT_WITH_TEMPLATE, this.model.getaResource().getFormattedName(), this.model.getaTemplate().getSystem().getConnectionName() + ":" + this.model.getaTemplate().getFormattedName());
            }
            return MessageFormat.format(Messages.OpenAsFormattedEditorActionItem_EDIT, this.model.getaResource().getFormattedName());
        }
        if (this.model.getaTemplate() != null && this.model.getaTemplate().getFormattedName().length() > 0) {
            return MessageFormat.format(Messages.OpenAsFormattedEditorActionItem_VIEW_WITH_TEMPLATE, this.model.getaResource().getFormattedName(), this.model.getaTemplate().getSystem().getConnectionName() + ":" + this.model.getaTemplate().getFormattedName());
        }
        return MessageFormat.format(Messages.OpenAsFormattedEditorActionItem_VIEW, this.model.getaResource().getFormattedName());
    }

    @Override
    public boolean isExecuting() {
        return super.isExecuting() || FMUIPlugin.getDefault().dsEditSessionExist(this.model.getaResource());
    }

    @Override
    public void saveTo(IMemento memento) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        memento.putString(KEY_RESOURCE, this.model.getaResource().getFormattedName());
        if (this.model.getaTemplate() == null) {
            IActionItemSaver.saveDestinationSystem(memento, this.model.getTemplateSystem());
        } else {
            IActionItemSaver.saveDestinationSystem(memento, this.model.getaTemplate().getSystem());
        }
        memento.putString(KEY_TEMPLATE, this.model.getaTemplate() == null ? "" : this.model.getaTemplate().getFormattedName());
        memento.putBoolean(KEY_EDIT_SESSION, this.model.isEditSession());
        memento.putString(KEY_ENCODING, this.model.getEncodingForSession());
        memento.putString(KEY_DBCS_ENCODING, this.model.getDbcsEncodingForSession());
        memento.putString(KEY_BIDI_FORMAT, this.model.getBidiFormat());
        memento.putString(KEY_VOLSER, this.model.getaVolumeSerial());
        memento.putString(KEY_TEMPLATE_PROCESSING_TYPE, this.model.getTemplateProcessingType().name());
        memento.putString(KEY_START_POS_TYPE, this.model.getStartType().name());
        memento.putString(KEY_START_POS_VALUE, this.model.getaStartPosition());
        memento.putString(KEY_BIN_REC_LEN, this.model.getBinaryLength());
        memento.putBoolean(KEY_RECORD_SAMPLE, this.model.isRecordSampling());
        memento.putBoolean(KEY_INPLACE_EDIT, this.model.isInplaceEdit());
        memento.putBoolean(KEY_ONLY_SELECTED, this.model.isOnlySelectedRecs());
        memento.putString(KEY_INCLUDE_PHYSICAL_RECORD, this.model.getIncludePhysicalRecords());
        memento.putString(KEY_SKIP_PHYSICAL_RECORD, this.model.getSkipPhysicalRecords());
        memento.putString(KEY_RECORD_LIMIT, this.model.getRecordLimit());
        memento.putString(KEY_IO_EXIT, this.model.getIoExitName());
        memento.putBoolean(KEY_MQ_DESCRIPTOR, this.model.isMQDescriptorSelected());
        memento.putBoolean(KEY_IS_KSDS, this.props.isKSDS());
        memento.putInteger(KEY_KEY_LEN, this.props.getKeyLen());
        memento.putInteger(KEY_KEY_OFFSET, this.props.getKeyOffset());
        memento.putBoolean(KEY_ALL_RECORDS_LOADED, this.props.isAllRecdsLoaded());
        memento.putInteger(KEY_MAX_RECL, this.props.getMaxRECL());
        memento.putInteger(KEY_MIN_RECL, this.props.getMinRECL());
        memento.putInteger(KEY_NUM_RECORDS, this.props.getNumRecords());
        memento.putBoolean(KEY_NO_APPEND, this.props.isNoAppend());
        memento.putBoolean(KEY_FIXED_LEN, this.props.isFixedLen());
        memento.putBoolean(KEY_NO_MOVE, this.props.noMove());
        memento.putBoolean(KEY_NO_REC_LEN_CHANGE, this.props.noRecLenChange());
        memento.putBoolean(KEY_NO_UPDATE, this.props.noUpdate());
        memento.putBoolean(KEY_NO_INSERT_DELETE, this.props.noInsertDelete());
        memento.putBoolean(KEY_IS_QSAM, this.props.isQSAM());
        memento.putBoolean(KEY_IS_RRDS, this.props.isRRDS());
        memento.putBoolean(KEY_IS_PSEUDO_DEL_ENABLED, this.props.isPseudoDelEnabled());
        memento.putBoolean(KEY_IS_REFRESH_AVAILABLE, this.props.isRefreshCommandAvailable());
        memento.putInteger(KEY_CURRENT_START_POS, this.props.getCurrentStartPosition());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        OpenAsFormattedEditorActionItem ai = new OpenAsFormattedEditorActionItem(system);
        ai.model.setaResource(ZRLs.parseZRL((IPDHost)system, (String)memento.getString(KEY_RESOURCE)));
        IPDHost templateSystem = IActionItemSaver.loadDestinationSystem(memento);
        String template = memento.getString(KEY_TEMPLATE);
        ai.model.setTemplateSystem(templateSystem);
        ai.model.setaTemplate(template.isEmpty() ? null : ZRLs.parseZRL((IPDHost)templateSystem, (String)template));
        ai.model.setEditSession(memento.getBoolean(KEY_EDIT_SESSION).booleanValue());
        ai.model.setEncodingForSession(memento.getString(KEY_ENCODING));
        ai.model.setDbcsEncodingForSession(memento.getString(KEY_DBCS_ENCODING));
        ai.model.setBidiFormat(memento.getString(KEY_BIDI_FORMAT));
        ai.model.setaVolumeSerial(memento.getString(KEY_VOLSER));
        ai.model.setStartType(BaseEditorOptions.BaseStartPosType.valueOf((String)memento.getString(KEY_START_POS_TYPE)));
        ai.model.setaStartPosition(memento.getString(KEY_START_POS_VALUE));
        ai.model.setBinaryLength(memento.getString(KEY_BIN_REC_LEN));
        ai.model.setRecordSampling(memento.getBoolean(KEY_RECORD_SAMPLE).booleanValue());
        ai.model.setInplaceEdit(memento.getBoolean(KEY_INPLACE_EDIT).booleanValue());
        ai.model.setOnlySelectedRecs(memento.getBoolean(KEY_ONLY_SELECTED).booleanValue());
        ai.model.setIncludePhysicalRecords(memento.getString(KEY_INCLUDE_PHYSICAL_RECORD));
        ai.model.setSkipPhysicalRecords(memento.getString(KEY_SKIP_PHYSICAL_RECORD));
        ai.model.setRecordLimit(memento.getString(KEY_RECORD_LIMIT));
        ai.model.setIoExitName(memento.getString(KEY_IO_EXIT));
        ai.model.setMQDescriptor(memento.getBoolean(KEY_MQ_DESCRIPTOR).booleanValue());
        ai.props = new FMEditSessionProperties();
        ai.props.setKSDS(memento.getBoolean(KEY_IS_KSDS).booleanValue());
        ai.props.setKeyLen(memento.getInteger(KEY_KEY_LEN).intValue());
        ai.props.setKeyOffset(memento.getInteger(KEY_KEY_OFFSET).intValue());
        ai.props.setAllRecdsLoaded(memento.getBoolean(KEY_ALL_RECORDS_LOADED).booleanValue());
        ai.props.setMaxRECL(memento.getInteger(KEY_MAX_RECL).intValue());
        ai.props.setMinRECL(memento.getInteger(KEY_MIN_RECL).intValue());
        ai.props.setNumRecords(memento.getInteger(KEY_NUM_RECORDS).intValue());
        ai.props.setNoAppend(memento.getBoolean(KEY_NO_APPEND).booleanValue());
        ai.props.setFixedLen(memento.getBoolean(KEY_FIXED_LEN).booleanValue());
        ai.props.setNoMove(memento.getBoolean(KEY_NO_MOVE).booleanValue());
        ai.props.setNoRecLenChange(memento.getBoolean(KEY_NO_REC_LEN_CHANGE).booleanValue());
        ai.props.setNoUpdate(memento.getBoolean(KEY_NO_UPDATE).booleanValue());
        ai.props.setNoInsertDelete(memento.getBoolean(KEY_NO_INSERT_DELETE).booleanValue());
        ai.props.setQSAM(memento.getBoolean(KEY_IS_QSAM).booleanValue());
        ai.props.setRRDS(memento.getBoolean(KEY_IS_RRDS).booleanValue());
        ai.props.setPseudoDelEnabled(memento.getBoolean(KEY_IS_PSEUDO_DEL_ENABLED).booleanValue());
        ai.props.setRefreshCommandAvailable(memento.getBoolean(KEY_IS_REFRESH_AVAILABLE).booleanValue());
        ai.props.setCurrentStartPosition(memento.getInteger(KEY_CURRENT_START_POS).intValue());
        return ai;
    }

    @Override
    public void execute() {
        if (this.isExecuting()) {
            logger.trace((Object)"Ignoring execute while execution is in progress");
            return;
        }
        this.beginExecution();
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.OpenAsFormatted_START, OpenAsFormattedEditorActionItem.this.model.getaResource().getFormattedName(), OpenAsFormattedEditorActionItem.this.model.getaTemplate() != null ? OpenAsFormattedEditorActionItem.this.model.getaTemplate().getFormattedName() : Messages.NONE), 3);
                    OpenFormattedEditorJob job = new OpenFormattedEditorJob(OpenAsFormattedEditorActionItem.this.props, OpenAsFormattedEditorActionItem.this.model, null, OpenAsFormattedEditorActionItem.this);
                    job.schedule();
                    monitor.done();
                }
            });
            this.setErrorToolTipText(null);
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.OpenAsFormatted_OPEN_EDIT_EX, this.model.getaResource().getFormattedName(), this.model.getaTemplate() != null ? this.model.getaTemplate().getFormattedName() : Messages.NONE);
            PDDialogs.openErrorThreadSafe((String)errMsg, (Throwable)e);
            this.setErrorToolTipText(errMsg);
        }
    }

    @Override
    public void modify() {
        this.beginExecution();
        EditorOptionDialog dialog = new EditorOptionDialog(Display.getDefault().getActiveShell(), this.getSystem(), this.model.clone());
        if (dialog.open() != 0) {
            this.finishExecution(true);
            return;
        }
        this.model = dialog.getEditorOptions();
        OpenFormatted.invokeEditor(this.model, this);
        try {
            try {
                PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        try {
                            OpenAsFormattedEditorActionItem.this.props = OpenFormatted.prepareSessionProperties(OpenAsFormattedEditorActionItem.this.model, howIsGoing);
                        }
                        catch (CommunicationException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof InterruptedException) {
                    throw (InterruptedException)e.getCause();
                }
                logger.error((Throwable)e);
            }
        }
        catch (InterruptedException e) {
            logger.error((Throwable)e);
        }
        this.finishExecution(false);
    }

    @Override
    public OpenAsFormattedEditorActionItem clone() {
        OpenAsFormattedEditorActionItem clone = new OpenAsFormattedEditorActionItem(this.model.getaResource().getSystem());
        if (this.props != null) {
            clone.props = this.props.clone();
        }
        if (this.model != null) {
            clone.model = this.model.clone();
        }
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OpenAsFormattedEditorActionItem) {
            OpenAsFormattedEditorActionItem other = (OpenAsFormattedEditorActionItem)obj;
            return this.model.equals((Object)other.model);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.model.hashCode();
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new BaseEditorOptionsPropertySource(this.model);
        }
        propSource.setModel(this.model);
        return propSource;
    }

    public BaseEditorOptions getOptions() {
        return this.model;
    }
}

