/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.history.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DummyMember;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenFormatted;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class OpenAsFormattedEditor2ActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(OpenAsFormattedEditor2ActionItem.class);
    private static final String KEY_SUBSYSTEM = "subsystem";
    private static final String KEY_TABLE = "table";
    private static final String KEY_EDIT = "edit";
    private static final String KEY_START_POS = "startPos";
    private static final String KEY_ROW_COUNT = "rowCount";
    private static final String KEY_ENCODING = "encoding";
    private static final String KEY_DBCS_ENCODING = "dbcsEncoding";
    private static final String KEY_BIDI_FORMAT = "BiDiFormat";
    private static final String KEY_GEN_REP = "genRep";
    private static final String KEY_TEMPLATE = "template";
    private static OpenAsTemplate2ActionItemPropertySource propSource;
    private Db2EditOptions db2EditOptions = null;

    public OpenAsFormattedEditor2ActionItem(Db2EditOptions db2EditOptions) {
        super(ActionType.VIEW_EDIT_DB2_OBJECT, db2EditOptions.getTable().getSystem());
        this.db2EditOptions = db2EditOptions;
    }

    @Override
    public String getDefaultLabel() {
        if (this.db2EditOptions.isEdit()) {
            return MessageFormat.format(Messages.OpenAsFormattedEditorActionItem_EDIT2, this.db2EditOptions.getTable().getFormattedName(), this.db2EditOptions.getTemplate().getFormattedName());
        }
        return MessageFormat.format(Messages.OpenAsFormattedEditorActionItem_VIEW2, this.db2EditOptions.getTable().getFormattedName(), this.db2EditOptions.getTemplate().getFormattedName());
    }

    @Override
    public void saveTo(IMemento memento) {
        memento.putString(KEY_SUBSYSTEM, this.db2EditOptions.getSubsystem().getFormattedName());
        memento.putString(KEY_TABLE, this.db2EditOptions.getTable().getFormattedName());
        memento.putBoolean(KEY_EDIT, this.db2EditOptions.isEdit());
        memento.putString(KEY_START_POS, this.db2EditOptions.getStartPosition());
        memento.putString(KEY_ROW_COUNT, this.db2EditOptions.getRowCount());
        memento.putString(KEY_ENCODING, this.db2EditOptions.getEncoding());
        memento.putString(KEY_DBCS_ENCODING, this.db2EditOptions.getDbcsEncoding());
        memento.putString(KEY_BIDI_FORMAT, this.db2EditOptions.getBidiFormat());
        memento.putBoolean(KEY_GEN_REP, this.db2EditOptions.isGenRep());
        IZRL template = this.db2EditOptions.getTemplate();
        memento.putString(KEY_TEMPLATE, template instanceof DummyMember ? "" : template.getFormattedName());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        Objects.requireNonNull(system, "Must specify a non-null system.");
        Db2EditOptions db2EditOptions = new Db2EditOptions();
        db2EditOptions.setHost(system);
        db2EditOptions.setSubsystem(Db2Subsystem.parseSubsystem((IPDHost)system, (String)memento.getString(KEY_SUBSYSTEM)));
        db2EditOptions.setTable(Db2Table.parseTable((IPDHost)system, (String)memento.getString(KEY_TABLE)));
        db2EditOptions.setEdit(memento.getBoolean(KEY_EDIT).booleanValue());
        db2EditOptions.setStartPosition(memento.getString(KEY_START_POS));
        db2EditOptions.setRowCount(memento.getString(KEY_ROW_COUNT));
        db2EditOptions.setEncoding(memento.getString(KEY_ENCODING));
        db2EditOptions.setDbcsEncoding(memento.getString(KEY_DBCS_ENCODING));
        db2EditOptions.setBidiFormat(memento.getString(KEY_BIDI_FORMAT));
        db2EditOptions.setGenRep(memento.getBoolean(KEY_GEN_REP).booleanValue());
        String template = memento.getString(KEY_TEMPLATE);
        db2EditOptions.setTemplate((IZRL)(template.isEmpty() ? DummyMember.createDummyMember((IPDHost)system) : ZRLs.parseZRL((IPDHost)system, (String)template)));
        return new OpenAsFormattedEditor2ActionItem(db2EditOptions);
    }

    @Override
    public void execute() {
        if (this.isExecuting()) {
            logger.trace((Object)"Ignoring execute while execution is in progress");
            return;
        }
        this.beginExecution();
        try {
            OpenFormatted.invokeDb2Editor(this.db2EditOptions, this, true);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.setErrorToolTipText(e.getMessage());
        }
        this.finishExecution(false);
    }

    @Override
    public void modify() {
        this.beginExecution();
        OpenFormatted.invokeDb2Editor(this.db2EditOptions, this, false);
        this.finishExecution(false);
    }

    @Override
    public boolean isExecuting() {
        return super.isExecuting() || FMUIPlugin.getDefault().dsEditSessionExist((IZRL)this.db2EditOptions.getTable());
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public OpenAsFormattedEditor2ActionItem clone() {
        OpenAsFormattedEditor2ActionItem clone = new OpenAsFormattedEditor2ActionItem(this.db2EditOptions.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OpenAsFormattedEditor2ActionItem) {
            OpenAsFormattedEditor2ActionItem other = (OpenAsFormattedEditor2ActionItem)obj;
            return this.db2EditOptions.equals((Object)other.db2EditOptions);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.db2EditOptions.hashCode();
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new OpenAsTemplate2ActionItemPropertySource(this.db2EditOptions);
        }
        propSource.setModel(this.db2EditOptions);
        return propSource;
    }

    private static class OpenAsTemplate2ActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private Db2EditOptions db2EditOptions;
        public String key_resource = "resource";
        public String key_template = "template";
        public String key_subsystem = "subsystem";
        public String key_startPos = "startPos";
        public String key_rowCount = "rowCount";
        public String key_encoding = "encoding";
        public String key_dbcsEncoding = "dbcsEncoding";
        public String key_bidiFormat = "BiDiFormat";
        public String key_genRep = "genRep";

        public OpenAsTemplate2ActionItemPropertySource(Db2EditOptions db2EditOptions) {
            this.db2EditOptions = db2EditOptions;
        }

        public void setModel(Db2EditOptions db2EditOptions) {
            this.db2EditOptions = db2EditOptions;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.key_resource, Messages.OpenAsFormatted_DB2_ACTION_RESOURCE_NAME));
            temp.add(new PropertyDescriptor((Object)this.key_template, Messages.OpenAsFormatted_DB2_ACTION_TEMPLATE_NAME));
            temp.add(new PropertyDescriptor((Object)this.key_subsystem, Messages.Db2EditorDialog_12));
            temp.add(new PropertyDescriptor((Object)this.key_startPos, Messages.Db2EditorDialog_13));
            temp.add(new PropertyDescriptor((Object)this.key_rowCount, Messages.Db2EditorDialog_15));
            temp.add(new PropertyDescriptor((Object)this.key_encoding, Messages.Db2EditorDialog_17));
            temp.add(new PropertyDescriptor((Object)this.key_dbcsEncoding, Messages.OpenAsFormattedEditor2ActionItem_GraphicEncoding));
            temp.add(new PropertyDescriptor((Object)this.key_bidiFormat, Messages.BaseEditorOptionsPropertySource_BIDI_FORMAT));
            temp.add(new PropertyDescriptor((Object)this.key_genRep, Messages.Db2EditorDialog_21));
            return (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public Object getPropertyValue(Object arg) {
            if (arg instanceof String) {
                String id = (String)arg;
                if (id.equals(this.key_resource)) {
                    return this.db2EditOptions.getTable().getFormattedName();
                }
                if (id.equals(this.key_template)) {
                    return this.db2EditOptions.getTemplate().getFormattedName();
                }
                if (id.equals(this.key_subsystem)) {
                    return this.db2EditOptions.getSubsystem().getSubsystemID();
                }
                if (id.equals(this.key_startPos)) {
                    return this.db2EditOptions.getStartPosition();
                }
                if (id.equals(this.key_rowCount)) {
                    return this.db2EditOptions.getRowCount();
                }
                if (id.equals(this.key_encoding)) {
                    return this.db2EditOptions.getEncoding();
                }
                if (id.equals(this.key_dbcsEncoding)) {
                    return this.db2EditOptions.getDbcsEncoding();
                }
                if (id.equals(this.key_genRep)) {
                    return this.db2EditOptions.isGenRep();
                }
                if (id.equals(this.key_bidiFormat)) {
                    return this.db2EditOptions.getBidiFormat();
                }
                if (PDLoggerJhost.isTraceEnabled()) {
                    logger.warn((Object)("Unhandled key id: " + id));
                }
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

