/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.history.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DummyMember;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsEditorOptions;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsResource;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenFormatted;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDBidiTextDirection;
import com.ibm.pdtools.common.component.core.util.PDBidiTextLayout;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class OpenAsFormattedEditor1ActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(OpenAsFormattedEditor1ActionItem.class);
    private static final String KEY_SUBSYSTEM = "subsystem";
    private static final String KEY_IMS_RESOURCE = "imsResource";
    private static final String KEY_TEMPLATE = "template";
    private static final String KEY_USE_TEMPLATE = "useTemplate";
    private static final String KEY_REGION_TYPE = "regionType";
    private static final String KEY_EDIT_DLI_DATABASE_DS = "editDliDataSet";
    private static final String KEY_ACCESS_MODE = "accessMode";
    private static final String KEY_EDIT_SESSION = "edit";
    private static final String KEY_IMS_LOG = "imsLog";
    private static final String KEY_ENCODING = "encoding";
    private static final String KEY_DBCS_ENCODING = "dbcsEncoding";
    private static final String KEY_BIDI_DIRECTION = "BiDiDirection";
    private static final String KEY_BIDI_LAYOUT = "BiDiLayout";
    private static final String KEY_SECONDARY_INDEX_NAME = "secondaryIndexName";
    private static OpenAsTemplate1ActionItemPropertySource propSource;
    private ImsEditorOptions imsEditOptions = null;

    public OpenAsFormattedEditor1ActionItem(ImsEditorOptions imsEditOptions) {
        super(ActionType.VIEW_EDIT_IMS_OBJECT, imsEditOptions.getSystem());
        this.imsEditOptions = imsEditOptions;
    }

    @Override
    public String getDefaultLabel() {
        if (this.imsEditOptions.isEditSession()) {
            return MessageFormat.format(Messages.OpenAsFormattedEditor1ActionItem_2, this.imsEditOptions.getImsResource().getFormattedName(), this.imsEditOptions.getRegionType().name(), this.imsEditOptions.getAccessMode().name());
        }
        return MessageFormat.format(Messages.OpenAsFormattedEditor1ActionItem_3, this.imsEditOptions.getImsResource().getFormattedName(), this.imsEditOptions.getRegionType().name(), this.imsEditOptions.getAccessMode().name());
    }

    @Override
    public void saveTo(IMemento memento) {
        memento.putString(KEY_SUBSYSTEM, this.imsEditOptions.getSubsystem().getName());
        memento.putString(KEY_IMS_RESOURCE, this.imsEditOptions.getImsResource().getFormattedName());
        DataSetOrMember template = this.imsEditOptions.getTemplate();
        memento.putString(KEY_TEMPLATE, template instanceof DummyMember ? "" : template.getFormattedName());
        memento.putBoolean(KEY_USE_TEMPLATE, this.imsEditOptions.useTemplate());
        memento.putString(KEY_REGION_TYPE, this.imsEditOptions.getRegionType().name());
        memento.putBoolean(KEY_EDIT_DLI_DATABASE_DS, this.imsEditOptions.editDliDatabaseDataSets());
        memento.putString(KEY_ACCESS_MODE, this.imsEditOptions.getAccessMode().name());
        memento.putBoolean(KEY_EDIT_SESSION, this.imsEditOptions.isEditSession());
        memento.putString(KEY_IMS_LOG, this.imsEditOptions.getImsLog().name());
        memento.putString(KEY_ENCODING, this.imsEditOptions.getEncoding());
        memento.putString(KEY_DBCS_ENCODING, this.imsEditOptions.getDbcsEncoding());
        memento.putString(KEY_BIDI_DIRECTION, this.imsEditOptions.getBidiFormatType().getDirection().name());
        memento.putString(KEY_BIDI_LAYOUT, this.imsEditOptions.getBidiFormatType().getLayout().name());
        memento.putString(KEY_SECONDARY_INDEX_NAME, this.imsEditOptions.getDynamicPsbSecondaryIndexName());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        DataSetOrMember aTemplate;
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        ImsSubsystem subsystem = new ImsSubsystem(system, memento.getString(KEY_SUBSYSTEM));
        String template = memento.getString(KEY_TEMPLATE);
        Object object = aTemplate = template.isEmpty() ? DummyMember.createDummyMember((IPDHost)system) : ZRLs.parseZRL((IPDHost)system, (String)template);
        if (!(aTemplate instanceof DataSetOrMember)) {
            logger.error((Object)("Invalid IMS template name: " + aTemplate.getFormattedName()));
            return null;
        }
        String imsResourceName = memento.getString(KEY_IMS_RESOURCE);
        if (!ImsResource.isParseable((IPDHost)system, (String)imsResourceName)) {
            logger.error((Object)("Invalid IMS resource name: " + imsResourceName));
            return null;
        }
        IZRL imsResource = ImsResource.parseImsResource((IPDHost)system, (String)imsResourceName);
        ImsEditorOptions imsEditOptions = new ImsEditorOptions(system, subsystem, imsResource, aTemplate);
        imsEditOptions.setUseTemplate(memento.getBoolean(KEY_USE_TEMPLATE).booleanValue());
        imsEditOptions.setRegionType(ImsRegionType.valueOf((String)memento.getString(KEY_REGION_TYPE)));
        imsEditOptions.setEditDliDatabaseDatasets(memento.getBoolean(KEY_EDIT_DLI_DATABASE_DS).booleanValue());
        imsEditOptions.setAccessMode(ImsAccessMode.valueOf((String)memento.getString(KEY_ACCESS_MODE)));
        imsEditOptions.setEditSession(memento.getBoolean(KEY_EDIT_SESSION).booleanValue());
        imsEditOptions.setImsLog(ImsEditorOptions.ImsLog.valueOf((String)memento.getString(KEY_IMS_LOG)));
        imsEditOptions.setEncoding(memento.getString(KEY_ENCODING));
        imsEditOptions.setDbcsEncoding(memento.getString(KEY_DBCS_ENCODING));
        imsEditOptions.getBidiFormatType().setDirection(PDBidiTextDirection.parse((String)memento.getString(KEY_BIDI_DIRECTION)));
        imsEditOptions.getBidiFormatType().setLayout(PDBidiTextLayout.parse((String)memento.getString(KEY_BIDI_LAYOUT)));
        imsEditOptions.setDynamicPsbSecondaryIndexName(memento.getString(KEY_SECONDARY_INDEX_NAME));
        return new OpenAsFormattedEditor1ActionItem(imsEditOptions);
    }

    @Override
    public void execute() {
        if (this.isExecuting()) {
            logger.trace((Object)"Ignoring execute while execution is in progress");
            return;
        }
        this.beginExecution();
        try {
            OpenFormatted.invokeImsEditor(this.imsEditOptions, this, true);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.setErrorToolTipText(e.getMessage());
        }
        this.finishExecution(false);
    }

    @Override
    public void modify() {
        this.beginExecution();
        OpenFormatted.invokeImsEditor(this.imsEditOptions, this, false);
        this.finishExecution(false);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public OpenAsFormattedEditor1ActionItem clone() {
        OpenAsFormattedEditor1ActionItem clone = new OpenAsFormattedEditor1ActionItem(this.imsEditOptions.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OpenAsFormattedEditor1ActionItem) {
            OpenAsFormattedEditor1ActionItem other = (OpenAsFormattedEditor1ActionItem)obj;
            return this.imsEditOptions.equals((Object)other.imsEditOptions);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.imsEditOptions.hashCode();
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new OpenAsTemplate1ActionItemPropertySource(this.imsEditOptions);
        }
        propSource.setModel(this.imsEditOptions);
        return propSource;
    }

    private static class OpenAsTemplate1ActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private ImsEditorOptions imsEditOptions;
        public String key_subsystem = "subsystem";
        public String key_resource = "resource";
        public String key_template = "template";
        public String key_use_template = "useTemplate";
        public String key_regionType = "region";
        public String key_editDliDatabaseDS = "editDliDS";
        public String key_accessMode = "access";
        public String key_editSession = "edit";
        public String key_ims_log = "imsLog";
        public String key_encoding = "encoding";
        public String key_dbcsEncoding = "dbcsEncoding";
        public String key_bidi_Direction = "BiDi Text Direction";
        public String key_bidi_Layout = "BiDi Text Layout";
        public String key_secondayIndexName = "secondaryIndexName";

        public OpenAsTemplate1ActionItemPropertySource(ImsEditorOptions imsEditOptions) {
            this.imsEditOptions = imsEditOptions;
        }

        public void setModel(ImsEditorOptions imsEditOptions) {
            this.imsEditOptions = imsEditOptions;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.key_subsystem, Messages.OpenAsFormattedEditor1ActionItem_6));
            temp.add(new PropertyDescriptor((Object)this.key_resource, Messages.OpenAsFormattedEditor1ActionItem_7));
            temp.add(new PropertyDescriptor((Object)this.key_template, Messages.OpenAsFormattedEditor1ActionItem_8));
            temp.add(new PropertyDescriptor((Object)this.key_use_template, Messages.OpenAsFormattedEditor1ActionItem_9));
            temp.add(new PropertyDescriptor((Object)this.key_regionType, Messages.OpenAsFormattedEditor1ActionItem_10));
            temp.add(new PropertyDescriptor((Object)this.key_editDliDatabaseDS, Messages.OpenAsFormattedEditor1ActionItem_11));
            temp.add(new PropertyDescriptor((Object)this.key_accessMode, Messages.OpenAsFormattedEditor1ActionItem_12));
            temp.add(new PropertyDescriptor((Object)this.key_editSession, Messages.OpenAsFormattedEditor1ActionItem_13));
            temp.add(new PropertyDescriptor((Object)this.key_ims_log, Messages.OpenAsFormattedEditor1ActionItem_14));
            temp.add(new PropertyDescriptor((Object)this.key_encoding, Messages.Db2EditorDialog_17));
            temp.add(new PropertyDescriptor((Object)this.key_dbcsEncoding, Messages.OpenAsFormattedEditor2ActionItem_GraphicEncoding));
            temp.add(new PropertyDescriptor((Object)this.key_bidi_Direction, Messages.OpenAsFormattedEditor1ActionItem_Direction));
            temp.add(new PropertyDescriptor((Object)this.key_bidi_Layout, Messages.OpenAsFormattedEditor1ActionItem_Layout));
            temp.add(new PropertyDescriptor((Object)this.key_secondayIndexName, Messages.OpenAsFormattedEditor1ActionItem_15));
            return (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public Object getPropertyValue(Object arg) {
            if (arg instanceof String) {
                String id = (String)arg;
                if (id.equals(this.key_subsystem)) {
                    return this.imsEditOptions.getSubsystem().getName();
                }
                if (id.equals(this.key_resource)) {
                    return this.imsEditOptions.getImsResource().getFormattedName();
                }
                if (id.equals(this.key_template)) {
                    return this.imsEditOptions.getTemplate().getFormattedName();
                }
                if (id.equals(this.key_use_template)) {
                    return this.imsEditOptions.useTemplate();
                }
                if (id.equals(this.key_regionType)) {
                    return this.imsEditOptions.getRegionType().name();
                }
                if (id.equals(this.key_editDliDatabaseDS)) {
                    return this.imsEditOptions.editDliDatabaseDataSets();
                }
                if (id.equals(this.key_accessMode)) {
                    return this.imsEditOptions.getAccessMode().name();
                }
                if (id.equals(OpenAsFormattedEditor1ActionItem.KEY_EDIT_SESSION)) {
                    return this.imsEditOptions.isEditSession();
                }
                if (id.equals(this.key_ims_log)) {
                    return this.imsEditOptions.getImsLog().name();
                }
                if (id.equals(this.key_encoding)) {
                    return this.imsEditOptions.getEncoding();
                }
                if (id.equals(this.key_dbcsEncoding)) {
                    return this.imsEditOptions.getDbcsEncoding();
                }
                if (id.equals(this.key_secondayIndexName)) {
                    return this.imsEditOptions.getDynamicPsbSecondaryIndexName();
                }
                if (id.equals(this.key_bidi_Direction)) {
                    return this.imsEditOptions.getBidiFormatType().getDirection().getDisplayName();
                }
                if (id.equals(this.key_bidi_Layout)) {
                    return this.imsEditOptions.getBidiFormatType().getLayout().getDisplayName();
                }
                if (PDLoggerJhost.isTraceEnabled()) {
                    logger.warn((Object)("Unhandled key id: " + id));
                }
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

