/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.history.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.handlers.ImportFile;
import com.ibm.etools.fm.ui.views.systems.nodes.ActionItemNode;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import java.util.Objects;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;

public class ImportFileActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String KEY_FILE_PATH = "filepath";
    private static final String KEY_DATASET_NAME = "IMPCSV";
    private static final String KEY_TEMPLATE = "template";
    private static final String KEY_PRINT_HEADER = "printHeader";
    private static final String KEY_INCLFILLER = "inclFiller";
    private static final String KEY_INCLREDEF = "inclRedef";
    private static final String KEY_SINGLEQUOTES = "singleQuotes";
    private static final String KEY_DOUBLE_BYTES = "doubleBytes";
    private static final String KEY_DEST_VOL = "destVol";
    private static final String KEY_REPLACE = "replace";
    private static final String KEY_OVERWRITE = "overwrite";
    private static final String KEY_APPENDOPTION = "appendOpt";
    private static final String KEY_APPEND = "append";
    private String filePath;
    private String dataSetName;
    private String templateName;
    private boolean printHeader;
    private boolean includeFillers;
    private boolean includeRedifines;
    private boolean singleQuotes;
    private boolean specifyDoubleBytes;
    private String destResourceVol;
    private boolean isReplace;
    private boolean isOverwrite;
    private boolean appendVisibleOnLoad;
    private boolean append;
    private ImportFile importFile;

    public ImportFileActionItem(ActionType actionType, IPDHost provider) {
        super(actionType, provider);
    }

    @Override
    public void execute() {
        this.run(true);
    }

    @Override
    public void modify() {
        this.run(false);
    }

    private void run(boolean execute) {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection != null && selection instanceof StructuredSelection) {
            StructuredSelection structuredSel = (StructuredSelection)selection;
            Object object = structuredSel.getFirstElement();
            IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)object);
            this.importFile = new ImportFile();
            this.importFile.setFilePath(this.filePath);
            this.importFile.setDataSetName(this.dataSetName);
            this.importFile.setResource(this.dataSetName);
            this.importFile.setTemplate(this.templateName);
            this.importFile.setPrintHeader(this.printHeader);
            this.importFile.setIncludeFillers(this.includeFillers);
            this.importFile.setIncludeRedifines(this.includeRedifines);
            this.importFile.setSingleQuotes(this.singleQuotes);
            this.importFile.setSpecifyDoubleBytes(this.specifyDoubleBytes);
            this.importFile.setVolume(this.destResourceVol);
            this.importFile.setReplace(this.isReplace);
            this.importFile.setOverwrite(this.isOverwrite);
            this.importFile.setAppendVisibleOnLoad(this.appendVisibleOnLoad);
            this.importFile.setAppend(this.append);
            this.importFile.doImport(null, null, host, (ImportFileActionItem)((ActionItemNode)((Object)object)).getDataObject(), execute);
        }
    }

    @Override
    public void saveTo(IMemento memento) {
        memento.putString(KEY_FILE_PATH, this.filePath);
        memento.putString(KEY_DATASET_NAME, this.dataSetName);
        memento.putString(KEY_TEMPLATE, this.templateName);
        memento.putBoolean(KEY_PRINT_HEADER, this.printHeader);
        memento.putBoolean(KEY_INCLFILLER, this.includeFillers);
        memento.putBoolean(KEY_INCLREDEF, this.includeRedifines);
        memento.putBoolean(KEY_SINGLEQUOTES, this.singleQuotes);
        memento.putBoolean(KEY_DOUBLE_BYTES, this.specifyDoubleBytes);
        memento.putString(KEY_DEST_VOL, this.destResourceVol);
        memento.putBoolean(KEY_REPLACE, this.isReplace);
        memento.putBoolean(KEY_OVERWRITE, this.isOverwrite);
        memento.putBoolean(KEY_APPENDOPTION, this.appendVisibleOnLoad);
        memento.putBoolean(KEY_APPEND, this.append);
    }

    @Override
    public String getDefaultLabel() {
        return Messages.ImportDialog_IMPORT + " " + this.dataSetName + " using Template " + this.templateName;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ImportFileActionItem) {
            ImportFileActionItem action = (ImportFileActionItem)other;
            return this.dataSetName.equals(action.dataSetName) && this.templateName.equals(action.templateName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public ActionItem clone() {
        ImportFileActionItem clone = new ImportFileActionItem(this.getActionType(), this.getSystem());
        this.syncState(clone);
        return clone;
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        ImportFileActionItem actionItem = new ImportFileActionItem(ActionType.IMPORT_DESKTOP_BASE, system);
        actionItem.filePath = memento.getString(KEY_FILE_PATH);
        actionItem.dataSetName = memento.getString(KEY_DATASET_NAME);
        actionItem.templateName = memento.getString(KEY_TEMPLATE);
        actionItem.printHeader = memento.getBoolean(KEY_PRINT_HEADER);
        actionItem.includeFillers = memento.getBoolean(KEY_INCLFILLER);
        actionItem.includeRedifines = memento.getBoolean(KEY_INCLREDEF);
        actionItem.singleQuotes = memento.getBoolean(KEY_SINGLEQUOTES);
        actionItem.specifyDoubleBytes = memento.getBoolean(KEY_DOUBLE_BYTES);
        actionItem.destResourceVol = memento.getString(KEY_DEST_VOL);
        actionItem.isReplace = memento.getBoolean(KEY_REPLACE);
        actionItem.isOverwrite = memento.getBoolean(KEY_OVERWRITE);
        actionItem.appendVisibleOnLoad = memento.getBoolean(KEY_APPENDOPTION);
        actionItem.append = memento.getBoolean(KEY_APPEND);
        return actionItem;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public void setTemplate(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setPrintHeader(boolean printHeader) {
        this.printHeader = printHeader;
    }

    public void setIncludeFillers(boolean includeFillers) {
        this.includeFillers = includeFillers;
    }

    public void setIncludeRedifines(boolean includeRedifines) {
        this.includeRedifines = includeRedifines;
    }

    public void setSingleQuotes(boolean singleQuotes) {
        this.singleQuotes = singleQuotes;
    }

    public void setSpecifyDoubleBytes(boolean specifyDoubleBytes) {
        this.specifyDoubleBytes = specifyDoubleBytes;
    }

    public void setDestResourceVol(String destResourceVol) {
        this.destResourceVol = destResourceVol;
    }

    public void setReplace(boolean isReplace) {
        this.isReplace = isReplace;
    }

    public void setOverwrite(boolean isOverwrite) {
        this.isOverwrite = isOverwrite;
    }

    public void setAppendVisibleOnLoad(boolean appendVisibleOnLoad) {
        this.appendVisibleOnLoad = appendVisibleOnLoad;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

