/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.history.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DummyMember;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.Export2DesktopData;
import com.ibm.etools.fm.ui.dialog.ExportAbstractDialog;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.handlers.ExportData;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ExportDb2ResourceActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String KEY_SUBSYSTEM = "subsystem";
    private static final String KEY_TABLE = "table";
    private static final String KEY_EDIT = "edit";
    private static final String KEY_START_POS = "startPos";
    private static final String KEY_ROW_COUNT = "rowCount";
    private static final String KEY_ENCODING = "encoding";
    private static final String KEY_DBCS_ENCODING = "dbcsEncoding";
    private static final String KEY_GEN_REP = "genRep";
    private static final String KEY_TEMPLATE = "template";
    private static final String KEY_OUTPUT_FILE_NAME = "outputFile";
    private static final String KEY_OUTPUT_FORMAT = "outputFormat";
    private static final String KEY_PRINT_HEADER = "printHeader";
    private static final String KEY_INCLUDE_FILLERS = "includeFillers";
    private static final String KEY_INCLUDE_REDEFINES = "includeRedefines";
    private static final String KEY_LEADING_BLANKS = "leadingBlanks";
    private static final String KEY_TRAILING_BLANKS = "trailingBlanks";
    private static final String KEY_QUOTED_VALUES = "quoteValues";
    private static final String KEY_SINGLE_QUOTES = "singleQuotes";
    private static final String KEY_ASIS_ENCAPSULATION = "asisEncapsulation";
    private static ExportDb2ResourceActionItemPropertySource propSource;
    private Db2EditOptions db2EditOptions = null;
    private Export2DesktopData exportData = new Export2DesktopData();

    private ExportDb2ResourceActionItem(IPDHost hostProvider) {
        super(ActionType.EXPORT_DESKTOP_DB2, hostProvider);
        this.db2EditOptions = new Db2EditOptions();
        this.db2EditOptions.setHost(hostProvider);
    }

    public ExportDb2ResourceActionItem(Db2EditOptions db2EditOptions, Export2DesktopData exportData) {
        super(ActionType.EXPORT_DESKTOP_DB2, db2EditOptions.getTable().getSystem());
        this.db2EditOptions = db2EditOptions;
        this.exportData = exportData;
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.ExportDb2ResourceActionItem_0, this.db2EditOptions.getTable().getFormattedName(), this.db2EditOptions.getTemplate() == null ? "" : this.db2EditOptions.getTemplate().getFormattedName());
    }

    @Override
    public boolean isExecuting() {
        return super.isExecuting() || FMUIPlugin.getDefault().dsEditSessionExist((IZRL)this.db2EditOptions.getTable());
    }

    @Override
    public void saveTo(IMemento memento) {
        memento.putString(KEY_SUBSYSTEM, this.db2EditOptions.getSubsystem().getFormattedName());
        memento.putString(KEY_TABLE, this.db2EditOptions.getTable().getFormattedName());
        memento.putBoolean(KEY_EDIT, this.db2EditOptions.isEdit());
        memento.putString(KEY_START_POS, this.db2EditOptions.getStartPosition());
        memento.putString(KEY_ROW_COUNT, this.db2EditOptions.getRowCount());
        memento.putString(KEY_ENCODING, this.db2EditOptions.getEncoding());
        memento.putString(KEY_DBCS_ENCODING, this.db2EditOptions.getDbcsEncoding());
        memento.putBoolean(KEY_GEN_REP, this.db2EditOptions.isGenRep());
        IZRL template = this.db2EditOptions.getTemplate();
        memento.putString(KEY_TEMPLATE, template instanceof DummyMember ? "" : template.getFormattedName());
        memento.putString(KEY_OUTPUT_FILE_NAME, this.exportData.getOutputFileName());
        memento.putString(KEY_OUTPUT_FORMAT, this.exportData.getType().name());
        memento.putBoolean(KEY_PRINT_HEADER, this.exportData.isPrintHeader());
        memento.putBoolean(KEY_INCLUDE_FILLERS, this.exportData.isIncludeFillers());
        memento.putBoolean(KEY_INCLUDE_REDEFINES, this.exportData.isIncludeRedefines());
        memento.putBoolean(KEY_LEADING_BLANKS, this.exportData.isIncludeLeadingBlanks());
        memento.putBoolean(KEY_TRAILING_BLANKS, this.exportData.isIncludeTrailingBlanks());
        memento.putBoolean(KEY_QUOTED_VALUES, this.exportData.isEncapsulate());
        memento.putBoolean(KEY_SINGLE_QUOTES, this.exportData.isSingleQuotes());
        memento.putBoolean(KEY_ASIS_ENCAPSULATION, this.exportData.isAsisEncapsulation());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        Objects.requireNonNull(system, "Must specify a non-null system.");
        Db2EditOptions db2EditOptions = new Db2EditOptions();
        db2EditOptions.setHost(system);
        db2EditOptions.setSubsystem(Db2Subsystem.parseSubsystem((IPDHost)system, (String)memento.getString(KEY_SUBSYSTEM)));
        db2EditOptions.setTable(Db2Table.parseTable((IPDHost)system, (String)memento.getString(KEY_TABLE)));
        db2EditOptions.setEdit(memento.getBoolean(KEY_EDIT).booleanValue());
        db2EditOptions.setStartPosition(memento.getString(KEY_START_POS));
        db2EditOptions.setRowCount(memento.getString(KEY_ROW_COUNT));
        db2EditOptions.setEncoding(memento.getString(KEY_ENCODING));
        db2EditOptions.setDbcsEncoding(memento.getString(KEY_DBCS_ENCODING));
        db2EditOptions.setGenRep(memento.getBoolean(KEY_GEN_REP).booleanValue());
        String template = memento.getString(KEY_TEMPLATE);
        db2EditOptions.setTemplate((IZRL)(template.isEmpty() ? DummyMember.createDummyMember((IPDHost)system) : ZRLs.parseZRL((IPDHost)system, (String)template)));
        Export2DesktopData exportData = new Export2DesktopData();
        exportData.setOutputFileName(memento.getString(KEY_OUTPUT_FILE_NAME));
        if (memento.getString(KEY_OUTPUT_FORMAT) != null) {
            exportData.setType(ExportAbstractDialog.ExportOutputType.valueOf(memento.getString(KEY_OUTPUT_FORMAT)));
        }
        exportData.setPrintHeader(memento.getBoolean(KEY_PRINT_HEADER));
        exportData.setIncludeFillers(memento.getBoolean(KEY_INCLUDE_FILLERS));
        exportData.setIncludeRedefines(memento.getBoolean(KEY_INCLUDE_REDEFINES));
        exportData.setIncludeLeadingBlanks(memento.getBoolean(KEY_LEADING_BLANKS));
        exportData.setIncludeTrailingBlanks(memento.getBoolean(KEY_TRAILING_BLANKS));
        exportData.setEncapsulate(memento.getBoolean(KEY_QUOTED_VALUES));
        exportData.setSingleQuotes(memento.getBoolean(KEY_SINGLE_QUOTES));
        exportData.setAsisEncapsulation(memento.getBoolean(KEY_ASIS_ENCAPSULATION));
        return new ExportDb2ResourceActionItem(db2EditOptions, exportData);
    }

    @Override
    public void execute() {
        if (this.isExecuting()) {
            logger.trace((Object)"Ignoring execute while execution is in progress");
            return;
        }
        final ExportDb2ResourceActionItem itself = this;
        this.beginExecution();
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.ExportDb2ResourceActionItem_2, ExportDb2ResourceActionItem.this.db2EditOptions.getTable().getFormattedName(), ExportDb2ResourceActionItem.this.db2EditOptions.getTemplate().getFormattedName()), 2);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ExportData.showExportDialog2(itself, false);
                        }
                    });
                    monitor.done();
                }
            });
            this.setErrorToolTipText(null);
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.ExportDb2ResourceActionItem_3, this.db2EditOptions.getTable().getFormattedName(), this.db2EditOptions.getTemplate().getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg, (Throwable)e);
            this.setErrorToolTipText(errMsg);
        }
    }

    @Override
    public void modify() {
        if (this.isExecuting()) {
            logger.trace((Object)"Ignoring execute while execution is in progress");
            return;
        }
        final ExportDb2ResourceActionItem itself = this;
        this.beginExecution();
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.ExportDb2ResourceActionItem_4, ExportDb2ResourceActionItem.this.db2EditOptions.getTable().getFormattedName(), ExportDb2ResourceActionItem.this.db2EditOptions.getTemplate().getFormattedName()), 2);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ExportData.showExportDialog2(itself, true);
                        }
                    });
                    monitor.done();
                }
            });
            this.setErrorToolTipText(null);
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.ExportDb2ResourceActionItem_5, this.db2EditOptions.getTable().getFormattedName(), this.db2EditOptions.getTemplate().getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg, (Throwable)e);
            this.setErrorToolTipText(errMsg);
        }
    }

    @Override
    public ExportDb2ResourceActionItem clone() {
        ExportDb2ResourceActionItem aCopy = new ExportDb2ResourceActionItem(this.db2EditOptions.clone(), this.exportData);
        return aCopy;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ExportDb2ResourceActionItem) {
            ExportDb2ResourceActionItem other = (ExportDb2ResourceActionItem)obj;
            return this.db2EditOptions.equals((Object)other.db2EditOptions) && this.exportData.equals(other.exportData);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 37;
        result = 37 * result + this.db2EditOptions.hashCode();
        result = 37 * result + this.exportData.hashCode();
        return result;
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new ExportDb2ResourceActionItemPropertySource(this.db2EditOptions, this.exportData);
        }
        propSource.setModel(this.db2EditOptions, this.exportData);
        return propSource;
    }

    public Db2EditOptions getOptions() {
        return this.db2EditOptions;
    }

    public void setOptions(Db2EditOptions db2EditOptions, Export2DesktopData exportData) {
        this.db2EditOptions = db2EditOptions;
        this.exportData = exportData;
    }

    public Export2DesktopData getExportData() {
        return this.exportData;
    }

    private static class ExportDb2ResourceActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private Db2EditOptions db2EditOptions;
        private Export2DesktopData exportData;
        public String key_resource = "resource";
        public String key_template = "template";
        public String key_subsystem = "subsystem";
        public String key_startPos = "startPos";
        public String key_rowCount = "rowCount";
        public String key_encoding = "encoding";
        public String key_dbcsEncoding = "dbcsEncoding";
        public String key_genRep = "genRep";
        public String outputFileNameKey = "outputFile";
        public String outputFormatKey = "outputFormat";
        public String printHeaderKey = "printHeader";
        private String leadingBlanks = "leadingBlanks";
        private String trailingBlanks = "trailingBlanks";
        private String quotedValues = "quotedValues";
        private String singleQuotes = "singleQuotes";
        private String asisEncapsulation = "asisEncapsulation";

        public ExportDb2ResourceActionItemPropertySource(Db2EditOptions db2EditOptions, Export2DesktopData exportData) {
            this.db2EditOptions = db2EditOptions;
            this.exportData = exportData;
        }

        public void setModel(Db2EditOptions db2EditOptions, Export2DesktopData exportData) {
            this.db2EditOptions = db2EditOptions;
            this.exportData = exportData;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.key_resource, Messages.OpenAsFormatted_DB2_ACTION_RESOURCE_NAME));
            temp.add(new PropertyDescriptor((Object)this.key_template, Messages.OpenAsFormatted_DB2_ACTION_TEMPLATE_NAME));
            temp.add(new PropertyDescriptor((Object)this.key_subsystem, Messages.Db2EditorDialog_12));
            temp.add(new PropertyDescriptor((Object)this.key_startPos, Messages.Db2EditorDialog_13));
            temp.add(new PropertyDescriptor((Object)this.key_rowCount, Messages.Db2EditorDialog_15));
            temp.add(new PropertyDescriptor((Object)this.key_encoding, Messages.Db2EditorDialog_17));
            temp.add(new PropertyDescriptor((Object)this.key_dbcsEncoding, Messages.OpenAsFormattedEditor2ActionItem_GraphicEncoding));
            temp.add(new PropertyDescriptor((Object)this.key_genRep, Messages.Db2EditorDialog_21));
            temp.add(new PropertyDescriptor((Object)this.outputFileNameKey, Messages.ExportDb2ResourceActionItem_6));
            temp.add(new PropertyDescriptor((Object)this.outputFormatKey, Messages.ExportDb2ResourceActionItem_7));
            temp.add(new PropertyDescriptor((Object)this.printHeaderKey, Messages.ExportDb2ResourceActionItem_8));
            temp.add(new PropertyDescriptor((Object)this.leadingBlanks, Messages.ExportAbstractDialog_20));
            temp.add(new PropertyDescriptor((Object)this.trailingBlanks, Messages.ExportAbstractDialog_22));
            temp.add(new PropertyDescriptor((Object)this.quotedValues, Messages.ExportAbstractDialog_26));
            temp.add(new PropertyDescriptor((Object)this.singleQuotes, Messages.ExportAbstractDialog_28));
            temp.add(new PropertyDescriptor((Object)this.asisEncapsulation, Messages.ExportAbstractDialog_18));
            return (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public Object getPropertyValue(Object arg) {
            if (arg instanceof String) {
                String id = (String)arg;
                if (id.equals(this.key_resource)) {
                    return this.db2EditOptions.getTable().getFormattedName();
                }
                if (id.equals(this.key_template)) {
                    return this.db2EditOptions.getTemplate().getFormattedName();
                }
                if (id.equals(this.key_subsystem)) {
                    return this.db2EditOptions.getSubsystem().getSubsystemID();
                }
                if (id.equals(this.key_startPos)) {
                    return this.db2EditOptions.getStartPosition();
                }
                if (id.equals(this.key_rowCount)) {
                    return this.db2EditOptions.getRowCount();
                }
                if (id.equals(this.key_encoding)) {
                    return this.db2EditOptions.getEncoding();
                }
                if (id.equals(this.key_dbcsEncoding)) {
                    return this.db2EditOptions.getDbcsEncoding();
                }
                if (id.equals(this.key_genRep)) {
                    return this.db2EditOptions.isGenRep();
                }
                if (id.equals(this.outputFileNameKey)) {
                    return this.exportData.getOutputFileName();
                }
                if (id.equals(this.outputFormatKey)) {
                    return this.exportData.getType().name();
                }
                if (id.equals(this.printHeaderKey)) {
                    return this.exportData.isPrintHeader();
                }
                if (id.equals(this.leadingBlanks)) {
                    return this.exportData.isIncludeLeadingBlanks();
                }
                if (id.equals(this.trailingBlanks)) {
                    return this.exportData.isIncludeTrailingBlanks();
                }
                if (id.equals(this.quotedValues)) {
                    return this.exportData.isEncapsulate();
                }
                if (id.equals(this.singleQuotes)) {
                    return this.exportData.isSingleQuotes();
                }
                if (id.equals(this.asisEncapsulation)) {
                    return this.exportData.isAsisEncapsulation();
                }
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

