/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.history.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.editor.formatted.BaseEditorOptionsForExportPropertySource;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.Export2DesktopData;
import com.ibm.etools.fm.ui.dialog.ExportAbstractDialog;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.handlers.ExportData;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertySource;

public class ExportBaseResourceActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String KEY_RESOURCE = "resource";
    private static final String KEY_TEMPLATE = "template";
    private static final String KEY_ENCODING = "encoding";
    private static final String KEY_DBCS_ENCODING = "dbcsEncoding";
    private static final String KEY_VOLSER = "volser";
    private static final String KEY_START_POS_TYPE = "startPosType";
    private static final String KEY_START_POS_VALUE = "startPosValue";
    private static final String KEY_BIN_REC_LEN = "binRecLen";
    private static final String KEY_RECORD_SAMPLE = "recordSample";
    private static final String KEY_ONLY_SELECTED = "onlySelected";
    private static final String KEY_INCLUDE_PHYSICAL_RECORD = "includePhysRec";
    private static final String KEY_SKIP_PHYSICAL_RECORD = "skipPhysRec";
    private static final String KEY_RECORD_LIMIT = "recordLimit";
    private static final String KEY_OUTPUT_FILE_NAME = "outputFile";
    private static final String KEY_OUTPUT_FORMAT = "outputFormat";
    private static final String KEY_PRINT_HEADER = "printHeader";
    private static final String KEY_IO_EXIT = "ioExit";
    private static final String KEY_INCLUDE_FILLERS = "includeFillers";
    private static final String KEY_INCLUDE_REDEFINES = "includeRedefines";
    private static final String KEY_LEADING_BLANKS = "leadingBlanks";
    private static final String KEY_TRAILING_BLANKS = "trailingBlanks";
    private static final String KEY_QUOTED_VALUES = "quoteValues";
    private static final String KEY_SINGLE_QUOTES = "singleQuotes";
    private static final String KEY_ASIS_ENCAPSULATION = "asisEncapsulation";
    private static BaseEditorOptionsForExportPropertySource propSource;
    private BaseEditorOptions model = new BaseEditorOptions();
    private Export2DesktopData exportData = new Export2DesktopData();

    private ExportBaseResourceActionItem(IPDHost hostProvider) {
        super(ActionType.EXPORT_DESKTOP_BASE, hostProvider);
    }

    public ExportBaseResourceActionItem(BaseEditorOptions options, Export2DesktopData exportData) {
        super(ActionType.EXPORT_DESKTOP_BASE, options.getaResource().getSystem());
        this.model = options;
        this.exportData = exportData;
    }

    @Override
    public String getDefaultLabel() {
        IZRL resource = this.model.getaResource();
        IZRL template = this.model.getaTemplate();
        return MessageFormat.format(Messages.ExportBaseResourceActionItem_0, resource == null ? resource : resource.getFormattedName(), template == null ? template : template.getFormattedName());
    }

    @Override
    public boolean isExecuting() {
        return super.isExecuting() || FMUIPlugin.getDefault().dsEditSessionExist(this.model.getaResource());
    }

    @Override
    public void saveTo(IMemento memento) {
        memento.putString(KEY_RESOURCE, this.model.getaResource().getFormattedName());
        memento.putString(KEY_TEMPLATE, this.model.getaTemplate() == null ? "" : this.model.getaTemplate().getFormattedName());
        memento.putString(KEY_ENCODING, this.model.getEncodingForSession());
        memento.putString(KEY_DBCS_ENCODING, this.model.getDbcsEncodingForSession());
        memento.putString(KEY_VOLSER, this.model.getaVolumeSerial());
        memento.putString(KEY_START_POS_TYPE, this.model.getStartType().name());
        memento.putString(KEY_START_POS_VALUE, this.model.getaStartPosition());
        memento.putString(KEY_BIN_REC_LEN, this.model.getBinaryLength());
        memento.putBoolean(KEY_RECORD_SAMPLE, this.model.isRecordSampling());
        memento.putBoolean(KEY_ONLY_SELECTED, this.model.isOnlySelectedRecs());
        memento.putString(KEY_INCLUDE_PHYSICAL_RECORD, this.model.getIncludePhysicalRecords());
        memento.putString(KEY_SKIP_PHYSICAL_RECORD, this.model.getSkipPhysicalRecords());
        memento.putString(KEY_RECORD_LIMIT, this.model.getRecordLimit());
        memento.putString(KEY_OUTPUT_FILE_NAME, this.exportData.getOutputFileName());
        memento.putString(KEY_OUTPUT_FORMAT, this.exportData.getType().name());
        memento.putBoolean(KEY_PRINT_HEADER, this.exportData.isPrintHeader());
        memento.putString(KEY_IO_EXIT, this.model.getIoExitName());
        memento.putBoolean(KEY_INCLUDE_FILLERS, this.exportData.isIncludeFillers());
        memento.putBoolean(KEY_INCLUDE_REDEFINES, this.exportData.isIncludeRedefines());
        memento.putBoolean(KEY_LEADING_BLANKS, this.exportData.isIncludeLeadingBlanks());
        memento.putBoolean(KEY_TRAILING_BLANKS, this.exportData.isIncludeTrailingBlanks());
        memento.putBoolean(KEY_QUOTED_VALUES, this.exportData.isEncapsulate());
        memento.putBoolean(KEY_SINGLE_QUOTES, this.exportData.isSingleQuotes());
        memento.putBoolean(KEY_ASIS_ENCAPSULATION, this.exportData.isAsisEncapsulation());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(system, "Must specify a non-null system.");
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        ExportBaseResourceActionItem ai = new ExportBaseResourceActionItem(system);
        ai.model.setaResource(ZRLs.parseZRL((IPDHost)system, (String)memento.getString(KEY_RESOURCE)));
        String template = memento.getString(KEY_TEMPLATE);
        ai.model.setaTemplate(template.isEmpty() ? null : ZRLs.parseZRL((IPDHost)system, (String)template));
        ai.model.setEncodingForSession(memento.getString(KEY_ENCODING));
        ai.model.setDbcsEncodingForSession(memento.getString(KEY_DBCS_ENCODING));
        ai.model.setaVolumeSerial(memento.getString(KEY_VOLSER));
        ai.model.setStartType(BaseEditorOptions.BaseStartPosType.valueOf((String)memento.getString(KEY_START_POS_TYPE)));
        ai.model.setaStartPosition(memento.getString(KEY_START_POS_VALUE));
        ai.model.setBinaryLength(memento.getString(KEY_BIN_REC_LEN));
        ai.model.setRecordSampling(memento.getBoolean(KEY_RECORD_SAMPLE).booleanValue());
        ai.model.setOnlySelectedRecs(memento.getBoolean(KEY_ONLY_SELECTED).booleanValue());
        ai.model.setIncludePhysicalRecords(memento.getString(KEY_INCLUDE_PHYSICAL_RECORD));
        ai.model.setSkipPhysicalRecords(memento.getString(KEY_SKIP_PHYSICAL_RECORD));
        ai.model.setRecordLimit(memento.getString(KEY_RECORD_LIMIT));
        ai.model.setIoExitName(memento.getString(KEY_IO_EXIT));
        Export2DesktopData exportData = new Export2DesktopData();
        exportData.setOutputFileName(memento.getString(KEY_OUTPUT_FILE_NAME));
        if (memento.getString(KEY_OUTPUT_FORMAT) != null) {
            exportData.setType(ExportAbstractDialog.ExportOutputType.valueOf(memento.getString(KEY_OUTPUT_FORMAT)));
        }
        exportData.setPrintHeader(memento.getBoolean(KEY_PRINT_HEADER));
        ai.setOptions(ai.model, exportData);
        return ai;
    }

    @Override
    public void execute() {
        this.run(false);
    }

    @Override
    public void modify() {
        this.run(true);
    }

    private void run(final boolean showDialog) {
        if (this.isExecuting()) {
            logger.trace((Object)"Ignoring execute while execution is in progress");
            return;
        }
        this.beginExecution();
        try {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ExportData.showExportDialog(ExportBaseResourceActionItem.this, showDialog);
                }
            });
            this.setErrorToolTipText(null);
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.ExportBaseResourceActionItem_2, this.model.getaResource().getFormattedName(), this.model.getaTemplate().getFormattedName());
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            this.setErrorToolTipText(errMsg);
        }
    }

    @Override
    public ExportBaseResourceActionItem clone() {
        ExportBaseResourceActionItem aCopy = new ExportBaseResourceActionItem(this.model.clone(), this.exportData);
        return aCopy;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ExportBaseResourceActionItem) {
            ExportBaseResourceActionItem other = (ExportBaseResourceActionItem)o;
            return this.model.equals((Object)other.model) && this.exportData.equals(other.exportData);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 37;
        result = 37 * result + this.model.hashCode();
        result = 37 * result + this.exportData.hashCode();
        return result;
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new BaseEditorOptionsForExportPropertySource(this.model, this.exportData);
        }
        propSource.setModel(this.model, this.exportData);
        return propSource;
    }

    public BaseEditorOptions getOptions() {
        return this.model;
    }

    public void setOptions(BaseEditorOptions options, Export2DesktopData exportData) {
        this.model = options;
        this.exportData = exportData;
    }

    public Export2DesktopData getExportData() {
        return this.exportData;
    }
}

