/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.history.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.CopybookPrintOptions;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.ui.dialog.CopybookPrintDialog;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.views.systems.handlers.CopybookPrint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CopybookPrintActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String KEY_RESOURCE = "resource";
    private static final String KEY_SHOW_ARRAY_ELEMENTS = "showarrayelements";
    private static final String KEY_SHOW_HEX_OFFSETS = "showhexoffsets";
    private static final String KEY_SHOW_LENGTH_IN_HEX = "showlengthinhex";
    private static final String KEY_SHOW_TEMPLATE_CRITERIA = "showtemplatecriteria";
    private CopybookPrintOptions options = new CopybookPrintOptions();
    private static CopybookPrintPropertySource propSource;

    public CopybookPrintActionItem(CopybookPrintOptions options) {
        super(ActionType.COPYBOOK_PRINT, options.getResource().getSystem());
        this.options = options.clone();
    }

    private CopybookPrintActionItem(IPDHost hostProvider) {
        super(ActionType.COPYBOOK_PRINT, hostProvider);
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.CopybookPrintDefaultLabel, this.options.getResource().getFormattedName());
    }

    @Override
    public boolean isExecuting() {
        return super.isExecuting();
    }

    @Override
    public void saveTo(IMemento memento) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        IActionItemSaver.saveDestinationSystem(memento, this.options.getSystem());
        memento.putString(KEY_RESOURCE, this.options.getResource().getFormattedName());
        memento.putBoolean(KEY_SHOW_ARRAY_ELEMENTS, this.options.getShowArrayElements());
        memento.putBoolean(KEY_SHOW_HEX_OFFSETS, this.options.getShowHexOffsets());
        memento.putBoolean(KEY_SHOW_LENGTH_IN_HEX, this.options.getShowLengthInHex());
        memento.putBoolean(KEY_SHOW_TEMPLATE_CRITERIA, this.options.getShowTemplateCriteria());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        CopybookPrintActionItem ai = new CopybookPrintActionItem(system);
        ai.options.setSystem(IActionItemSaver.loadDestinationSystem(memento));
        ai.options.setResource(ZRLs.parseZRL((IPDHost)system, (String)memento.getString(KEY_RESOURCE)));
        ai.options.setShowArrayElements(memento.getBoolean(KEY_SHOW_ARRAY_ELEMENTS).booleanValue());
        ai.options.setShowHexOffsets(memento.getBoolean(KEY_SHOW_HEX_OFFSETS).booleanValue());
        ai.options.setShowLengthInHex(memento.getBoolean(KEY_SHOW_LENGTH_IN_HEX).booleanValue());
        ai.options.setShowTemplateCriteria(memento.getBoolean(KEY_SHOW_TEMPLATE_CRITERIA).booleanValue());
        return ai;
    }

    @Override
    public void execute() {
        if (this.isExecuting()) {
            logger.trace((Object)"Ignoring execute while execution is in progress");
            return;
        }
        this.beginExecution();
        try {
            CopybookPrint.invokeCopybookViewPrint(this.options.getSystem(), this.options, this);
            this.setErrorToolTipText(null);
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.CopybookPrintException, this.options.getResource().getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg, (Throwable)e);
            this.setErrorToolTipText(errMsg);
        }
        this.finishExecution(false);
    }

    @Override
    public void modify() {
        this.beginExecution();
        CopybookPrintDialog dialog = new CopybookPrintDialog(Display.getDefault().getActiveShell(), this.getSystem(), this.options.clone());
        if (dialog.open() != 0) {
            this.finishExecution(true);
            return;
        }
        CopybookPrintOptions newopts = dialog.getCopybookPrintOptions();
        try {
            CopybookPrint.invokeCopybookViewPrint(this.options.getSystem(), newopts, this);
            this.setErrorToolTipText(null);
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.CopybookPrintException, this.options.getResource().getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg, (Throwable)e);
            this.setErrorToolTipText(errMsg);
        }
        this.finishExecution(false);
    }

    @Override
    public CopybookPrintActionItem clone() {
        CopybookPrintActionItem clone = new CopybookPrintActionItem(this.options.getResource().getSystem());
        if (this.options != null) {
            clone.options = this.options.clone();
        }
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CopybookPrintActionItem) {
            CopybookPrintActionItem other = (CopybookPrintActionItem)obj;
            return this.options.equals((Object)other.options);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.options.hashCode();
    }

    public CopybookPrintOptions getOptions() {
        return this.options;
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new CopybookPrintPropertySource(this.options);
        }
        propSource.setOptions(this.options);
        return propSource;
    }

    private static class CopybookPrintPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2020. All rights reserved.";
        private CopybookPrintOptions options;
        private IPropertyDescriptor[] propertyDescriptors;
        private String resource = "resource";
        private String system = "system";
        private String showArrayElements = "showArrayElements";
        private String showHexOffsets = "showHexOffsets";
        private String showLengthInHex = "showshowLengthInHexArrayElements";
        private String showTemplateCriteria = "showTemplateCriteria";

        public CopybookPrintPropertySource(CopybookPrintOptions options) {
            this.options = options;
            this.init();
        }

        public void setOptions(CopybookPrintOptions options) {
            this.options = options;
        }

        private void init() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.resource, Messages.CopybookPrintPropertyResource));
            temp.add(new PropertyDescriptor((Object)this.system, Messages.CopybookPrintPropertySystem));
            temp.add(new PropertyDescriptor((Object)this.showArrayElements, Messages.CopybookPrintPropertyShowArrayElements));
            temp.add(new PropertyDescriptor((Object)this.showHexOffsets, Messages.CopybookPrintPropertyShowHexOffsets));
            temp.add(new PropertyDescriptor((Object)this.showLengthInHex, Messages.CopybookPrintPropertyShowLengthInHex));
            temp.add(new PropertyDescriptor((Object)this.showTemplateCriteria, Messages.CopybookPrintPropertyShowTemplateCriteria));
            this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object id) {
            if (id.equals(this.resource)) {
                return this.options.getResource().getFormattedName();
            }
            if (id.equals(this.system)) {
                return this.options.getSystem().getConnectionName();
            }
            if (id.equals(this.showArrayElements)) {
                return this.options.getShowArrayElements();
            }
            if (id.equals(this.showHexOffsets)) {
                return this.options.getShowHexOffsets();
            }
            if (id.equals(this.showLengthInHex)) {
                return this.options.getShowLengthInHex();
            }
            if (id.equals(this.showTemplateCriteria)) {
                return this.options.getShowTemplateCriteria();
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

