/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.history;

import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.wizards.WizardRunnable;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventRemoteDispatcher;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class ActionItem
implements IActionItem,
IEntityEventRemoteDispatcher {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(ActionItem.class);
    public static final String ACTION_HISTORY_ICON_DIR = "action_history";
    private ActionType actionType = null;
    private String errorTooltip = null;
    private long lastExecutionTime;
    private IPDHost oldHostProvider = null;
    boolean isExecuting = false;
    private boolean favorite = false;
    private final EntityEventDispatcher<IActionItem> eventDispatcher = new EntityEventDispatcher((Object)this);
    private String customLabel;
    private Object remoteListener = null;

    protected ActionItem(ActionType actionType, IPDHost provider) {
        Objects.requireNonNull(actionType, "Must specify a non-null actionType.");
        Objects.requireNonNull(provider, "Must specify a non-null provider.");
        this.setActionType(actionType);
        this.lastExecutionTime = System.currentTimeMillis();
        this.oldHostProvider = provider;
    }

    protected ActionItem(ActionType actionType, IPDHost provider, boolean favorite) {
        this(actionType, provider);
        this.favorite = favorite;
    }

    protected void setActionType(ActionType actionType) {
        this.actionType = Objects.requireNonNull(actionType, "Must provide a non-null actionType");
    }

    @Override
    public ActionType getActionType() {
        return this.actionType;
    }

    @Override
    public void setCustomLabel(String customLabel) {
        if (customLabel != null && customLabel.isEmpty()) {
            customLabel = null;
        }
        this.customLabel = customLabel;
        this.eventDispatcher.fireChangedEvent(IActionItem.PROPERTY_CUSTOM_LABEL);
    }

    @Override
    public String getCustomLabel() {
        return this.customLabel;
    }

    @Override
    public String getLabel() {
        return this.customLabel == null ? this.getDefaultLabel() : this.customLabel;
    }

    public String getImageName() {
        return this.actionType.getImageName();
    }

    public abstract String getDefaultLabel();

    @Override
    public String getToolTipText() {
        return this.getDefaultLabel();
    }

    public String toString() {
        return this.getDefaultLabel();
    }

    @Override
    public void setErrorToolTipText(String tooltip) {
        this.errorTooltip = tooltip;
        this.eventDispatcher.fireChangedEvent(IActionItem.PROPERTY_ERROR_TOOLTIP);
        this.finishExecution(false);
    }

    @Override
    public String getErrorToolTipText() {
        return this.errorTooltip;
    }

    @Override
    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
        this.eventDispatcher.fireChangedEvent(IActionItem.PROPERTY_FAVORITE);
    }

    @Override
    public boolean isFavorite() {
        return this.favorite;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public Runnable getUpdateStateCallback(final WizardRunnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                if (runnable.getResult() != null && runnable.getResult().hasError()) {
                    ActionItem.this.setErrorToolTipText(runnable.getResult().dumpOutputAndMessages(true));
                } else {
                    ActionItem.this.setErrorToolTipText(null);
                }
                if (!ActionItem.this.getSystem().equals(ActionItem.this.oldHostProvider)) {
                    ActionItem.this.oldHostProvider = ActionItem.this.getSystem();
                }
            }
        };
    }

    public Runnable getFinishExecutionCallBack() {
        return new Runnable(){

            @Override
            public void run() {
                ActionItem.this.finishExecution(false);
            }
        };
    }

    protected void setExecuting(boolean newExecutionState) {
        this.isExecuting = newExecutionState;
        this.eventDispatcher.fireChangedEvent(IActionItem.PROPERTY_EXECUTION_STATE);
    }

    @Override
    public boolean isExecuting() {
        return this.isExecuting;
    }

    protected void beginExecution() {
        this.setExecuting(true);
    }

    protected void finishExecution(boolean wasCanceled) {
        this.setExecuting(false);
        if (!wasCanceled) {
            this.setLastExecutionTime(System.currentTimeMillis());
        }
    }

    @Override
    public void setLastExecutionTime(long t) {
        this.lastExecutionTime = t;
        this.eventDispatcher.fireChangedEvent(IActionItem.PROPERTY_EXECUTION_TIME);
    }

    @Override
    public long getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    protected IActionItem syncState(IActionItem action) {
        action.setErrorToolTipText(this.getErrorToolTipText());
        action.setCustomLabel(this.customLabel);
        action.setFavorite(this.isFavorite());
        return action;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public abstract ActionItem clone();

    @Override
    public IPropertySource getPropertySource() {
        return null;
    }

    public IPDHost getSystem() {
        return this.oldHostProvider;
    }

    @Override
    public void execute(List<SystemsTreeNode> draggedObjects) {
        this.execute();
    }

    @Override
    public boolean isValidInput(List<SystemsTreeNode> draggedObjects) {
        return false;
    }

    public Object getLoadFinishedListener() {
        return this.remoteListener;
    }

    public void setLoadFinishedListener(Object listener) {
        this.remoteListener = listener;
    }

    public void addListener(EListener<EntityEvent<IActionItem>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<IActionItem>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public String getPDImageName() {
        return ACTION_HISTORY_ICON_DIR + File.separator + this.getActionType().getImageName();
    }

    public String getPDLabel() {
        return this.getLabel();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public boolean checkDecorateImageStatic() {
        return this.getErrorToolTipText() != null;
    }

    public Object getNewImage(Object anImage) {
        if (this.isFavorite()) {
            return SystemsLabelDecorator.overlay((Image)((Image)anImage), (String)"favorite", (int)0);
        }
        if (this.isExecuting()) {
            return SystemsLabelDecorator.overlay((Image)((Image)anImage), (String)"execute", (int)3);
        }
        return anImage;
    }
}

