/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.history;

import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.history.SystemsTreeNodeTransfer;
import com.ibm.etools.fm.ui.views.systems.nodes.ActionItemNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class ActionHistoryTreeSupport {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static Object dropTarget = null;
    private static List<SystemsTreeNode> draggedObjects = null;

    public static void invokeDoubleClickBehaviour(IActionItem action) {
        Objects.requireNonNull(action, "Must provide a non-null action.");
        if (!action.isExecuting()) {
            if (action.getErrorToolTipText() == null) {
                action.execute();
            } else {
                action.modify();
            }
        }
    }

    public static void addDragAndDrop(TreeViewer tree) {
        if (tree == null) {
            return;
        }
        tree.addDragSupport(1, new Transfer[]{SystemsTreeNodeTransfer.getInstance()}, new DragSourceListener(){

            public void dragFinished(DragSourceEvent e) {
                IActionItem action;
                if (dropTarget != null && dropTarget instanceof ActionItemNode && (action = (IActionItem)((ActionItemNode)((Object)dropTarget)).getDataObject()).isValidInput(draggedObjects)) {
                    action.execute(draggedObjects);
                }
                draggedObjects = null;
                dropTarget = null;
            }

            public void dragSetData(DragSourceEvent e) {
            }

            public void dragStart(DragSourceEvent e) {
                dropTarget = null;
                draggedObjects = new ArrayList<SystemsTreeNode>();
                ISelection selection = FMUIPlugin.getDefault().getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection strucSel = (IStructuredSelection)selection;
                    for (Object next : strucSel) {
                        if (!(next instanceof SystemsTreeNode)) continue;
                        draggedObjects.add((SystemsTreeNode)next);
                    }
                }
            }
        });
        tree.addDropSupport(1, new Transfer[]{SystemsTreeNodeTransfer.getInstance()}, (DropTargetListener)new ViewerDropAdapter((Viewer)tree){
            private int currentLocation = -1;

            public boolean performDrop(Object arg0) {
                return false;
            }

            public boolean validateDrop(Object target, int arg1, TransferData arg2) {
                if (target != null && target instanceof ActionItemNode) {
                    return ((IActionItem)((ActionItemNode)((Object)target)).getDataObject()).isValidInput(draggedObjects);
                }
                return false;
            }

            public void dragOver(DropTargetEvent event) {
                Object target = this.determineTarget(event);
                int oldLocation = this.currentLocation;
                this.currentLocation = this.determineLocation(event);
                if (target != dropTarget && this.currentLocation != oldLocation) {
                    event.detail = this.validateDrop(dropTarget, event.detail, event.currentDataType) ? 1 : 0;
                    dropTarget = target;
                }
                super.dragOver(event);
            }
        });
    }
}

