/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup.factory;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.ui.dialog.lookup.ResourceLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.callback.DefaultOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.callback.DefaultSelectedResourceCallback;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.callback.ISelectedValueFormatter;
import com.ibm.etools.fm.ui.dialog.lookup.filter.DefaultLookupFilter;
import com.ibm.etools.fm.ui.dialog.lookup.filter.ILookupFilterProvider;
import com.ibm.etools.fm.ui.widget.ResourceContentProposals;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import java.util.Objects;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;

public class LookupDialogFactory {
    private final LookupDialogConfig config;

    private LookupDialogFactory(Button b, Combo c, IHostProvider h) {
        this.config = new LookupDialogConfig(b, c, h);
    }

    public LookupDialogFactory noAllocate() {
        this.config.allowAllocate = false;
        return this;
    }

    public LookupDialogFactory allowMultiple() {
        this.config.allowMultipleSystems = true;
        return this;
    }

    public LookupDialogFactory types(Class<?> ... allowableTypes) {
        this.config.allowableTypes = Objects.requireNonNull(allowableTypes, "Must provide a non-null varargs of allowableTypes.");
        return this;
    }

    public LookupDialogFactory filter(ILookupFilterProvider filter) {
        this.config.filter = Objects.requireNonNull(filter, "Must provide a non-null filter.");
        return this;
    }

    public LookupDialogFactory onSelect(IOnSelectionEvent onSelect) {
        this.config.onSelect = Objects.requireNonNull(onSelect, "Must provide a non-null IOnSelectionEvent.");
        return this;
    }

    public LookupDialogFactory formatter(ISelectedValueFormatter formatter) {
        this.config.formatter = Objects.requireNonNull(formatter, "Must provide a non-null ISelectedValueFormatter.");
        return this;
    }

    public LookupDialogFactory addResourceContentProposals(String id) {
        this.config.contentProposalId = Objects.requireNonNull(id);
        return this;
    }

    public LookupDialogFactory addComboValueSaver(String id) {
        this.config.cvsId = Objects.requireNonNull(id);
        return this;
    }

    public static LookupDialogFactory defaults(Button b, Combo c, IHostProvider h) {
        return new LookupDialogFactory(b, c, h);
    }

    public Button create() {
        if (this.config.contentProposalId != null) {
            ResourceContentProposals.addTo(this.config.c, this.config.h, this.config.contentProposalId, this.config.allowableTypes);
        }
        if (this.config.cvsId != null) {
            new ComboValueSaver(this.config.c, this.config.cvsId);
        }
        this.config.b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceLookupDialog dialog = new ResourceLookupDialog(LookupDialogFactory.this.config.h.getSystem(), LookupDialogFactory.this.config.allowMultipleSystems, LookupDialogFactory.this.config.allowableTypes);
                dialog.setAllocateButtonEnabled(LookupDialogFactory.this.config.allowAllocate);
                dialog.setInitialFilter(LookupDialogFactory.this.config.filter.getInitialFilter(LookupDialogFactory.this.config.c));
                if (dialog.open() == 0) {
                    LookupDialogFactory.this.config.b.setFocus();
                    LookupDialogFactory.this.config.onSelect.onResourceSelected(dialog.getSelectedSystem(), dialog.getSelectedResource());
                    LookupDialogFactory.this.config.c.setText(LookupDialogFactory.this.config.formatter.getNewValue(dialog.getSelectedSystem(), dialog.getSelectedResource()));
                }
            }
        });
        return this.config.b;
    }

    private static class LookupDialogConfig {
        private final Button b;
        private final Combo c;
        private final IHostProvider h;
        private Class<?>[] allowableTypes = new Class[]{DataSet.class};
        private ILookupFilterProvider filter = DefaultLookupFilter.INSTANCE;
        private IOnSelectionEvent onSelect = new DefaultOnSelectionEvent();
        private ISelectedValueFormatter formatter = new DefaultSelectedResourceCallback();
        private String contentProposalId = null;
        private boolean allowAllocate = true;
        private boolean allowMultipleSystems = false;
        public String cvsId = null;

        public LookupDialogConfig(Button b, Combo c, IHostProvider h) {
            this.b = Objects.requireNonNull(b, "Must provide a non-null Button.");
            this.c = Objects.requireNonNull(c, "Must provide a non-null Combo.");
            this.h = Objects.requireNonNull(h, "Must provide a non-null IHostProvider.");
        }
    }
}

