/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.ui.views.systems.handlers.AllocateHFSFile;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.dialog.lookup.LookupContentProvider;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;

public class UssContentProvider
extends LookupContentProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final Pattern validPattern = Pattern.compile("\\A/.*\\Z");
    UssFile lastFile = null;
    UssFile currentFile = null;
    Pattern matchPattern = null;

    public static boolean validFor(Object input) {
        if (input instanceof String) {
            String strInput = (String)input;
            return validPattern.matcher(strInput).matches();
        }
        if (input instanceof UssFile) {
            UssFile ussInput = (UssFile)input;
            return ussInput.isDirectory();
        }
        return false;
    }

    public UssContentProvider(IPDHost systemProvider) {
        super(systemProvider);
    }

    public void onInputChange(Object newInput) {
        UssFile input;
        this.codepageTranslator(newInput);
        if (!UssContentProvider.validFor(newInput)) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
        this.currentFile = null;
        if (newInput instanceof String) {
            String input2 = (String)newInput;
            int lastSep = input2.lastIndexOf("/");
            String dir = input2;
            if (lastSep >= 0) {
                dir = input2.substring(0, lastSep + 1);
            }
            if (UssFile.isParseableAbsolutePath((IPDHost)this.getSystem(), (String)dir)) {
                this.currentFile = UssFile.parse((IPDHost)this.getSystem(), (String)dir);
            }
        } else if (newInput instanceof UssFile && (input = (UssFile)newInput).isDirectory()) {
            this.currentFile = input;
        }
        if (this.currentFile == null) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
    }

    public Object getUpLevelInput() {
        if (this.currentFile == null) {
            return null;
        }
        return this.currentFile.getParent();
    }

    public void updateMatcher(String filter) {
        filter = (String)filter + "*";
        filter = StringUtils.escapeRegex((String)filter);
        filter = ((String)filter).replaceAll("\\\\\\*", ".*");
        filter = ((String)filter).replaceAll("%", ".");
        this.matchPattern = Pattern.compile((String)filter, 66);
    }

    public boolean canUseLastViewerData() {
        return this.currentFile != null && this.currentFile.equals((Object)this.lastFile);
    }

    public List<? extends IZRL> reloadData(IHowIsGoing monitor) throws InterruptedException {
        if (this.currentFile == null) {
            return null;
        }
        this.currentFile.loadFiles(monitor, false);
        this.lastFile = this.currentFile;
        return this.currentFile.getFiles();
    }

    public boolean matches(IZRL resource) {
        if (resource == null) {
            return false;
        }
        if (resource instanceof UssFile) {
            if (this.matchPattern == null) {
                throw new IllegalStateException();
            }
            return this.matchPattern.matcher(resource.getFormattedName().toLowerCase()).matches();
        }
        return false;
    }

    public String getJobName() {
        if (this.currentFile == null) {
            return Messages.Invalid_INPUT;
        }
        return MessageFormat.format(Messages.UssContentProvider_LOADING_FILES_IN_X, this.currentFile.getFormattedName());
    }

    public boolean isValidFor(Object input) {
        return UssContentProvider.validFor(input);
    }

    public String getResultStatusInfo() {
        if (this.currentFile == null) {
            return Messages.Invalid_INPUT;
        }
        return MessageFormat.format(Messages.UssContentProvider_SHOWING_FILES_FOR_X, this.currentFile.getFormattedName());
    }

    public Class<?> getType() {
        return UssFile.class;
    }

    public boolean canCreateNewResource() {
        return true;
    }

    public boolean createNewResource(IPDHost host, List<IZRL> selection, String filter) {
        Object newFileName = "/";
        if (!filter.isEmpty()) {
            newFileName = filter;
        } else if (selection.size() > 0 && selection.get(0) instanceof UssFile) {
            newFileName = ((UssFile)selection.get(0)).getFormattedName();
        }
        if (((String)newFileName).endsWith("/")) {
            newFileName = (String)newFileName + "new";
        }
        return AllocateHFSFile.showAllocateHFSFileWizard(host, (String)newFileName);
    }
}

