/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.etools.fm.core.util.FMAssert;
import com.ibm.etools.fm.core.util.WeightedPriorityQueue;
import com.ibm.etools.fm.ui.dialog.lookup.CicsApplIdContentProvider;
import com.ibm.etools.fm.ui.dialog.lookup.CicsFileContentProvider;
import com.ibm.etools.fm.ui.dialog.lookup.CicsTDContentProvider;
import com.ibm.etools.fm.ui.dialog.lookup.CicsTSContentProvider;
import com.ibm.etools.fm.ui.dialog.lookup.DataSetContentProvider;
import com.ibm.etools.fm.ui.dialog.lookup.MQContentProvider;
import com.ibm.etools.fm.ui.dialog.lookup.MQMContentProvider;
import com.ibm.etools.fm.ui.dialog.lookup.MemberContentProvider;
import com.ibm.etools.fm.ui.dialog.lookup.UssContentProvider;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.TypedRunnable;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.dialog.lookup.LookupContentProvider;
import com.ibm.pdtools.common.component.ui.util.ImageLoader;
import com.ibm.pdtools.common.component.ui.views.systems.SorterEBCDIC;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ResourceLookupDialog
extends TrayDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(ResourceLookupDialog.class);
    private static final Class<?>[] DEFAULT_TYPES = new Class[0];
    private static final Class<?>[] VALID_TYPES = new Class[]{DataSet.class, Member.class, MessageQueue.class, MessageQueueManager.class, UssFile.class, CicsAppl.class, CicsFile.class, CicsTransientData.class, CicsTemporaryStorage.class};
    private static final boolean DEFAULT_MULTI_SELECT = false;
    private static final String IMG_KEY_UP = "up";
    private static final String IMG_KEY_BACK = "back";
    private static final String IMG_KEY_REFRESH = "refresh";
    private static final String IMG_KEY_NEW = "menus/allocate";
    private boolean allocateButtonEnabled;
    private String initialFilter = "";
    private IPDHost hostProvider;
    private Set<IPDHost> possibleHosts;
    private List<IZRL> selection = new ArrayList<IZRL>();
    private boolean allowingMultiSelect = false;
    private Stack<LookupContentProvider> pastContent = new Stack();
    private boolean ignoreSelectionChanges = false;
    private boolean queryAllDatasets = false;
    private ImageLoader images = new ImageLoader();
    private ComboViewer wSystemViewer;
    private Combo wType;
    private Combo wFilter;
    private Combo wTextFilter;
    private Button wLoad;
    private Text wStatusLabel;
    private Button wBack;
    private Button wUp;
    private TableViewer wTableViewer;
    private Button wAllocate;
    private Text wSelection;
    private Class<?>[] allowedSelectionTypes = ResourceLookupDialog.getDefaultTypes();
    private LookupContentProvider.StatusUpdater statusUpdater = new LookupContentProvider.StatusUpdater(){

        public void updateStatus(final String statusText) {
            if (PDLoggerJhost.isTraceEnabled()) {
                logger.trace((Object)("Updating status from " + String.valueOf(Thread.currentThread().getStackTrace()[3])));
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if ((this).ResourceLookupDialog.this.wStatusLabel != null && !(this).ResourceLookupDialog.this.wStatusLabel.isDisposed()) {
                        (this).ResourceLookupDialog.this.wStatusLabel.setText(MessageFormat.format(Messages.LookupDialog_STATUS, statusText));
                    }
                }
            });
        }
    };
    private TypedRunnable<List<IZRL>, Void> postFilter = new TypedRunnable<List<IZRL>, Void>(){
        private boolean handlingFilteringComplete = false;

        public Void run(List<IZRL> result) {
            if (this.handlingFilteringComplete) {
                return null;
            }
            this.handlingFilteringComplete = true;
            if (result.size() > 0) {
                ResourceLookupDialog.this.wTableViewer.getTable().select(0);
                ResourceLookupDialog.this.setSelection(Collections.nCopies(1, result.get(0)));
            } else {
                ResourceLookupDialog.this.setSelection(new ArrayList());
            }
            this.handlingFilteringComplete = false;
            return null;
        }
    };
    private LookupContentProvider contentProvider;

    public ResourceLookupDialog(IPDHost hostProvider, Class<?> ... allowedSelectionTypes) {
        this(hostProvider, false, allowedSelectionTypes);
    }

    public ResourceLookupDialog(IPDHost hostProvider, boolean allowSelectionOfOtherHosts, Class<?> ... allowedSelectionTypes) {
        super(Display.getDefault().getActiveShell());
        Objects.requireNonNull(hostProvider, "Must provide a non-null hostProvider");
        this.hostProvider = hostProvider;
        this.setAllowedSelectionTypes(allowedSelectionTypes);
        if (allowSelectionOfOtherHosts) {
            this.possibleHosts = new HashSet<IPDHost>(RegistryLocator.instance().getHostRegistry().all());
        } else {
            this.possibleHosts = new HashSet<IPDHost>();
            this.possibleHosts.add(hostProvider);
        }
        this.allocateButtonEnabled = true;
    }

    public ResourceLookupDialog(IPDHost hostProvider, boolean queryAllDatasets, boolean allowSelectionOfOtherHosts, Class<?> ... allowedSelectionTypes) {
        this(hostProvider, allowSelectionOfOtherHosts, allowedSelectionTypes);
        this.queryAllDatasets = queryAllDatasets;
    }

    public void setInitialFilter(String initialFilter) {
        this.initialFilter = initialFilter;
    }

    public int open() {
        if (this.allowedSelectionTypes == null || this.allowedSelectionTypes.length == 0) {
            logger.error((Object)"No resources marked as allowable selection types - not showing resource lookup dialog!");
            throw new IllegalArgumentException();
        }
        AuthDetails login = null;
        try {
            login = this.hostProvider.getSystem().getLogin(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (login == null) {
            logger.trace((Object)"User didn't provide login details for resource lookup");
            return 1;
        }
        if (this.initialFilter.isEmpty()) {
            this.guessInitialFilter();
        }
        return super.open();
    }

    private static String codepageTranslate(String input, String codepageIn, String codepageOut) {
        try {
            byte[] cpbytes = input.getBytes(codepageIn);
            return new String(cpbytes, codepageOut);
        }
        catch (Exception exception) {
            return input;
        }
    }

    private static char codepageTranslateChar(char input, String codepageIn, String codepageOut) {
        char[] arr = new char[]{input};
        String result = ResourceLookupDialog.codepageTranslate(new String(arr), codepageIn, codepageOut);
        return result.charAt(0);
    }

    private void guessInitialFilter() {
        WeightedPriorityQueue initialFilters = WeightedPriorityQueue.create();
        initialFilters.add((Object)"/", (Comparable)Integer.valueOf(ArrayUtils.findIndexOf(UssFile.class, (Object[])this.allowedSelectionTypes, (int)Integer.MAX_VALUE)));
        initialFilters.add((Object)"MQ:", (Comparable)Integer.valueOf(Math.min(ArrayUtils.findIndexOf(MessageQueueManager.class, (Object[])this.allowedSelectionTypes, (int)Integer.MAX_VALUE), ArrayUtils.findIndexOf(MessageQueue.class, (Object[])this.allowedSelectionTypes, (int)Integer.MAX_VALUE))));
        initialFilters.add((Object)"FI:", (Comparable)Integer.valueOf(Math.min(ArrayUtils.findIndexOf(CicsAppl.class, (Object[])this.allowedSelectionTypes, (int)Integer.MAX_VALUE), ArrayUtils.findIndexOf(CicsFile.class, (Object[])this.allowedSelectionTypes, (int)Integer.MAX_VALUE))));
        initialFilters.add((Object)"TD:", (Comparable)Integer.valueOf(ArrayUtils.findIndexOf(CicsTransientData.class, (Object[])this.allowedSelectionTypes, (int)Integer.MAX_VALUE)));
        initialFilters.add((Object)"TS:", (Comparable)Integer.valueOf(ArrayUtils.findIndexOf(CicsTemporaryStorage.class, (Object[])this.allowedSelectionTypes, (int)Integer.MAX_VALUE)));
        try {
            AuthDetails details = this.hostProvider.getLogin(true);
            String username = details.getUsername();
            if (this.hostProvider.getCodePage() != this.hostProvider.getHostType().getCommunicationEncoding()) {
                try {
                    username = new String(username.getBytes(this.hostProvider.getHostType().getCommunicationEncoding()), this.hostProvider.getCodePage());
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            initialFilters.add((Object)(username + "." + (this.queryAllDatasets ? "**" : "")), (Comparable)Integer.valueOf(Math.min(ArrayUtils.findIndexOf(DataSet.class, (Object[])this.allowedSelectionTypes, (int)Integer.MAX_VALUE), ArrayUtils.findIndexOf(Member.class, (Object[])this.allowedSelectionTypes, (int)Integer.MAX_VALUE))));
            initialFilters.add((Object)(username + "."), (Comparable)Integer.valueOf(0x7FFFFFFE));
        }
        catch (Exception e) {
            logger.trace((Object)"No login available for guessing initial input - adding fallback of empty input");
            initialFilters.add((Object)"*", (Comparable)Integer.valueOf(0x7FFFFFFD));
        }
        this.initialFilter = (String)initialFilters.peek();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.LookupDialog_LOOKUP_RESOURCE);
        ResourceLookupDialog.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)5, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.addSystemLabelCombo(composite);
        GUI.label.left((Composite)composite, (String)Messages.ResourceLookupDialog_TYPE, (Object)GUI.grid.d.left1());
        this.wType = this.doCreateType(composite, 1);
        this.wBack = this.doCreateBackButton(composite, 1);
        this.wUp = this.doCreateUpButton(composite, 1);
        this.wAllocate = this.doCreateAllocateButton(composite, 1);
        GUI.label.left((Composite)composite, (String)Messages.ResourceLookupDialog_QUERY, (Object)GUI.grid.d.left1());
        this.wFilter = this.doCreateFilter(composite, 1);
        this.wLoad = this.doCreateLoadButton(composite, 3);
        GUI.label.left((Composite)composite, (String)Messages.ResourceLookupDialog_FILTER, (Object)GUI.grid.d.left1());
        this.wTextFilter = this.doCreateTextFilter(composite, 1);
        this.wStatusLabel = new Text(composite, 8);
        this.wStatusLabel.setLayoutData((Object)GUI.grid.d.fillH((int)5));
        this.wTableViewer = this.doCreateTableViewer(composite, 5);
        this.wSelection = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)5));
        this.setInitialFilterText();
        this.reloadItemsFromFilter();
        this.updateTypeDisplay();
        return composite;
    }

    private void addSystemLabelCombo(Composite composite) {
        GUI.label.left((Composite)composite, (String)"System:", (Object)GUI.grid.d.left1());
        this.wSystemViewer = new ComboViewer(composite);
        this.wSystemViewer.getCombo().setLayoutData((Object)GUI.grid.d.fillH((int)4));
        if (this.hostProvider.getDelegatingHost() != null && !this.possibleHosts.contains(this.hostProvider)) {
            this.possibleHosts.add(this.hostProvider);
        }
        this.wSystemViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.wSystemViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPDHost) {
                    return ((IPDHost)element).getFullHostName();
                }
                return super.getText(element);
            }
        });
        this.wSystemViewer.setInput(this.possibleHosts);
        this.wSystemViewer.setSelection((ISelection)new StructuredSelection((Object)this.hostProvider));
        this.wSystemViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceLookupDialog.this.hostProvider = (IPDHost)((IStructuredSelection)event.getSelection()).getFirstElement();
                ResourceLookupDialog.this.saveCurrentItem();
                ResourceLookupDialog.this.reloadItemsFromFilter();
                ResourceLookupDialog.this.updateTypeDisplay();
            }
        });
    }

    private Combo doCreateType(Composite composite, int width) {
        Object[] allowedTypes = new String[this.allowedSelectionTypes.length];
        int i = 0;
        while (i < this.allowedSelectionTypes.length) {
            allowedTypes[i] = ResourceLookupDialog.getNameOfType(this.allowedSelectionTypes[i]);
            ++i;
        }
        final Combo typeCombo = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)width), (Object[])allowedTypes);
        typeCombo.setVisibleItemCount(25);
        Listener typeSelectionListener = new Listener(){

            public void handleEvent(Event event) {
                Class<?> selectedType = ResourceLookupDialog.this.allowedSelectionTypes[typeCombo.getSelectionIndex()];
                logger.trace((Object)("Selected type from combo " + String.valueOf(selectedType)));
                ResourceLookupDialog.this.wFilter.setText(ResourceLookupDialog.this.getInputFromType(selectedType));
                int filterLength = ResourceLookupDialog.this.wFilter.getText().length();
                ResourceLookupDialog.this.wFilter.setSelection(new Point(filterLength, filterLength));
                ResourceLookupDialog.this.reloadItemsFromFilter();
                ResourceLookupDialog.this.wAllocate.setEnabled(ResourceLookupDialog.this.contentProvider != null && ResourceLookupDialog.this.contentProvider.canCreateNewResource() && ResourceLookupDialog.this.allocateButtonEnabled);
            }
        };
        typeCombo.addListener(13, typeSelectionListener);
        return typeCombo;
    }

    private String getInputFromType(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.equals(DataSet.class) || clazz.equals(Member.class)) {
            try {
                AuthDetails details = this.hostProvider.getSystem().getLogin(true);
                return details.getUsername() + ".";
            }
            catch (Exception e) {
                return "*";
            }
        }
        if (clazz.equals(MessageQueue.class)) {
            return "MQ:";
        }
        if (clazz.equals(MessageQueueManager.class)) {
            return "MQ:";
        }
        if (clazz.equals(UssFile.class)) {
            return "/";
        }
        if (clazz.equals(CicsFile.class)) {
            return "FI:";
        }
        if (clazz.equals(CicsTransientData.class)) {
            return "TD:";
        }
        if (clazz.equals(CicsTemporaryStorage.class)) {
            return "TS:";
        }
        if (clazz.equals(CicsAppl.class)) {
            return "FI:";
        }
        throw new IllegalArgumentException(clazz.toString());
    }

    public static String getNameOfType(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.equals(DataSet.class)) {
            return Messages.ResourceLookupDialog_DATA_SET;
        }
        if (clazz.equals(Member.class)) {
            return Messages.ResourceLookupDialog_MEMBER;
        }
        if (clazz.equals(MessageQueue.class)) {
            return Messages.ResourceLookupDialog_MQ;
        }
        if (clazz.equals(MessageQueueManager.class)) {
            return Messages.ResourceLookupDialog_MQM;
        }
        if (clazz.equals(UssFile.class)) {
            return Messages.ResourceLookupDialog_USS;
        }
        if (clazz.equals(CicsFile.class)) {
            return Messages.ResourceLookupDialog_CICS_FILE;
        }
        if (clazz.equals(CicsTransientData.class)) {
            return Messages.ResourceLookupDialog_CICS_TD;
        }
        if (clazz.equals(CicsTemporaryStorage.class)) {
            return Messages.ResourceLookupDialog_CICS_TS;
        }
        if (clazz.equals(CicsAppl.class)) {
            return Messages.ResourceLookupDialog_CICS_APP;
        }
        throw new IllegalArgumentException(clazz.toString());
    }

    private Combo doCreateFilter(Composite composite, int width) {
        final Combo filter = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)width));
        Listener filterKeyDownListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x100000F) {
                    ResourceLookupDialog.this.wTableViewer.getTable().setFocus();
                    event.doit = false;
                } else if (event.keyCode == 0x100000E) {
                    ResourceLookupDialog.this.reloadItemsFromFilter();
                    ResourceLookupDialog.this.updateTypeDisplay();
                    event.doit = false;
                }
            }
        };
        filter.addListener(1, filterKeyDownListener);
        Listener filterTraverseListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    event.doit = false;
                    ResourceLookupDialog.this.saveCurrentItem();
                    ResourceLookupDialog.this.reloadItemsFromFilter();
                    ResourceLookupDialog.this.updateTypeDisplay();
                }
            }
        };
        filter.addListener(31, filterTraverseListener);
        Listener filterSelectedListener = new Listener(){

            public void handleEvent(Event event) {
                ResourceLookupDialog.this.saveCurrentItem();
                ResourceLookupDialog.this.reloadItemsFromFilter();
                ResourceLookupDialog.this.updateTypeDisplay();
            }
        };
        filter.addListener(13, filterSelectedListener);
        Listener filterModifyListener = new Listener(){

            public void handleEvent(Event event) {
                String filterText = filter.getText().trim();
                LookupContentProvider tempCP = ResourceLookupDialog.this.createContentProviderFor(filterText, filterText);
                if (ResourceLookupDialog.this.wLoad != null) {
                    ResourceLookupDialog.this.wLoad.setEnabled(tempCP != null);
                }
                ResourceLookupDialog.this.filterItems();
            }
        };
        filter.addListener(24, filterModifyListener);
        filter.setToolTipText(Messages.LookupDialog_TOOLTIP_FILTER);
        new ComboValueSaver(filter, ((Object)((Object)this)).getClass().getCanonicalName() + "Filter");
        return filter;
    }

    private Combo doCreateTextFilter(Composite parent, int width) {
        final Combo textFilter = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)width));
        Listener textFilterTraverseListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    try {
                        textFilter.add(textFilter.getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    event.doit = false;
                }
            }
        };
        textFilter.addListener(31, textFilterTraverseListener);
        Listener textFilterModifyListener = new Listener(){

            public void handleEvent(Event event) {
                ResourceLookupDialog.this.filterItemsByText();
            }
        };
        textFilter.addListener(24, textFilterModifyListener);
        textFilter.setToolTipText(Messages.LookupDialog_TOOLTIP_TEXTFILTER);
        new ComboValueSaver(textFilter, ((Object)((Object)this)).getClass().getCanonicalName() + "TextFilter");
        return textFilter;
    }

    private Button doCreateLoadButton(Composite composite, int width) {
        Button load = GUI.button.push((Composite)composite, (Image)this.images.getImageByName("com.ibm.etools.fm.ui", IMG_KEY_REFRESH), (String)Messages.LookupDialog_TOOLTIP_LOAD, (Object)GUI.grid.d.horiz((int)0x1000000, (boolean)false, (int)width), (boolean)true, (int)64);
        load.setText(Messages.LookupDialog_REFRESH);
        load.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ResourceLookupDialog.this.saveCurrentItem();
                ResourceLookupDialog.this.reloadItemsFromFilter();
                ResourceLookupDialog.this.updateTypeDisplay();
            }
        });
        return load;
    }

    private Button doCreateBackButton(Composite composite, int width) {
        Button back = GUI.button.push((Composite)composite, (Image)this.images.getImageByName("com.ibm.etools.fm.ui", IMG_KEY_BACK), (String)Messages.LookupDialog_TOOLTIP_BACK, (Object)GUI.grid.d.horiz((int)0x1000000, (boolean)false, (int)width), (boolean)true, (int)64);
        back.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ResourceLookupDialog.this.goBackToPreviousItem();
            }
        });
        back.setEnabled(false);
        return back;
    }

    private Button doCreateUpButton(Composite composite, int width) {
        Button up = GUI.button.push((Composite)composite, (Image)this.images.getImageByName("com.ibm.etools.fm.ui", IMG_KEY_UP), (String)Messages.ResourceLookupDialog_UP_TOOLTIP, (Object)GUI.grid.d.horiz((int)0x1000000, (boolean)false, (int)width), (boolean)true, (int)64);
        up.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ResourceLookupDialog.this.goUpItem();
            }
        });
        return up;
    }

    private TableViewer doCreateTableViewer(Composite composite, int width) {
        Table table = new Table(composite, 0x10000000 | (this.allowingMultiSelect ? 2 : 0) | 0x200 | 0x100 | 0x800);
        GridData layoutData = new GridData(4, 4, true, true, width, 1);
        layoutData.widthHint = 400;
        layoutData.heightHint = 300;
        table.setLayoutData((Object)layoutData);
        final TableViewer viewer = new TableViewer(table);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator()));
        viewer.setSorter((ViewerSorter)SorterEBCDIC.getInstance());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionchangedevent) {
                ResourceLookupDialog.this.setSelection(((IStructuredSelection)viewer.getSelection()).toList());
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleclickevent) {
                ResourceLookupDialog.this.goIntoSelectedItem();
            }
        });
        viewer.getTable().addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x1000003) {
                    ResourceLookupDialog.this.goBackToPreviousItem();
                    event.doit = false;
                } else if (event.keyCode == 8) {
                    ResourceLookupDialog.this.goUpItem();
                    event.doit = false;
                } else if (event.keyCode == 0x1000004) {
                    ResourceLookupDialog.this.goIntoSelectedItem();
                    event.doit = false;
                } else if (event.keyCode == 0x1000012) {
                    ResourceLookupDialog.this.wTextFilter.setFocus();
                    event.doit = false;
                } else if (event.keyCode == 0x100000F) {
                    ResourceLookupDialog.this.wFilter.setFocus();
                    int filterLength = ResourceLookupDialog.this.wFilter.getText().length();
                    ResourceLookupDialog.this.wFilter.setSelection(new Point(filterLength, filterLength));
                    event.doit = false;
                } else if (event.keyCode == 0x100000E) {
                    ResourceLookupDialog.this.reloadItemsFromFilter();
                    ResourceLookupDialog.this.updateTypeDisplay();
                    event.doit = false;
                }
            }
        });
        viewer.getTable().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 4) {
                    ResourceLookupDialog.this.goIntoSelectedItem();
                    event.doit = false;
                }
            }
        });
        return viewer;
    }

    private Button doCreateAllocateButton(Composite composite, int width) {
        Button allocate = GUI.button.push((Composite)composite, (Image)this.images.getImageByName("com.ibm.etools.fm.ui", IMG_KEY_NEW), (String)Messages.LookupDialog_NEW_RESOURCE, (Object)GUI.grid.d.horiz((int)0x1000000, (boolean)false, (int)width), (boolean)true, (int)64);
        allocate.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String input = ResourceLookupDialog.this.wFilter.getText();
                IPDHost host = ResourceLookupDialog.this.hostProvider.getSystem();
                if (ResourceLookupDialog.this.contentProvider != null && ResourceLookupDialog.this.contentProvider.createNewResource(host, ResourceLookupDialog.this.selection, input)) {
                    ResourceLookupDialog.this.reloadItemsFromFilter();
                    ResourceLookupDialog.this.updateTypeDisplay();
                }
            }
        });
        return allocate;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttons = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        this.setSelection(new ArrayList());
        return buttons;
    }

    private void setInitialFilterText() {
        this.wFilter.setText(this.initialFilter);
        int filterLength = this.wFilter.getText().length();
        this.wFilter.setSelection(new Point(filterLength, filterLength));
    }

    private void updateTypeDisplay() {
        int chosenTypeIndex = -1;
        if (this.contentProvider != null) {
            Class cpType = this.contentProvider.getType();
            int i = 0;
            while (i < this.allowedSelectionTypes.length) {
                if (this.allowedSelectionTypes[i].equals(cpType)) {
                    chosenTypeIndex = i;
                    logger.trace((Object)("Chose type " + String.valueOf(this.allowedSelectionTypes[i])));
                }
                ++i;
            }
        }
        String filter = this.wFilter.getText().toUpperCase();
        if (chosenTypeIndex == -1 && ArrayUtils.findIndexOf(MessageQueueManager.class, (Object[])this.allowedSelectionTypes, (int)-1) == -1 && filter.startsWith("MQ:")) {
            chosenTypeIndex = ArrayUtils.findIndexOf(MessageQueue.class, (Object[])this.allowedSelectionTypes, (int)-1);
        }
        if (chosenTypeIndex == -1 && ArrayUtils.findIndexOf(CicsAppl.class, (Object[])this.allowedSelectionTypes, (int)-1) == -1) {
            if (filter.startsWith("FI:")) {
                chosenTypeIndex = ArrayUtils.findIndexOf(CicsFile.class, (Object[])this.allowedSelectionTypes, (int)-1);
            } else if (filter.startsWith("TD:")) {
                chosenTypeIndex = ArrayUtils.findIndexOf(CicsTransientData.class, (Object[])this.allowedSelectionTypes, (int)-1);
            } else if (filter.startsWith("TS:")) {
                chosenTypeIndex = ArrayUtils.findIndexOf(CicsTemporaryStorage.class, (Object[])this.allowedSelectionTypes, (int)-1);
            }
        }
        if (chosenTypeIndex == -1 && ArrayUtils.findIndexOf(DataSet.class, (Object[])this.allowedSelectionTypes, (int)-1) == -1) {
            chosenTypeIndex = ArrayUtils.findIndexOf(Member.class, (Object[])this.allowedSelectionTypes, (int)-1);
        }
        if (chosenTypeIndex >= 0) {
            this.wType.select(chosenTypeIndex);
            if (this.contentProvider != null) {
                this.wAllocate.setEnabled(this.contentProvider.canCreateNewResource() && this.allocateButtonEnabled);
            }
        } else {
            logger.trace((Object)"Updating type display to empty");
            this.wType.setText("");
            this.wAllocate.setEnabled(false);
        }
    }

    private void reloadItemsFromFilter() {
        String filter = this.wFilter.getText().trim();
        this.contentProvider = this.createContentProviderFor(filter, filter);
        if (this.contentProvider != null) {
            this.contentProvider.setFilter(filter);
            if (this.wTableViewer.getContentProvider() != null) {
                this.wTableViewer.setInput(null);
            }
            this.wTableViewer.setContentProvider((IContentProvider)this.contentProvider);
            this.wTableViewer.setInput((Object)filter);
            this.wUp.setEnabled(this.contentProvider.getUpLevelInput() != null);
        } else {
            this.statusUpdater.updateStatus(MessageFormat.format(Messages.LookupDialog_INVALID_INPUT_X, filter));
            this.wAllocate.setEnabled(false);
            this.wUp.setEnabled(false);
        }
    }

    private LookupContentProvider createContentProviderFor(Object input, String filter) {
        LookupContentProvider provider = null;
        if (filter == null) {
            filter = input.toString();
        }
        if (input instanceof String && !this.hostProvider.getCodePage().equals(HostType.ZOS.getCommunicationEncoding())) {
            StringBuilder sb = new StringBuilder((String)input);
            int i = 0;
            while (i < sb.length()) {
                if (!sb.substring(i, i + 1).matches("[_%:\\/\\.\\*\\^&={}\\+]")) {
                    sb.setCharAt(i, ResourceLookupDialog.codepageTranslateChar(sb.charAt(i), this.hostProvider.getCodePage(), HostType.ZOS.getCommunicationEncoding()));
                }
                ++i;
            }
            input = sb.toString();
        }
        if (MemberContentProvider.validFor(input)) {
            provider = new MemberContentProvider(this.hostProvider);
        } else if (MQContentProvider.validFor(input)) {
            provider = new MQContentProvider(this.hostProvider);
        } else if (MQMContentProvider.validFor(input)) {
            provider = new MQMContentProvider(this.hostProvider);
        } else if (DataSetContentProvider.validFor(input)) {
            provider = new DataSetContentProvider(this.hostProvider);
        } else if (UssContentProvider.validFor(input)) {
            provider = new UssContentProvider(this.hostProvider);
        } else if (CicsApplIdContentProvider.validFor(input)) {
            provider = new CicsApplIdContentProvider(this.hostProvider);
        } else if (CicsFileContentProvider.validFor(input) && filter.toUpperCase().startsWith("FI:")) {
            provider = new CicsFileContentProvider(this.hostProvider);
        } else if (CicsTDContentProvider.validFor(input) && filter.toUpperCase().startsWith("TD:")) {
            provider = new CicsTDContentProvider(this.hostProvider);
        } else if (CicsTSContentProvider.validFor(input) && filter.toUpperCase().startsWith("TS:")) {
            provider = new CicsTSContentProvider(this.hostProvider);
        }
        if (provider != null) {
            provider.setAfterFilter(this.postFilter);
            provider.setStatusUpdater(this.statusUpdater);
        }
        return provider;
    }

    private void filterItems() {
        if (this.contentProvider != null) {
            this.contentProvider.setFilter(this.wFilter.getText().trim());
            this.contentProvider.filterData();
        }
    }

    private void filterItemsByText() {
        if (this.contentProvider != null) {
            this.contentProvider.setTextFilter(StringUtils.makeFilterRegExp((String)this.wTextFilter.getText()));
            this.contentProvider.filterData();
        }
    }

    private void goIntoSelectedItem() {
        if (this.selection.size() != 1) {
            logger.debug((Object)("Can't go into with this many items selected: " + this.selection.size()));
            return;
        }
        boolean inputActivated = this.activateInput(this.selection.get(0));
        if (!inputActivated && this.getButton(0).isEnabled()) {
            this.okPressed();
        }
    }

    private boolean activateInput(Object newInput) {
        String filterText = this.wFilter.getText().trim();
        LookupContentProvider newCP = this.createContentProviderFor(newInput, filterText);
        if (newCP == null) {
            return false;
        }
        logger.debug((Object)("Activating input " + String.valueOf(newInput)));
        this.saveCurrentItem();
        this.contentProvider = newCP;
        if (newInput instanceof CicsAppl) {
            String prefix = CicsApplIdContentProvider.getPrefix(filterText);
            this.wFilter.setText(prefix + ((CicsAppl)newInput).getName() + ":");
        } else if (newInput instanceof IZRL) {
            this.wFilter.setText(((IZRL)newInput).getFormattedName());
        } else if (newInput instanceof String) {
            this.wFilter.setText((String)newInput);
        }
        this.contentProvider.setFilter(this.wFilter.getText().trim());
        if (this.wTableViewer.getContentProvider() != null) {
            this.wTableViewer.setInput(null);
        }
        this.wTableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.wTableViewer.setInput(newInput);
        this.wUp.setEnabled(this.contentProvider.getUpLevelInput() != null);
        this.updateTypeDisplay();
        return true;
    }

    private void saveCurrentItem() {
        if (this.contentProvider != null && this.contentProvider.getInput() != null) {
            this.pastContent.push(this.contentProvider);
            this.updateBackButton();
        }
    }

    private void updateBackButton() {
        this.wBack.setEnabled(this.pastContent.size() > 0);
        if (this.pastContent.size() > 0) {
            this.wBack.setToolTipText(this.pastContent.peek().getInput().toString());
        }
    }

    private void goUpItem() {
        if (this.contentProvider != null) {
            logger.debug((Object)"Can't go up an item without a content provider");
        }
        Object newInput = this.contentProvider.getUpLevelInput();
        this.activateInput(newInput);
    }

    private void goBackToPreviousItem() {
        if (this.pastContent.isEmpty()) {
            return;
        }
        if (logger.debug()) {
            logger.debug(new Object[]{"Popping, stack = ", this.pastContent});
        }
        LookupContentProvider previousCP = this.pastContent.pop();
        this.updateBackButton();
        Object previousInput = previousCP.getInput();
        if (this.wTableViewer.getContentProvider() != null) {
            this.wTableViewer.setInput(null);
        }
        this.wTableViewer.setContentProvider((IContentProvider)previousCP);
        this.contentProvider = previousCP;
        this.wTableViewer.setInput(previousInput);
        this.wUp.setEnabled(this.contentProvider.getUpLevelInput() != null);
        if (previousInput != null) {
            String filter;
            if (previousInput instanceof IZRL) {
                filter = ((IZRL)previousInput).getFormattedName();
            } else if (previousInput instanceof String) {
                filter = (String)previousInput;
            } else {
                filter = "";
                logger.error((Object)("Unknown input: " + String.valueOf(previousInput)));
            }
            logger.trace((Object)("Setting filter to last input: " + String.valueOf(previousInput)));
            this.wFilter.setText(filter);
            int filterLength = this.wFilter.getText().length();
            this.wFilter.setSelection(new Point(filterLength, filterLength));
        }
        this.filterItems();
        this.wTableViewer.refresh();
        this.statusUpdater.updateStatus(previousCP.getResultStatusInfo());
    }

    protected void okPressed() {
        this.ignoreSelectionChanges = true;
        logger.trace(new Object[]{"OK press, selection is now ", this.selection});
        super.okPressed();
    }

    public void setHostProvider(IPDHost hostProvider) {
        this.hostProvider = hostProvider;
    }

    public IPDHost getSelectedSystem() {
        return this.hostProvider;
    }

    private void setSelection(List<?> newSelection) {
        if (this.ignoreSelectionChanges) {
            return;
        }
        this.selection.clear();
        if (newSelection != null) {
            for (Object selItem : newSelection) {
                if (!(selItem instanceof IZRL)) continue;
                this.selection.add((IZRL)selItem);
            }
        }
        if (this.selection.size() > 0) {
            StringBuilder selectedTextSb = new StringBuilder();
            int i = 0;
            while (i < this.selection.size()) {
                if (i > 0) {
                    selectedTextSb.append(", ");
                }
                selectedTextSb.append(this.selection.get(i).getName());
                ++i;
            }
            this.wSelection.setText(MessageFormat.format(Messages.LookupDialog_SELECTED_X, selectedTextSb.toString()));
            this.wSelection.getParent().layout(true);
        } else {
            this.wSelection.setText(Messages.LookupDialog_NOTHING_SELECTED);
        }
        boolean validTypesSelected = true;
        boolean dataSetsSelected = false;
        for (IZRL selItem : this.selection) {
            validTypesSelected = validTypesSelected && this.isAllowedToBeSelected(selItem.getClass());
            boolean bl = dataSetsSelected = dataSetsSelected || selItem instanceof DataSet;
        }
        boolean correctAmountSelected = this.allowingMultiSelect ? this.selection.size() >= 1 : this.selection.size() == 1;
        this.getButton(0).setEnabled(validTypesSelected && correctAmountSelected);
    }

    public List<IZRL> getSelection() {
        return this.selection;
    }

    public IZRL getSelectedResource() {
        if (this.selection.isEmpty()) {
            return null;
        }
        return this.selection.get(0);
    }

    protected boolean isResizable() {
        return true;
    }

    private boolean isAllowedToBeSelected(Class<? extends IZRL> type) {
        int i = 0;
        while (i < this.allowedSelectionTypes.length) {
            if (this.allowedSelectionTypes[i].isAssignableFrom(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isAllowingMultiSelect() {
        return this.allowingMultiSelect;
    }

    public void setAllowingMultiSelect(boolean allowingMultiSelect) {
        this.allowingMultiSelect = allowingMultiSelect;
    }

    public void setAllowedSelectionTypes(Class<?>[] allowedSelectionTypes) {
        FMAssert.assertNotEmpty((Object[])allowedSelectionTypes);
        FMAssert.assertItemsInArray((Object[])allowedSelectionTypes, (Object[])ResourceLookupDialog.getValidTypes());
        this.allowedSelectionTypes = Arrays.asList(allowedSelectionTypes).toArray(new Class[0]);
    }

    public void setAllocateButtonEnabled(boolean enabled) {
        this.allocateButtonEnabled = enabled;
    }

    public boolean close() {
        this.images.dispose();
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
        return super.close();
    }

    public static boolean isDefaultMultiSelect() {
        return false;
    }

    public static Class<?>[] getDefaultTypes() {
        return DEFAULT_TYPES;
    }

    public static Class<?>[] getValidTypes() {
        return VALID_TYPES;
    }
}

