/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.ui.dialog.lookup.DataSetContentProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.dialog.lookup.LookupContentProvider;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;

public class MemberContentProvider
extends LookupContentProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final Pattern validPattern = Pattern.compile("\\A[a-zA-Z#@$][a-zA-Z0-9#@$-]{0,7}\\(([-!@#$%\ufffd&*_=+{}A-Z0-9]{1,8})?\\)?\\Z");
    DataSet lastDataSet = null;
    Pattern matchPattern = null;
    private DataSet currentDataSet;

    public static boolean validFor(Object input) {
        if (input instanceof DataSet) {
            DataSet dsInput = (DataSet)input;
            return dsInput.getHasMembers();
        }
        if (input instanceof String) {
            String strInput = (String)input;
            return validPattern.matcher(strInput.toUpperCase()).matches();
        }
        return false;
    }

    public MemberContentProvider(IPDHost systemProvider) {
        super(systemProvider);
    }

    public void onInputChange(Object newInput) {
        this.codepageTranslator(newInput);
        if (!MemberContentProvider.validFor(newInput)) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
        this.currentDataSet = null;
        if (newInput instanceof String) {
            String input = (String)newInput;
            int bracketPos = input.indexOf("(");
            if (bracketPos >= 0 && DataSet.isValidName((String)input.substring(0, bracketPos), (String)this.getSystem().getCodePage())) {
                this.currentDataSet = DataSet.create((IPDHost)this.getSystem(), (String)input.substring(0, bracketPos));
            }
        } else if (newInput instanceof DataSet) {
            this.currentDataSet = (DataSet)newInput;
        }
        if (this.currentDataSet == null) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
    }

    public Object getUpLevelInput() {
        if (this.currentDataSet == null) {
            return null;
        }
        return DataSetContentProvider.stripLastQualifier(this.currentDataSet.getFormattedName());
    }

    public void updateMatcher(String filter) {
        if (((String)filter).length() >= 0) {
            int memberEndPos = ((String)filter).indexOf(")");
            filter = memberEndPos == -1 ? (String)filter + "*" : ((String)filter).substring(0, memberEndPos + 1);
            filter = StringUtils.escapeRegex((String)filter);
            filter = ((String)filter).replaceAll("\\\\\\*", ".*");
            filter = ((String)filter).replaceAll("%", ".");
        } else {
            filter = ".*";
        }
        this.matchPattern = Pattern.compile(((String)filter).toUpperCase());
    }

    public boolean canUseLastViewerData() {
        return this.currentDataSet != null && this.currentDataSet.equals((Object)this.lastDataSet);
    }

    public List<? extends IZRL> reloadData(IHowIsGoing monitor) throws InterruptedException {
        if (this.currentDataSet == null) {
            return null;
        }
        if (this.currentDataSet.getHasMembers() || this.currentDataSet.getType() == DataSetType.UNKNOWN) {
            this.currentDataSet.refreshSelf(monitor);
        }
        this.lastDataSet = this.currentDataSet;
        return this.currentDataSet.getMembers();
    }

    public boolean matches(IZRL resource) {
        if (resource == null) {
            return false;
        }
        if (resource instanceof Member) {
            if (this.matchPattern == null) {
                throw new IllegalStateException();
            }
            return this.matchPattern.matcher(resource.getFormattedName().toUpperCase()).matches();
        }
        return false;
    }

    public String getJobName() {
        if (this.currentDataSet == null) {
            return Messages.Invalid_INPUT;
        }
        return MessageFormat.format(Messages.MemberContentProvider_LOADING_MEMBERS_OF, this.currentDataSet.getFormattedName());
    }

    public boolean isValidFor(Object input) {
        return MemberContentProvider.validFor(input);
    }

    public String getResultStatusInfo() {
        if (this.currentDataSet == null) {
            return Messages.Invalid_INPUT;
        }
        return MessageFormat.format(Messages.MemberContentProvider_SHOWING_MEMBERS_FOR_X, this.currentDataSet.getFormattedName());
    }

    public Class<?> getType() {
        return Member.class;
    }
}

