/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.MessageQueueManagerQuery;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.dialog.lookup.LookupContentProvider;
import java.util.List;
import java.util.regex.Pattern;

public class MQMContentProvider
extends LookupContentProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final Pattern validPattern = Pattern.compile("\\AMQ:[^:]*\\Z", 2);
    private MessageQueueManagerQuery currentQuery = null;
    private Pattern matchPattern = null;

    public static boolean validFor(Object input) {
        if (input instanceof String) {
            String strInput = (String)input;
            return validPattern.matcher(strInput).matches();
        }
        return false;
    }

    public MQMContentProvider(IPDHost systemProvider) {
        super(systemProvider);
    }

    public void onInputChange(Object newInput) {
        this.codepageTranslator(newInput);
        if (!MQMContentProvider.validFor(newInput)) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
        this.currentQuery = null;
        if (!(newInput instanceof String)) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
        this.currentQuery = new MessageQueueManagerQuery(this.getSystem());
    }

    public Object getUpLevelInput() {
        return "MQ:";
    }

    public void updateMatcher(String filter) {
        filter = (String)filter + "*";
        filter = StringUtils.escapeRegex((String)filter);
        filter = ((String)filter).replaceAll("\\\\\\*", ".*");
        filter = ((String)filter).replaceAll("%", ".");
        this.matchPattern = Pattern.compile((String)filter, 66);
    }

    public boolean canUseLastViewerData() {
        return true;
    }

    public List<? extends IZRL> reloadData(IHowIsGoing monitor) throws InterruptedException {
        if (this.currentQuery == null) {
            return null;
        }
        this.currentQuery.loadMessageQueueManagers(monitor, false);
        return this.currentQuery.getMessageQueueManagers();
    }

    public boolean matches(IZRL resource) {
        if (resource == null) {
            return false;
        }
        if (resource instanceof MessageQueueManager) {
            if (this.matchPattern == null) {
                throw new IllegalStateException();
            }
            return this.matchPattern.matcher(resource.getFormattedName()).matches();
        }
        return false;
    }

    public String getJobName() {
        return Messages.MQMContentProvider_LOADING_MQMS;
    }

    public boolean isValidFor(Object input) {
        return MQMContentProvider.validFor(input);
    }

    public String getResultStatusInfo() {
        if (this.currentQuery == null) {
            return Messages.Invalid_INPUT;
        }
        return Messages.MQMContentProvider_SHOWING_ALL_MQMS;
    }

    public Class<?> getType() {
        return MessageQueueManager.class;
    }
}

