/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.MessageQueueQuery;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.dialog.lookup.LookupContentProvider;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;

public class MQContentProvider
extends LookupContentProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final Pattern validPattern = Pattern.compile("\\AMQ:[A-Za-z\\d\\_\\%\\/\\.]{1,48}:.*\\Z", 2);
    private MessageQueueQuery lastQuery = null;
    private Pattern matchPattern = null;
    private MessageQueueQuery currentQuery = null;

    public static boolean validFor(Object input) {
        if (input instanceof String) {
            String strInput = (String)input;
            return validPattern.matcher(strInput).matches();
        }
        return input instanceof MessageQueueManager;
    }

    public MQContentProvider(IPDHost systemProvider) {
        super(systemProvider);
    }

    public void onInputChange(Object newInput) {
        this.codepageTranslator(newInput);
        if (!MQContentProvider.validFor(newInput)) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
        this.currentQuery = null;
        if (newInput instanceof String) {
            String input = (String)newInput;
            int mqmPrefixPos = input.toUpperCase().indexOf("MQ:");
            int mqPrefixPos = input.toUpperCase().indexOf(":", mqmPrefixPos + "MQ:".length());
            if (mqmPrefixPos >= 0 && mqPrefixPos >= 0) {
                String mqmName = input.substring(mqmPrefixPos + "MQ:".length(), mqPrefixPos);
                if (MessageQueueManager.isValidName((IPDHost)this.getSystem(), (String)mqmName)) {
                    MessageQueueManager mqm = MessageQueueManager.create((IPDHost)this.getSystem(), (String)mqmName);
                    this.currentQuery = MessageQueueQuery.create((MessageQueueManager)mqm, (String)"*");
                }
            }
        } else if (newInput instanceof MessageQueueManager) {
            this.currentQuery = MessageQueueQuery.create((MessageQueueManager)((MessageQueueManager)newInput), (String)"*");
        }
        if (this.currentQuery == null) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
    }

    public Object getUpLevelInput() {
        return "MQ:";
    }

    public void updateMatcher(String filter) {
        filter = (String)filter + "*";
        filter = StringUtils.escapeRegex((String)filter);
        filter = ((String)filter).replaceAll("\\\\\\*", ".*");
        filter = ((String)filter).replaceAll("%", ".");
        this.matchPattern = Pattern.compile((String)filter, 66);
    }

    public boolean canUseLastViewerData() {
        return this.currentQuery != null && this.currentQuery.equals((Object)this.lastQuery);
    }

    public List<? extends IZRL> reloadData(IHowIsGoing monitor) throws InterruptedException {
        if (this.currentQuery == null) {
            return null;
        }
        this.currentQuery.loadMessageQueues(monitor, false);
        this.lastQuery = this.currentQuery;
        return this.currentQuery.getMessageQueues();
    }

    public boolean matches(IZRL resource) {
        if (resource == null) {
            return false;
        }
        if (resource instanceof MessageQueue) {
            if (this.matchPattern == null) {
                throw new IllegalStateException();
            }
            return this.matchPattern.matcher(resource.getFormattedName()).matches();
        }
        return false;
    }

    public String getJobName() {
        if (this.currentQuery == null) {
            return Messages.Invalid_INPUT;
        }
        return MessageFormat.format(Messages.MQContentProvider_LOADING_MESSAGE_QUEUES_OF_X, this.currentQuery.getMQManager().getName());
    }

    public boolean isValidFor(Object input) {
        return MQContentProvider.validFor(input);
    }

    public String getResultStatusInfo() {
        if (this.currentQuery == null) {
            return Messages.Invalid_INPUT;
        }
        return MessageFormat.format(Messages.MQContentProvider_SHOWING_RESULTS, this.currentQuery.getMQManager().getName());
    }

    public Class<?> getType() {
        return MessageQueue.class;
    }
}

