/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemQuery;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.FastSortLookupDialog;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class ImsSubsystemLookupDialog
extends FastSortLookupDialog<ImsSubsystemConfig> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String[] subsystemLookupColumnNames = new String[]{Messages.ImsSubsystemLookupDialog_SSID, Messages.ImsSubsystemLookupDialog_Description};
    private static final String[] subsystemLabelList = new String[]{Messages.ImsSubsystemLookupDialog_SSID_};

    public ImsSubsystemLookupDialog(IPDHost system) {
        this(Objects.requireNonNull(system, "Must provide a non-null system."), new String[]{""});
    }

    public ImsSubsystemLookupDialog(final IPDHost system, String[] initialPatternList) {
        super(subsystemLabelList, subsystemLookupColumnNames, new String[subsystemLabelList.length], ImsSubsystemConfig.class);
        Objects.requireNonNull(system, "Must provide a non-null system.");
        ContentLoader.ICallableWithProgress itemProvider = new ContentLoader.ICallableWithProgress<List<?>>(){

            public List<?> call(IHowIsGoing monitor) throws InterruptedException {
                ImsSubsystemQuery query = ImsSubsystemQuery.createForHost((IPDHost)system);
                Result result = query.loadSubsystems(monitor);
                if (result.isSuccessfulWithoutWarnings()) {
                    return query.getSubsystems();
                }
                return Arrays.asList(Messages.ImsSubsystemLookupDialog_ErrorLoadingSubsystems);
            }
        };
        this.setItemProvider(itemProvider);
        this.setTooltipList(new String[]{Messages.ImsSubsystemLookupDialog_ssidTooltip});
        this.setInitialPatternList(initialPatternList);
    }

    protected ViewerFilter[] getFilters() {
        return new ViewerFilter[]{new SubsystemViewerFilter()};
    }

    protected String getDialogName() {
        return Messages.ImsSubsystemLookupDialog_LookupIMSSubsystem;
    }

    public String getColumnText(Object item, int index) {
        return ImsSubsystemLookupDialog.getTableProperty(item, index);
    }

    private static String getTableProperty(Object element, int columnIndex) {
        if (element instanceof ImsSubsystemConfig) {
            ImsSubsystemConfig config = (ImsSubsystemConfig)element;
            switch (columnIndex) {
                case 0: {
                    return config.getSubsystem().getSubsystemID();
                }
                case 1: {
                    return config.getDescription();
                }
            }
        } else if (element instanceof String && columnIndex == 0) {
            return (String)element;
        }
        return "";
    }

    public DecoratingLabelProvider getLabelProvider() {
        return new ImsSubsystemDecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator());
    }

    public static ImsSubsystemConfig promptForValidConfig(IPDHost host, ImsSubsystemConfig selectedConfig) {
        Objects.requireNonNull(host, "Must provide a non-null host.");
        while (selectedConfig == null || !selectedConfig.isConnectable()) {
            ImsSubsystemLookupDialog lookupDialog;
            if (selectedConfig != null) {
                PDDialogs.openInfoThreadSafe((String)Messages.ImsSubsystemLookupDialog_ErrorNotConnectable, (String)MessageFormat.format(Messages.ImsSubsystemLookupDialog_ErrorSubNotConnectable, selectedConfig.getLabel()));
            }
            if ((lookupDialog = new ImsSubsystemLookupDialog(host)).open() != 0) {
                logger.trace((Object)"User cancelled selecting an IMS subsystem");
                return null;
            }
            selectedConfig = (ImsSubsystemConfig)lookupDialog.getFirstSelectedObject();
        }
        ((FMHost)FMHost.getSystem((IPDHost)host)).saveImsCanonicalConfig(selectedConfig);
        return selectedConfig;
    }

    protected boolean isSelectable(Object obj) {
        return obj instanceof ImsSubsystemConfig;
    }

    protected String getSelectedName(ImsSubsystemConfig item) {
        return item.getSubsystem().getSubsystemID() + ": " + item.getDescription();
    }

    protected static class ImsSubsystemDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public ImsSubsystemDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof ImsSubsystemConfig) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof String)) {
                return ImsSubsystemLookupDialog.getTableProperty(element, columnIndex);
            }
            if (columnIndex == 0) {
                return (String)element;
            }
            return null;
        }
    }

    private static class SubsystemViewerFilter
    extends ViewerFilter {
        private SubsystemViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ImsSubsystemConfig && parentElement instanceof PatternState) {
                ImsSubsystemConfig subsystem = (ImsSubsystemConfig)element;
                PatternState input = (PatternState)parentElement;
                return ImsSubsystemLookupDialog.matchEscapedRegex((String)input.getPatternList()[0], (String)subsystem.getSubsystem().getSubsystemID());
            }
            return true;
        }
    }
}

