/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.FastSortLookupDialog;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class ImsPsbLookupDialog
extends FastSortLookupDialog<ImsPsb> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String[] psbLookupColumnNames = new String[]{Messages.ImsPsbLookupDialog_PSB + "           "};
    private static final String[] psbLabelList = new String[]{Messages.ImsPsbLookupDialog_PSB_};
    private final ImsRegionType regionType;
    private final ImsAccessMode accessMode;

    public ImsPsbLookupDialog(IPDHost system, ImsSubsystemConfig imsSubsystemConfig, String filter, ImsRegionType regionType, ImsAccessMode accessMode) {
        String[] stringArray;
        if (Objects.requireNonNull(filter, "Must provide a non-null filter.").isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = filter;
        }
        this(system, stringArray, imsSubsystemConfig, "*", regionType, accessMode);
    }

    public ImsPsbLookupDialog(IPDHost system, String[] initialPatternList, final ImsSubsystemConfig imsSubsystemConfig, final String filter, final ImsRegionType regionType, final ImsAccessMode accessMode) {
        super(psbLabelList, psbLookupColumnNames, new String[psbLabelList.length], ImsPsb.class);
        this.regionType = regionType;
        this.accessMode = accessMode;
        ContentLoader.ICallableWithProgress itemProvider = new ContentLoader.ICallableWithProgress<List<?>>(){

            public List<?> call(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                return ImsPsb.loadPSBs((ImsPsbQuery)new ImsPsbQuery(imsSubsystemConfig.getSubsystem(), filter, regionType, accessMode), (IHowIsGoing)monitor);
            }
        };
        this.setItemProvider(itemProvider);
        this.setTooltipList(new String[]{Messages.ImsPsbLookupDialog_PSBTooltip});
        this.setInitialPatternList(initialPatternList);
    }

    protected ViewerFilter[] getFilters() {
        return new ViewerFilter[]{new SubsystemViewerFilter()};
    }

    protected String getDialogName() {
        return Messages.ImsPsbLookupDialog_selectPSB;
    }

    public String getColumnText(Object item, int index) {
        return ImsPsbLookupDialog.getTableProperty(item, index);
    }

    private static String getTableProperty(Object element, int columnIndex) {
        if (element instanceof ImsPsb) {
            ImsPsb psb = (ImsPsb)element;
            return psb.getName();
        }
        if (element instanceof String && columnIndex == 0) {
            return (String)element;
        }
        return "";
    }

    public DecoratingLabelProvider getLabelProvider() {
        return new ImsPsbDecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator());
    }

    public static ImsPsb promptForValidPsb(IPDHost host, ImsSubsystemConfig imsSubsystemConfig, String filter, ImsRegionType regionType, ImsAccessMode accessMode) {
        Objects.requireNonNull(filter, "Must provide a non-null filter.");
        ImsPsb psb = null;
        while (psb == null || psb.getName().isEmpty()) {
            ImsPsbLookupDialog lookupDialog = new ImsPsbLookupDialog(host, imsSubsystemConfig, filter, regionType, accessMode);
            if (lookupDialog.open() != 0) {
                return null;
            }
            psb = (ImsPsb)lookupDialog.getFirstSelectedObject();
        }
        return psb;
    }

    protected boolean isSelectable(Object obj) {
        return obj instanceof ImsPsb;
    }

    protected String getSelectedName(ImsPsb item) {
        return item.getName();
    }

    protected static class ImsPsbDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public ImsPsbDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof ImsPsb) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof String)) {
                return ImsPsbLookupDialog.getTableProperty(element, columnIndex);
            }
            if (columnIndex == 0) {
                return (String)element;
            }
            return null;
        }
    }

    private static class SubsystemViewerFilter
    extends ViewerFilter {
        private SubsystemViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ImsPsb && parentElement instanceof PatternState) {
                ImsPsb psb = (ImsPsb)element;
                PatternState input = (PatternState)parentElement;
                return ImsPsbLookupDialog.matchEscapedRegex((String)input.getPatternList()[0], (String)psb.getName());
            }
            return true;
        }
    }
}

