/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsRegionConfig;
import com.ibm.etools.fm.ui.views.systems.model.ImsTreeContent;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.FastSortLookupDialog;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImsPcbLookupDialog
extends FastSortLookupDialog<ImsPcb> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String[] pcbLookupColumnNames = new String[]{Messages.ImsPcbLookupDialog_PCBNUM, Messages.ImsPcbLookupDialog_PCBName, Messages.ImsPcbLookupDialog_DBName, Messages.ImsPcbLookupDialog_Note, Messages.ImsPcbLookupDialog_SegsInPCB, Messages.ImsPcbLookupDialog_SegsInDBD, Messages.ImsPcbLookupDialog_DBType, Messages.ImsPcbLookupDialog_procOpts, Messages.ImsPcbLookupDialog_ProcSeq};
    private static final String[] pcbLabelList = new String[]{Messages.ImsPcbLookupDialog_PCB, Messages.ImsPcbLookupDialog_Database};

    public ImsPcbLookupDialog(IPDHost system, final List<ImsPcb> pcbs) {
        super(pcbLabelList, pcbLookupColumnNames, new String[pcbLabelList.length], ImsPcb.class);
        this.setItemProvider(new ContentLoader.ICallableWithProgress<List<?>>(){

            public List<?> call(IHowIsGoing monitor) {
                return pcbs;
            }
        });
        this.setTooltipList(new String[]{Messages.ImsPcbLookupDialog_PCBname, Messages.ImsPcbLookupDialog_PCBnameTooltip});
    }

    public ImsPcbLookupDialog(String[] initialPatternList, final ImsRegionConfig region, final ImsPsb psb) {
        super(pcbLabelList, pcbLookupColumnNames, new String[pcbLabelList.length], ImsPcb.class);
        Objects.requireNonNull(region, "Must provide a non-null region.");
        this.setItemProvider(new ContentLoader.ICallableWithProgress<List<?>>(){

            public List<?> call(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                return ImsTreeContent.loadPCBs(psb, region.getRegionType(), monitor);
            }
        });
        this.setTooltipList(new String[]{Messages.ImsPcbLookupDialog_PCBname, Messages.ImsPcbLookupDialog_PCBnameTooltip});
        this.setInitialPatternList(initialPatternList);
    }

    public ImsPcbLookupDialog(ImsRegionConfig region, ImsPsb psb) {
        this(new String[]{"", ""}, region, psb);
    }

    protected ViewerFilter[] getFilters() {
        return new ViewerFilter[]{new SubsystemViewerFilter()};
    }

    protected String getDialogName() {
        return Messages.ImsPcbLookupDialog_selectPCB;
    }

    public String getColumnText(Object item, int index) {
        return ImsPcbLookupDialog.getTableProperty(item, index);
    }

    private static String getTableProperty(Object element, int columnIndex) {
        if (element instanceof ImsPcb) {
            ImsPcb pcb = (ImsPcb)element;
            switch (columnIndex) {
                case 0: {
                    return pcb.getIndex();
                }
                case 1: {
                    return pcb.getName();
                }
                case 2: {
                    return pcb.getDbd().getName();
                }
                case 3: {
                    return pcb.getUseabilityNote();
                }
                case 4: {
                    return pcb.getSegp();
                }
                case 5: {
                    return pcb.getSegd();
                }
                case 6: {
                    return pcb.getType();
                }
                case 7: {
                    return pcb.getProcopts();
                }
                case 8: {
                    return pcb.getProcseq();
                }
            }
        } else if (element instanceof String) {
            return (String)element;
        }
        return "";
    }

    public DecoratingLabelProvider getLabelProvider() {
        return new ImsPcbDecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator());
    }

    public static ImsPcb promptForValidPcb(ImsRegionConfig imsRegionConfig, ImsPsb psb, ImsPcb pcb, String initialPattern) {
        Objects.requireNonNull(imsRegionConfig, "Must provide a non-null imsRegionConfig.");
        while (pcb == null) {
            ImsPcbLookupDialog lookupDialog = new ImsPcbLookupDialog(new String[]{"", initialPattern}, imsRegionConfig, psb);
            if (lookupDialog.open() != 0) {
                return null;
            }
            pcb = (ImsPcb)lookupDialog.getFirstSelectedObject();
        }
        return pcb;
    }

    protected boolean isSelectable(Object obj) {
        ImsPcb pcb;
        return obj instanceof ImsPcb && (pcb = (ImsPcb)obj).getUseabilityNote() == null;
    }

    protected String getSelectedName(ImsPcb item) {
        return item.getLabel();
    }

    protected static class ImsPcbDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public ImsPcbDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof ImsPcb) {
                ImsPcb pcb = (ImsPcb)element;
                if (pcb.getUseabilityNote() == null) {
                    return this.getImage(element);
                }
                return this.getImage(Display.getDefault().getSystemImage(8));
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof String)) {
                return ImsPcbLookupDialog.getTableProperty(element, columnIndex);
            }
            if (columnIndex == 0) {
                return (String)element;
            }
            return null;
        }
    }

    private static class SubsystemViewerFilter
    extends ViewerFilter {
        private SubsystemViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ImsPcb && parentElement instanceof PatternState) {
                ImsPcb pcb = (ImsPcb)element;
                PatternState input = (PatternState)parentElement;
                return ImsPcbLookupDialog.matchEscapedRegex((String)input.getPatternList()[0], (String)pcb.getName()) && ImsPcbLookupDialog.matchEscapedRegex((String)input.getPatternList()[1], (String)pcb.getDbd().getName());
            }
            return true;
        }
    }
}

