/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.ui.views.systems.model.ImsTreeContent;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.FastSortLookupDialog;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class ImsDatabaseLookupDialog
extends FastSortLookupDialog<ImsDatabase> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String[] psbLookupColumnNames = new String[]{Messages.ImsDatabaseLookupDialog_Database};
    private static final String[] psbLabelList = new String[]{Messages.ImsDatabaseLookupDialog_Database_};
    private final ImsRegionType regionType;
    private final ImsAccessMode accessMode;

    public ImsDatabaseLookupDialog(IPDHost system, ImsSubsystemConfig imsSubsystemConfig, String filter, ImsRegionType regionType, ImsAccessMode accessMode, String function) {
        String[] stringArray;
        if (Objects.requireNonNull(filter, "Must specify a non-null filter.").isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = filter;
        }
        this(system, stringArray, imsSubsystemConfig, "*", regionType, accessMode, function);
    }

    public ImsDatabaseLookupDialog(IPDHost system, String[] initialPatternList, final ImsSubsystemConfig imsSubsystemConfig, final String filter, final ImsRegionType regionType, final ImsAccessMode accessMode, final String function) {
        super(psbLabelList, psbLookupColumnNames, new String[psbLabelList.length], ImsDatabase.class);
        this.regionType = regionType;
        this.accessMode = accessMode;
        this.setItemProvider(new ContentLoader.ICallableWithProgress<List<?>>(){

            public List<?> call(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                return ImsTreeContent.loadDatabases(new ImsDatabaseQuery(imsSubsystemConfig.getSubsystem(), filter, regionType, accessMode), function, monitor);
            }
        });
        this.setTooltipList(new String[]{Messages.ImsDatabaseLookupDialog_databaseTooltip});
        this.setInitialPatternList(initialPatternList);
    }

    protected ViewerFilter[] getFilters() {
        return new ViewerFilter[]{new SubsystemViewerFilter()};
    }

    protected String getDialogName() {
        return Messages.ImsDatabaseLookupDialog_SelectDatabase;
    }

    public String getColumnText(Object item, int index) {
        return ImsDatabaseLookupDialog.getTableProperty(item, index);
    }

    private static String getTableProperty(Object element, int columnIndex) {
        if (element instanceof ImsDatabase) {
            ImsDatabase db = (ImsDatabase)element;
            return db.getName();
        }
        if (element instanceof String) {
            return (String)element;
        }
        return "";
    }

    public DecoratingLabelProvider getLabelProvider() {
        return new ImsDatabaseDecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator());
    }

    public static ImsDatabase promptForValidConfig(IPDHost host, ImsSubsystemConfig imsSubSystemConfig, ImsDatabase database, String filter, ImsRegionType regionType, ImsAccessMode accessMode, String function) {
        Objects.requireNonNull(filter, "Must specify a non-null filter.");
        while (database == null || database.getName().isEmpty()) {
            ImsDatabaseLookupDialog lookupDialog = new ImsDatabaseLookupDialog(host, imsSubSystemConfig, filter, regionType, accessMode == null ? ImsAccessMode.DYNAMIC : accessMode, function);
            if (lookupDialog.open() != 0) {
                logger.trace((Object)"User cancelled selecting an IMS database");
                return null;
            }
            database = (ImsDatabase)lookupDialog.getFirstSelectedObject();
        }
        return database;
    }

    protected boolean isSelectable(Object obj) {
        return obj instanceof ImsDatabase;
    }

    protected String getSelectedName(ImsDatabase item) {
        return item.getName();
    }

    protected static class ImsDatabaseDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public ImsDatabaseDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof ImsDatabase) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof String)) {
                return ImsDatabaseLookupDialog.getTableProperty(element, columnIndex);
            }
            if (columnIndex == 0) {
                return (String)element;
            }
            return null;
        }
    }

    private static class SubsystemViewerFilter
    extends ViewerFilter {
        private SubsystemViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ImsDatabase && parentElement instanceof PatternState) {
                ImsDatabase db = (ImsDatabase)element;
                PatternState input = (PatternState)parentElement;
                return ImsDatabaseLookupDialog.matchEscapedRegex((String)input.getPatternList()[0], (String)db.getName());
            }
            return true;
        }
    }
}

