/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Tablespace;
import com.ibm.etools.fm.core.model.db2.Db2TablespaceQuery;
import com.ibm.etools.fm.ui.dialog.lookup.Db2LookupDialog;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class Db2TablespaceLookupDialog
extends Db2LookupDialog<Db2Tablespace> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int NAME_INDEX = 0;
    private static final int CREATOR_INDEX = 1;
    private static final int DATABASE_INDEX = 2;
    private static final String[] tablespaceLookupColumnNames = new String[]{Messages.Db2TablespaceLookupDialog_Name, Messages.Db2TablespaceLookupDialog_Creator, Messages.Db2TablespaceLookupDialog_Database};
    private static final String[] tablespaceLabelList = new String[]{Messages.Db2TablespaceLookupDialog_Name_, Messages.Db2TablespaceLookupDialog_Creator_, Messages.Db2TablespaceLookupDialog_Database_};

    protected String getColumnText(Object element, int columnIndex) {
        return Db2TablespaceLookupDialog.getTableProperty(element, columnIndex);
    }

    private static String getTableProperty(Object element, int columnIndex) {
        if (element instanceof Db2Tablespace) {
            Db2Tablespace tablespace = (Db2Tablespace)element;
            switch (columnIndex) {
                case 0: {
                    return tablespace.getName();
                }
                case 1: {
                    return tablespace.getCreator();
                }
                case 2: {
                    return tablespace.getDatabase();
                }
            }
            logger.debug((Object)MessageFormat.format("Unable to get column text for column {0} for item ''{1}''", columnIndex, element));
            return "";
        }
        return "";
    }

    public DecoratingLabelProvider getLabelProvider() {
        return new Db2TableDecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator());
    }

    public Db2TablespaceLookupDialog(Db2Subsystem subsystem) {
        super(subsystem, tablespaceLabelList, tablespaceLookupColumnNames, new String[tablespaceLabelList.length], Db2Tablespace.class);
        ContentLoader.ICallableWithProgress itemProvider = new ContentLoader.ICallableWithProgress<List<?>>(){

            public List<?> call(IHowIsGoing monitor) throws CommunicationException, InterruptedException {
                Db2TablespaceQuery query = new Db2TablespaceQuery(Db2TablespaceLookupDialog.this.getDb2Subsystem(), Db2Tablespace.class);
                query.setOwnerPattern(Db2TablespaceLookupDialog.this.contentProvider.getNewInput().getPatternList()[1]);
                query.setNamePattern(Db2TablespaceLookupDialog.this.contentProvider.getNewInput().getPatternList()[0]);
                query.setDatabasePattern(Db2TablespaceLookupDialog.this.contentProvider.getNewInput().getPatternList()[2]);
                Result result = query.loadObjects(monitor);
                if (result.isSuccessfulWithoutWarnings()) {
                    return query.getObjects();
                }
                throw new CommunicationException("Error: Failed to load DB2 Tablespaces.");
            }
        };
        this.setItemProvider(itemProvider);
        this.setTooltipList(new String[]{Messages.Db2TablespaceLookupDialog_NameTooltip, Messages.Db2TablespaceLookupDialog_creatorTooltip, Messages.Db2TablespaceLookupDialog_databaseTooltip});
    }

    public void setInitialOwnerPattern(String ownerPattern) {
        this.initialPatternList[1] = ownerPattern;
    }

    public void setInitialNamePattern(String namePattern) {
        this.initialPatternList[0] = namePattern;
    }

    public void setInitialDatabasePattern(String databasePattern) {
        this.initialPatternList[2] = databasePattern;
    }

    @Override
    protected ViewerFilter[] getFilters() {
        return new ViewerFilter[]{new TableViewerFilter()};
    }

    protected String getDialogName() {
        return MessageFormat.format(Messages.Db2TablespaceLookupDialog_LookupForXObjects, Messages.Db2Tablespace_DB2Tablespace);
    }

    protected static class Db2TableDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public Db2TableDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof String)) {
                return Db2TablespaceLookupDialog.getTableProperty(element, columnIndex);
            }
            if (columnIndex == 0) {
                return (String)element;
            }
            return null;
        }
    }

    private static class TableViewerFilter
    extends ViewerFilter {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private TableViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Db2Tablespace && parentElement instanceof PatternState) {
                Db2Tablespace tablespace = (Db2Tablespace)element;
                PatternState input = (PatternState)parentElement;
                return Db2TablespaceLookupDialog.matchEscapedRegex((String)input.getPatternList()[1], (String)tablespace.getCreator()) && Db2TablespaceLookupDialog.matchEscapedRegex((String)input.getPatternList()[0], (String)tablespace.getName()) && Db2TablespaceLookupDialog.matchEscapedRegex((String)input.getPatternList()[2], (String)tablespace.getDatabase());
            }
            return true;
        }
    }
}

