/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TableQuery;
import com.ibm.etools.fm.ui.dialog.lookup.Db2LookupDialog;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class Db2TableLookupDialog
extends Db2LookupDialog<Db2Table> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int NAME_INDEX = 0;
    private static final int CREATOR_INDEX = 1;
    private static final int DATABASE_INDEX = 2;
    private static final int TYPE_INDEX = 3;
    private static final String[] tableLookupColumnNames = new String[]{Messages.Db2TableLookupDialog_Name, Messages.Db2TableLookupDialog_Creator, Messages.Db2TableLookupDialog_Database, Messages.Db2TableLookupDialog_Type};
    private static final String[] tableLabelList = new String[]{Messages.Db2TableLookupDialog_Name_, Messages.Db2TableLookupDialog_Creator_, Messages.Db2TableLookupDialog_Database_};

    protected String getColumnText(Object element, int columnIndex) {
        return Db2TableLookupDialog.getTableProperty(element, columnIndex);
    }

    private static String getTableProperty(Object element, int columnIndex) {
        if (element instanceof Db2Table) {
            Db2Table table = (Db2Table)element;
            switch (columnIndex) {
                case 0: {
                    return table.getName();
                }
                case 1: {
                    return table.getOwner();
                }
                case 2: {
                    return table.getDatabaseName();
                }
                case 3: {
                    return table.getType().getName();
                }
            }
            logger.debug((Object)MessageFormat.format("Unable to get column text for column {0} for item ''{1}''", columnIndex, element));
            return "";
        }
        return "";
    }

    public DecoratingLabelProvider getLabelProvider() {
        return new Db2TableDecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator());
    }

    public Db2TableLookupDialog(Db2Subsystem subsystem) {
        super(subsystem, tableLabelList, tableLookupColumnNames, new String[tableLabelList.length], Db2Table.class);
        ContentLoader.ICallableWithProgress itemProvider = new ContentLoader.ICallableWithProgress<List<?>>(){

            public List<?> call(IHowIsGoing monitor) throws CommunicationException, InterruptedException {
                Db2TableQuery query = new Db2TableQuery(Db2TableLookupDialog.this.getDb2Subsystem(), Db2Table.class);
                query.setOwnerPattern(Db2TableLookupDialog.this.contentProvider.getNewInput().getPatternList()[1]);
                query.setNamePattern(Db2TableLookupDialog.this.contentProvider.getNewInput().getPatternList()[0]);
                query.setDatabasePattern(Db2TableLookupDialog.this.contentProvider.getNewInput().getPatternList()[2]);
                Result result = query.loadObjects(monitor);
                if (result.isSuccessfulWithoutWarnings()) {
                    return query.getObjects();
                }
                throw new CommunicationException("Error: Failed to load DB2 Tables.");
            }
        };
        this.setItemProvider(itemProvider);
        this.setTooltipList(new String[]{Messages.Db2TableLookupDialog_NameTooltip, Messages.Db2TableLookupDialog_CreatorTooltip, Messages.Db2TableLookupDialog_DatabaseTooltip});
    }

    public void setInitialOwnerPattern(String ownerPattern) {
        this.initialPatternList[1] = ownerPattern;
    }

    public void setInitialNamePattern(String namePattern) {
        this.initialPatternList[0] = namePattern;
    }

    public void setInitialDatabasePattern(String databasePattern) {
        this.initialPatternList[2] = databasePattern;
    }

    @Override
    protected ViewerFilter[] getFilters() {
        return new ViewerFilter[]{new TableViewerFilter()};
    }

    protected String getDialogName() {
        return MessageFormat.format(Messages.Db2TableLookupDialog_LookupForXObjects, Messages.Db2Table_DB2Table);
    }

    protected static class Db2TableDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public Db2TableDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof Db2Table) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof String)) {
                return Db2TableLookupDialog.getTableProperty(element, columnIndex);
            }
            if (columnIndex == 0) {
                return (String)element;
            }
            return null;
        }
    }

    private static class TableViewerFilter
    extends ViewerFilter {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private TableViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Db2Table && parentElement instanceof PatternState) {
                Db2Table table = (Db2Table)element;
                PatternState input = (PatternState)parentElement;
                return Db2TableLookupDialog.matchEscapedRegex((String)input.getPatternList()[1], (String)table.getOwner()) && Db2TableLookupDialog.matchEscapedRegex((String)input.getPatternList()[0], (String)table.getName()) && Db2TableLookupDialog.matchEscapedRegex((String)input.getPatternList()[2], (String)table.getDatabaseName());
            }
            return true;
        }
    }
}

