/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemQuery;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.FastSortLookupDialog;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class Db2SubsystemLookupDialog
extends FastSortLookupDialog<Db2Subsystem> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String[] subsystemLookupColumnNames = new String[]{Messages.Db2SubsystemLookupDialog_Name, Messages.Db2SubsystemLookupDialog_Description, Messages.Db2SubsystemLookupDialog_0};
    private static final String[] subsystemLabelList = new String[]{Messages.Db2SubsystemLookupDialog_Name_};

    public Db2SubsystemLookupDialog(IPDHost system) {
        this(Objects.requireNonNull(system, "Must provide a non-null system."), new String[]{""});
    }

    public Db2SubsystemLookupDialog(final IPDHost system, String[] initialPatternList) {
        super(subsystemLabelList, subsystemLookupColumnNames, new String[subsystemLabelList.length], Db2Subsystem.class);
        Objects.requireNonNull(system, "Must provide a non-null system.");
        ContentLoader.ICallableWithProgress itemProvider = new ContentLoader.ICallableWithProgress<List<?>>(){

            public List<?> call(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Db2SubsystemQuery query = Db2SubsystemQuery.createForHost((IPDHost)system);
                Result result = query.loadSubsystems(monitor);
                if (result.isSuccessfulWithoutWarnings()) {
                    return query.getSubsystems();
                }
                throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, result.getMessagesCombined().toString()));
            }
        };
        this.setItemProvider(itemProvider);
        this.setTooltipList(new String[]{Messages.Db2SubsystemLookupDialog_subsystemTooltip});
        this.setInitialPatternList(initialPatternList);
    }

    protected ViewerFilter[] getFilters() {
        return new ViewerFilter[]{new SubsystemViewerFilter()};
    }

    protected String getDialogName() {
        return Messages.Db2SubsystemLookupDialog_DialogName;
    }

    public String getColumnText(Object item, int index) {
        return Db2SubsystemLookupDialog.getTableProperty(item, index);
    }

    private static String getTableProperty(Object element, int columnIndex) {
        if (element instanceof Db2Subsystem) {
            Db2Subsystem subsystem = (Db2Subsystem)element;
            switch (columnIndex) {
                case 0: {
                    return subsystem.getName();
                }
                case 1: {
                    return subsystem.getDescription();
                }
                case 2: {
                    return "" + subsystem.getCanConnect();
                }
            }
            logger.debug((Object)MessageFormat.format("Unable to get column text for column {0} for item ''{1}''", columnIndex, element));
            return "";
        }
        return "";
    }

    public DecoratingLabelProvider getLabelProvider() {
        return new Db2SubsystemDecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator());
    }

    protected String getSelectedName(Db2Subsystem item) {
        return item.getFormattedName();
    }

    protected boolean isSelectable(Object obj) {
        Db2Subsystem db;
        return obj instanceof Db2Subsystem && (db = (Db2Subsystem)obj).getCanConnect();
    }

    protected static class Db2SubsystemDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public Db2SubsystemDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof Db2Subsystem) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof String)) {
                return Db2SubsystemLookupDialog.getTableProperty(element, columnIndex);
            }
            if (columnIndex == 0) {
                return (String)element;
            }
            return null;
        }
    }

    private static class SubsystemViewerFilter
    extends ViewerFilter {
        private SubsystemViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Db2Subsystem && parentElement instanceof PatternState) {
                Db2Subsystem subsystem = (Db2Subsystem)element;
                PatternState input = (PatternState)parentElement;
                return Db2SubsystemLookupDialog.matchEscapedRegex((String)input.getPatternList()[0], (String)subsystem.getName());
            }
            return true;
        }
    }
}

