/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Schema;
import com.ibm.etools.fm.core.model.db2.Db2SchemaQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.ui.dialog.lookup.Db2LookupDialog;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class Db2SchemaLookupDialog
extends Db2LookupDialog<Db2Schema> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int NAME_INDEX = 0;
    private static final String[] schemaLookupColumnNames = new String[]{Messages.Db2SchemaLookupDialog_Name};
    private static final String[] schemaLabelList = new String[]{Messages.Db2SchemaLookupDialog_Name_};

    protected String getColumnText(Object element, int columnIndex) {
        return Db2SchemaLookupDialog.getTableProperty(element, columnIndex);
    }

    private static String getTableProperty(Object element, int columnIndex) {
        if (!(element instanceof String)) {
            Db2Schema schema = (Db2Schema)element;
            switch (columnIndex) {
                case 0: {
                    return schema.getName();
                }
            }
            logger.debug((Object)MessageFormat.format("Unable to get column text for column {0} for item ''{1}''", columnIndex, element));
            return "";
        }
        return "";
    }

    public DecoratingLabelProvider getLabelProvider() {
        return new Db2DatabaseDecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator());
    }

    public Db2SchemaLookupDialog(Db2Subsystem subsystem) {
        super(subsystem, schemaLabelList, schemaLookupColumnNames, new String[schemaLabelList.length], Db2Schema.class);
        ContentLoader.ICallableWithProgress itemProvider = new ContentLoader.ICallableWithProgress<List<?>>(){

            public List<?> call(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Db2SchemaQuery query = new Db2SchemaQuery(Db2SchemaLookupDialog.this.getDb2Subsystem(), Db2Schema.class);
                query.setNamePattern(Db2SchemaLookupDialog.this.contentProvider.getNewInput().getPatternList()[0]);
                Result result = query.loadObjects(monitor);
                if (result.isSuccessfulWithoutWarnings()) {
                    return query.getObjects();
                }
                throw new CommunicationException("Error: Failed to load DB2 Schemas.");
            }
        };
        this.setItemProvider(itemProvider);
        this.setTooltipList(new String[]{Messages.Db2SchemaLookupDialog_NameTooltip});
    }

    public void setInitialNamePattern(String namePattern) {
        this.initialPatternList[0] = namePattern;
    }

    @Override
    protected ViewerFilter[] getFilters() {
        return new ViewerFilter[]{new DatabaseViewerFilter()};
    }

    protected String getDialogName() {
        return MessageFormat.format(Messages.Db2SchemaLookupDialog_LookupForXObjects, Messages.Db2Schema_DB2Schema);
    }

    private static class DatabaseViewerFilter
    extends ViewerFilter {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private DatabaseViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Db2Schema && parentElement instanceof PatternState) {
                Db2Schema schema = (Db2Schema)element;
                PatternState input = (PatternState)parentElement;
                return Db2SchemaLookupDialog.matchEscapedRegex((String)input.getPatternList()[0], (String)schema.getName());
            }
            return true;
        }
    }

    protected static class Db2DatabaseDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public Db2DatabaseDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof String)) {
                return Db2SchemaLookupDialog.getTableProperty(element, columnIndex);
            }
            if (columnIndex == 0) {
                return (String)element;
            }
            return null;
        }
    }
}

