/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Routine;
import com.ibm.etools.fm.core.model.db2.Db2RoutineQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.dialog.lookup.Db2LookupDialog;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class Db2RoutineLookupDialog
extends Db2LookupDialog<Db2Routine> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int NAME_INDEX = 0;
    private static final int CREATOR_INDEX = 1;
    private static final int ROUTINE_TYPE_INDEX = 2;
    private static final int ROUTINE_LANGUAGE_INDEX = 3;
    private static final String[] routineLookupColumnNames = new String[]{Messages.Db2RoutineLookupDialog_Name, Messages.Db2RoutineLookupDialog_Schema, Messages.Db2RoutineLookupDialog_RoutineType, Messages.Db2RoutineLookupDialog_RoutineLanguage};
    private static final String[] routineLabelList = new String[]{Messages.Db2RoutineLookupDialog_Name_, Messages.Db2RoutineLookupDialog_Schema_};

    protected String getColumnText(Object element, int columnIndex) {
        return Db2RoutineLookupDialog.getTableProperty(element, columnIndex);
    }

    private static String getTableProperty(Object element, int columnIndex) {
        if (element instanceof Db2Routine) {
            Db2Routine routine = (Db2Routine)element;
            switch (columnIndex) {
                case 0: {
                    return routine.getName();
                }
                case 1: {
                    return routine.getCreator();
                }
                case 2: {
                    return routine.getRoutineType();
                }
                case 3: {
                    return routine.getRoutineLanguage();
                }
            }
            logger.debug((Object)MessageFormat.format("Unable to get column text for column {0} for item ''{1}''", columnIndex, element));
            return "";
        }
        return "";
    }

    public DecoratingLabelProvider getLabelProvider() {
        return new Db2RoutineDecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator());
    }

    public Db2RoutineLookupDialog(Db2Subsystem subsystem) {
        super(subsystem, routineLabelList, routineLookupColumnNames, new String[routineLabelList.length], Db2Routine.class);
        ContentLoader.ICallableWithProgress itemProvider = new ContentLoader.ICallableWithProgress<List<?>>(){

            public List<?> call(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Db2RoutineQuery query = new Db2RoutineQuery(Db2RoutineLookupDialog.this.getDb2Subsystem(), Db2Routine.class);
                query.setOwnerPattern(Db2RoutineLookupDialog.this.contentProvider.getNewInput().getPatternList()[1]);
                query.setNamePattern(Db2RoutineLookupDialog.this.contentProvider.getNewInput().getPatternList()[0]);
                Result result = query.loadObjects(monitor);
                if (result.isSuccessfulWithoutWarnings()) {
                    return query.getObjects();
                }
                throw new CommunicationException("Error: Failed to load DB2 Routines.");
            }
        };
        this.setItemProvider(itemProvider);
        this.setTooltipList(new String[]{Messages.Db2RoutineLookupDialog_NameTooltip, Messages.Db2RoutineLookupDialog_SchemaTooltip});
    }

    public void setInitialOwnerPattern(String ownerPattern) {
        this.initialPatternList[1] = ownerPattern;
    }

    public void setInitialNamePattern(String namePattern) {
        this.initialPatternList[0] = namePattern;
    }

    @Override
    protected ViewerFilter[] getFilters() {
        return new ViewerFilter[]{new RoutineViewerFilter()};
    }

    protected String getDialogName() {
        return MessageFormat.format(Messages.Db2RoutineLookupDialog_LookupForXObjects, Messages.Db2Routine_DB2Routine);
    }

    protected static class Db2RoutineDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public Db2RoutineDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof Db2Table) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof String)) {
                return Db2RoutineLookupDialog.getTableProperty(element, columnIndex);
            }
            if (columnIndex == 0) {
                return (String)element;
            }
            return null;
        }
    }

    private static class RoutineViewerFilter
    extends ViewerFilter {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private RoutineViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Db2Routine && parentElement instanceof PatternState) {
                Db2Routine routine = (Db2Routine)element;
                PatternState input = (PatternState)parentElement;
                return Db2RoutineLookupDialog.matchEscapedRegex((String)input.getPatternList()[1], (String)routine.getCreator()) && Db2RoutineLookupDialog.matchEscapedRegex((String)input.getPatternList()[0], (String)routine.getName());
            }
            return true;
        }
    }
}

