/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.dialog.lookup.FastSortLookupDialog;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ViewerFilter;

public abstract class Db2LookupDialog<T extends Db2Object>
extends FastSortLookupDialog<T> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Db2Subsystem db2Subsystem;

    public Db2LookupDialog(Db2Subsystem subsystem, String[] labelList, String[] colNames, String[] initialPatternList, Class<T> db2ObjectType) {
        super(labelList, colNames, initialPatternList, db2ObjectType);
        this.db2Subsystem = Objects.requireNonNull(subsystem, "Must provide a non-null subsystem");
    }

    public int open() {
        AuthDetails login = null;
        try {
            login = this.getDb2Subsystem().getSystem().getLogin(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (login == null) {
            logger.trace((Object)"User didn't provide login details for resource lookup");
            return 1;
        }
        if (this.getLabelList()[0].isEmpty()) {
            this.getLabelList()[0] = login.getUsername();
        }
        return super.open();
    }

    protected boolean isFilteredSubset(PatternState newInput, PatternState loadedInput) {
        if (newInput == null || loadedInput == null) {
            return false;
        }
        boolean isSubset = true;
        int i = 0;
        while (i < newInput.getPatternList().length) {
            String escapedInput = newInput.getPatternList()[i].replaceAll(StringUtils.escapeRegex((String)"*"), "");
            Pattern p = Db2LookupDialog.getRegexForm((String)loadedInput.getPatternList()[i]);
            isSubset = isSubset && p.matcher(escapedInput).matches();
            ++i;
        }
        return isSubset;
    }

    protected abstract ViewerFilter[] getFilters();

    public Db2Subsystem getDb2Subsystem() {
        return this.db2Subsystem;
    }
}

